    MODULE constants_marspem_mod


    IMPLICIT NONE


! Molecular masses for CO2,H2O and non condensible gaz, following Franz et al. 2017    
       REAL,PARAMETER :: m_co2 = 44.01E-3  ! CO2 molecular mass (kg/mol)   
       REAL,PARAMETER :: m_noco2 = 33.37E-3  ! Non condensible mol mass (kg/mol)   
       REAL,PARAMETER :: m_h2o = 18.01528E-3      ! Molecular weight of h2o (kg/mol)

!     Coefficient for Clapeyron law for CO2 condensation temperature (Tco2 = beta/(alpha-log(vmr)),following James et al. 1992
      REAL,PARAMETER :: alpha_clap_co2 = 23.3494  !Uniteless,James et al. 1992
      REAL,PARAMETER :: beta_clap_co2 = 3182.48   !Kelvin, James et al. 1992

!     Coefficient for Clapeyron law for psat(psat = exp(beta/Th2o+alpha)),following Murphie and Kood 2005
      REAL,PARAMETER :: alpha_clap_h2o = 28.9074  ! Uniteless, Murphie and Kood 2005
      REAL,PARAMETER :: beta_clap_h2o = -6143.7   ! Kelvin, Murphie and Kood 2005

!     Density of the regolith (Zent et al., 1995, Buhler and Piqueux 2021)     
      REAL,PARAMETER ::  rho_regolith = 2000.     ! kg/m^3

!     Average  Thermal inertia of the surface, breccia, bedrock, following Mellon et al., 2000., Wood et al., 2008
      REAL,PARAMETER :: TI_regolith_avg = 250.        ! Averaged of the observed thermal inertia for regolith following Mellon et al., 2000[SI]
      REAL,PARAMETER :: TI_breccia = 750.             ! Thermal inertia of Breccia following Wood 2009 [SI]
      REAL,PARAMETER :: TI_bedrock = 2300.            ! Thermal inertia of Bedrock following Wood 2009 [SI]

!     Stefan Boltzmann constant
      REAL,PARAMETER :: sigmaB=5.678E-8 

!     Latent heat of CO2
      REAL,PARAMETER ::  Lco2 =  5.71E5                ! Pilorget and Forget 2016


    END MODULE constants_marspem_mod

