!
! $Id $
!
SUBROUTINE recomp_tend_co2_slope(tendencies_co2_ice_phys,tendencies_co2_ice_phys_ini,co2ice_slope,vmr_co2_gcm,vmr_co2_pem,ps_GCM_2,global_ave_press_GCM,global_ave_press_new,timelen,ngrid,nslope)

      use constants_marspem_mod, only : alpha_clap_co2, beta_clap_co2, sigmaB,Lco2

      IMPLICIT NONE

!=======================================================================
!
!  Routine that compute the evolution of the tendencie for co2 ice
!
!=======================================================================

!   arguments:
!   ----------

!   INPUT
  INTEGER, intent(in) :: timelen,ngrid,nslope
  REAL, INTENT(in) ::  vmr_co2_gcm(ngrid,timelen)                ! physical point field : Volume mixing ratio of co2 in the first layer
  REAL, INTENT(in) ::  vmr_co2_pem(ngrid,timelen)                ! physical point field : Volume mixing ratio of co2 in the first layer
  REAL, intent(in) :: ps_GCM_2(ngrid,timelen)                 ! physical point field : Surface pressure in the GCM
  REAL, intent(in) :: global_ave_press_GCM
  REAL, intent(in) :: global_ave_press_new
  REAL, intent(in) ::  tendencies_co2_ice_phys_ini(ngrid,nslope) ! physical point field : Evolution of perenial ice over one year
  REAL, intent(in) :: co2ice_slope(ngrid,nslope)

!   OUTPUT
  REAL, intent(inout) ::  tendencies_co2_ice_phys(ngrid,nslope) ! physical point field : Evolution of perenial ice over one year

!   local:
!   ----

  INTEGER :: i,t,islope
  REAL :: eps, coef, ave

  eps=0.95
  coef=669*88875*eps*sigmaB/Lco2

! Evolution of the water ice for each physical point
  do i=1,ngrid
    do islope=1,nslope
      ave=0.
!      if(abs(tendencies_co2_ice_phys(i,islope)).gt.1e-4) then
      if(co2ice_slope(i,islope).gt.1e-4 .and. abs(tendencies_co2_ice_phys(i,islope)).gt.1e-5) then
        do t=1,timelen
           ave=ave+(beta_clap_co2/(alpha_clap_co2-log(vmr_co2_gcm(i,t)*ps_GCM_2(i,t)/100.)))**4  &
              -(beta_clap_co2/(alpha_clap_co2-log(vmr_co2_pem(i,t)*ps_GCM_2(i,t)*(global_ave_press_new/global_ave_press_GCM)/100.)))**4
         enddo
      endif
      if(ave.lt.1e-4) ave = 0.
      tendencies_co2_ice_phys(i,islope)=tendencies_co2_ice_phys_ini(i,islope)-coef*ave/timelen
    enddo
  enddo

END SUBROUTINE recomp_tend_co2_slope
