MODULE write_output_mod
    IMPLICIT NONE
PRIVATE
    
    INTERFACE write_output
      MODULE PROCEDURE write_output_d0,write_output_d1,write_output_d2,write_output_d3
    END INTERFACE write_output

    PUBLIC write_output
    
CONTAINS

  SUBROUTINE write_output_d0(field_name,title,units,field)
  ! For a surface field
  IMPLICIT NONE
  include "dimensions.h"
  INTEGER ngrid
  PARAMETER( ngrid = 2+(jjm-1)*iim - 1/jjm   )
  CHARACTER(LEN=*),INTENT(IN)    :: field_name
  CHARACTER(LEN=*),INTENT(IN)    :: title
  CHARACTER(LEN=*),INTENT(IN)    :: units
  REAL,INTENT(IN)                :: field
  
  call writediagfi(ngrid,field_name,title,units,0,field)
#ifdef CPP_XIOS 
  call send_xios_field(field_name,field)
#endif
  
  END SUBROUTINE write_output_d0

  SUBROUTINE write_output_d1(field_name,title,units,field)
  ! For a surface field
  use comsoil_h, only: nsoilmx
  use writediagsoil_mod, only: writediagsoil
  IMPLICIT NONE
  include "dimensions.h"
  INTEGER ngrid
  PARAMETER( ngrid = 2+(jjm-1)*iim - 1/jjm   )
  CHARACTER(LEN=*),INTENT(IN)    :: field_name
  CHARACTER(LEN=*),INTENT(IN)    :: title
  CHARACTER(LEN=*),INTENT(IN)    :: units
  REAL,INTENT(IN)                :: field(:)
 
  call writediagfi(ngrid,field_name,title,units,2,field)
#ifdef CPP_XIOS 
  call send_xios_field(field_name,field)
#endif
  
  END SUBROUTINE write_output_d1

  SUBROUTINE write_output_d2(field_name,title,units,field)
  ! For a "3D" horizontal-vertical field
  use comsoil_h, only: nsoilmx
  use writediagsoil_mod, only: writediagsoil
  IMPLICIT NONE
  include "dimensions.h"
  INTEGER ngrid
  PARAMETER( ngrid = 2+(jjm-1)*iim - 1/jjm   )
  CHARACTER(LEN=*),INTENT(IN)    :: field_name
  CHARACTER(LEN=*),INTENT(IN)    :: title
  CHARACTER(LEN=*),INTENT(IN)    :: units
  REAL,INTENT(IN)                :: field(:,:)

  if(size(field(:,:),2).eq.nsoilmx) then
    call writediagsoil(ngrid,field_name,title,units,3,field)
  else 
    call writediagfi(ngrid,field_name,title,units,3,field(:,:))
  endif
#ifdef CPP_XIOS 
  call send_xios_field(field_name,field)
#endif
  
  END SUBROUTINE write_output_d2

  SUBROUTINE write_output_d3(field_name,title,units,field)
  ! For a "4D" field surf/alt/??
  use comsoil_h, only: nsoilmx
  use writediagsoil_mod, only: writediagsoil
  IMPLICIT NONE
  include "dimensions.h"
  INTEGER ngrid
  PARAMETER( ngrid = 2+(jjm-1)*iim - 1/jjm   )
  CHARACTER(LEN=*),INTENT(IN)    :: field_name
  CHARACTER(LEN=*),INTENT(IN)    :: title
  CHARACTER(LEN=*),INTENT(IN)    :: units
  REAL,INTENT(IN)                :: field(:,:,:)

  if(size(field(:,:,:),3).eq.nsoilmx) then
    call writediagsoil(ngrid,field_name,title,units,4,field)
  else 
    call writediagfi(ngrid,field_name,title,units,4,field)
  endif
#ifdef CPP_XIOS 
  call send_xios_field(field_name,field)
#endif
  
  END SUBROUTINE write_output_d3

END MODULE write_output_mod
