MODULE conf_pem_mod

IMPLICIT NONE

CONTAINS

  SUBROUTINE conf_pem

#ifdef CPP_IOIPSL
  use IOIPSL, only: getin
#else
  ! if not using IOIPSL, we still need to use (a local version of) getin
  use ioipsl_getincom, only: getin
#endif
  
  USE temps_mod_evol, ONLY: year_bp_ini, dt_pem, water_ice_criterion, co2_ice_criterion, ps_criterion, &
                Max_iter_pem, evol_orbit_pem,var_obl, var_ex, var_lsp
  USE comsoil_h_pem, only: soil_pem,fluxgeo,water_reservoir_nom
  USE adsorption_mod,only: adsorption_pem
  CHARACTER(len=20),parameter :: modname ='conf_pem' 

!PEM parameter

  year_bp_ini=0.
  CALL getin('year_bp_ini', year_bp_ini)

  dt_pem=1
  CALL getin('dt_pem', dt_pem)

  water_ice_criterion=0.2
  CALL getin('water_ice_criterion', water_ice_criterion)

  co2_ice_criterion=0.2
  CALL getin('co2_ice_criterion', co2_ice_criterion)

  ps_criterion = 0.15
  CALL getin('ps_criterion',ps_criterion)

  evol_orbit_pem=.false.
  CALL getin('evol_orbit_pem', evol_orbit_pem)

  Max_iter_pem=99999999
  CALL getin('Max_iter_pem', Max_iter_pem)

  soil_pem=.true.
  CALL getin('soil_pem', soil_pem)

  adsorption_pem = .true.
  CALL getin('adsorption_pem',adsorption_pem)

  fluxgeo = 0.
  CALL getin('Fluxgeo_PEM',fluxgeo)
  print*,'Flux Geothermal is set to',fluxgeo

  var_obl = .true.
  CALL getin('var_obl',var_obl)

  var_ex = .true.
  CALL getin('var_ex',var_ex)

  var_lsp = .true.
  CALL getin('var_lsp',var_lsp)

  if ((not(soil_pem)).and.adsorption_pem) then
       print*,'Adsorption must be used when soil_pem = T'
       call abort_physic(modname,"Adsorption must be used when soil_pem = T",1)
  endif
  
  if ((not(soil_pem)).and.fluxgeo.gt.0.) then
       print*,'Soil is not activated but Flux Geo > 0.'
       call abort_physic(modname,"Soil is not activated but Flux Geo > 0.'",1)
  endif

  if (evol_orbit_pem.and.year_bp_ini.eq.0.) then
       print*,'You want to follow the file ob_ex_lsp.asc for changing orb parameters,'
       print*,'but you did not specify from which year to start.'
       call abort_physic(modname,"evol_orbit_pem=.true. but year_bp_ini=0",1)
  endif
  
   water_reservoir_nom = 1e4
  CALL getin('water_reservoir_nom',water_reservoir_nom)
  END SUBROUTINE conf_pem

END MODULE conf_pem_mod
