!WRF:MODEL_LAYER:CONSTANTS
!

 MODULE module_model_constants
   !  2. Following are constants for use in defining real number bounds.

   !  A really small number.

   REAL    , PARAMETER :: epsilon         = 1.E-15

   !  4. Following is information related to the physical constants.

   !  These are the physical parameters used within the model.
   character(len=15) :: planet ! In generic model, to know which physics is used
!JL22 Because we deal with different planets, many variables below have the PARAMETER attribute
! in WRF, but are now simple variables that will be initialized at runtime in init_module_model_constants.
! These are the ones with a commented value or definition on the right.
! for the moment we leave the water constants untouched, but we may
! change that for other condensible substances.


! JM NOTE -- can we name this grav instead?
   REAL :: g != 9.81  ! acceleration due to gravity (m {s}^-2)

   REAL :: r_d !         = 287.       ! gas constant of dry air (J deg^-1 kg^-1)
   REAL :: cp !          = 7.*r_d/2.  ! 

   REAL    , PARAMETER :: r_v          = 461.6      ! gas constant for water vapor (J deg^-1 kg^-1)
   REAL :: cv !          = cp-r_d     ! Specific heat of air at contant volume (J deg^-1 kg^-1)
   REAL :: cpv !         = 4.*r_v
   REAL :: cvv !         = cpv-r_v    ! 
   REAL :: cvpm !        = -cv/cp
   REAL    , PARAMETER :: cliq         = 4190.      ! specific heat of liquid water at 0^oC
   REAL    , PARAMETER :: cice         = 2106.      ! specific heat of ice at 0^oC
   REAL    , PARAMETER :: psat         = 610.78
   REAL :: rcv !         = r_d/cv     ! 
   REAL :: rcp !         = r_d/cp
   REAL :: rovg !        = r_d/g
   REAL :: c2 !          = cp * rcv
   REAL :: mwdry !       = 28.966     ! molecular weight of dry air (g/mole)

   REAL :: p1000mb !     = 100000.    ! pressure at 1000 hPa (pa)
   REAL :: t0 !          = 300.       ! base state tempertaure (K) 
   REAL :: p0 !          = p1000mb    ! base state surface pressure (pa)
   REAL :: cpovcv !      = cp/(cp-r_d)
   REAL :: cvovcp !      = 1./cpovcv
   REAL :: rvovrd !      = r_v/r_d

   REAL :: reradius !     = 1./6370.0e03  ! reciprocal of earth radius (m^-1) 

   REAL    , PARAMETER :: asselin      = .025
!   REAL    , PARAMETER :: asselin      = .0
   REAL    , PARAMETER :: cb           = 25.

   REAL    , PARAMETER :: XLV0         = 3.15E6       !  constant defined for calculation of latent heating 
   REAL    , PARAMETER :: XLV1         = 2370.        !  constant defined for calculation of latent heating 
   REAL    , PARAMETER :: XLS0         = 2.905E6      !  constant defined for calculation of latent heating
   REAL    , PARAMETER :: XLS1         = 259.532      !  constant defined for calculation of latent heating

   REAL    , PARAMETER :: XLS          = 2.85E6      ! latent heat of sublimation of water at 0^oC (J kg^-1) 
   REAL    , PARAMETER :: XLV          = 2.5E6       ! latent heat of vaporization of water at 0^oC (J kg^-1)
   REAL    , PARAMETER :: XLF          = 3.50E5      ! latent heat of fusion of water at 0^oC (J kg^-1)

   REAL    , PARAMETER :: rhowater     = 1000.       ! density of liquid water at 0^oC (kg m^-3)
   REAL    , PARAMETER :: rhosnow      = 100.        ! density of snow (kg m^-3)
   REAL    , PARAMETER :: rhoair0      = 1.28        ! density of dry air at 0^oC and 1000mb pressure (kg m^-3)
       !JL22 should be 0.02kg/m3 for mars, but is it used ? 

   REAL    , PARAMETER :: RE_QC_BG     = 2.49E-6     ! effective radius of cloud for background (m)
   REAL    , PARAMETER :: RE_QI_BG     = 4.99E-6     ! effective radius of ice for background (m)
   REAL    , PARAMETER :: RE_QS_BG     = 9.99E-6     ! effective radius of snow for background (m)
!
! Now namelist-specified parameter: ccn_conc - RAS
!   REAL    , PARAMETER :: n_ccn0       = 1.0E8
!
   REAL    , PARAMETER :: piconst      = 3.1415926535897932384626433    ! constant of PI
   REAL    , PARAMETER :: DEGRAD       = piconst/180.                   ! radians per degree
   REAL    , PARAMETER :: DPD          = 360./365. ! longitude solaire d'un jour?
       !JL22 should be 360./669. on Mars, but is it used ? 

   REAL    , PARAMETER ::  SVP1=0.6112      ! constant for saturation vapor pressure calculation (dimensionless)
   REAL    , PARAMETER ::  SVP2=17.67       ! constant for saturation vapor pressure calculation (dimensionless)
   REAL    , PARAMETER ::  SVP3=29.65       ! constant for saturation vapor pressure calculation (K)
   REAL    , PARAMETER ::  SVPT0=273.15     ! constant for saturation vapor pressure calculation (K)
   REAL ::  EP_1 !=R_v/R_d-1.  !  constant for virtual temperature (r_v/r_d - 1) (dimensionless)
   REAL ::  EP_2 !=R_d/R_v     ! constant for specific humidity calculation (dimensionless)
   REAL    , PARAMETER ::  KARMAN=0.4               ! von Karman constant
   REAL ::  EOMEG !=7.2921E-5          ! angular velocity of rotation (rad^-1)
   REAL    , PARAMETER ::  STBOLT=5.67051E-8        ! Stefan-Boltzmann constant (W m^-2 deg^-4) 

   REAL    , PARAMETER ::  prandtl = 1./3.0   ! prandtl's mixing length (m) 
                                              ! constants for w-damping option
   REAL    , PARAMETER ::  w_alpha = 0.3      ! strength m/s/s
   !JL22  w_alpha was 2.0 in AS implementation with WRFV3
   REAL    , PARAMETER ::  w_beta  = 1.0      ! activation cfl number
   !JL22  w_beta was 0.8 in AS implementation with WRFV3

       REAL , PARAMETER ::  pq0=379.90516     ! 
       REAL , PARAMETER ::  epsq2=0.2         ! initial TKE for camuw PBL scheme (m2 s^-2) 
       REAL , PARAMETER ::  a2=17.2693882
       REAL , PARAMETER ::  a3=273.16
       REAL , PARAMETER ::  a4=35.86
       REAL , PARAMETER ::  epsq=1.e-12      ! threshold specified for SPECIFIC HUMIDITY calculation in BMJ cumulus scheme (kg kg^-1)
       REAL ::  p608 !=rvovrd-1.
       REAL , PARAMETER ::  climit=1.e-20
       REAL , PARAMETER ::  cm1=2937.4
       REAL , PARAMETER ::  cm2=4.9283
       REAL , PARAMETER ::  cm3=23.5518
!       REAL , PARAMETER ::  defc=8.0
!       REAL , PARAMETER ::  defm=32.0
       REAL , PARAMETER ::  defc=0.0
       REAL , PARAMETER ::  defm=99999.0
       REAL , PARAMETER ::  epsfc=1./1.05
       REAL , PARAMETER ::  epswet=0.0
       REAL , PARAMETER ::  fcdif=1./3.
       REAL , PARAMETER ::  fcm=0.00003
       REAL ::  gma !=-r_d*(1.-rcp)*0.5
       REAL , PARAMETER ::  p400=40000.0
       REAL , PARAMETER ::  phitp=15000.0
       REAL , PARAMETER ::  pi2=2.*3.1415926, pi1=3.1415926
       REAL , PARAMETER ::  plbtm=105000.0
       REAL , PARAMETER ::  plomd=64200.0
       REAL , PARAMETER ::  pmdhi=35000.0
       REAL , PARAMETER ::  q2ini=0.50
       REAL ::  rfcp !=0.25/cp
       REAL , PARAMETER ::  rhcrit_land=0.75
       REAL , PARAMETER ::  rhcrit_sea=0.80
       REAL , PARAMETER ::  rlag=14.8125
       REAL , PARAMETER ::  rlx=0.90
       REAL , PARAMETER ::  scq2=50.0
       REAL , PARAMETER ::  slopht=0.001
       REAL , PARAMETER ::  tlc=2.*0.703972477
       REAL , PARAMETER ::  wa=0.15
       REAL , PARAMETER ::  wght=0.35
       REAL , PARAMETER ::  wpc=0.075
       REAL , PARAMETER ::  z0land=0.10    ! surface roughness length over land (m)
       REAL , PARAMETER ::  z0max=0.008    !  maximum roughness length (m)
       REAL , PARAMETER ::  z0sea=0.001   ! roughness length over ocean (m)

   !JL12 some new variables used in earth parametrizations
       REAL :: CAPA !=rcp
       REAL :: ELOCP
   !  Earth

   !  The value for P2SI *must* be set to 1.0 for Earth
   !  Although, now we may not need this declaration here (see above)
   !REAL    , PARAMETER :: P2SI         = 1.0

   !  Orbital constants:

   INTEGER , PARAMETER :: PLANET_YEAR = 365   ! number of days in a calendar year
   !JL22 this integer is only for calendar timekeeping in WRF, wo we keep it unchanged
   REAL :: PLANET_YEAR_REAL ! number of days in a year in the physics
   REAL :: OBLIQUITY != 23.5       ! solar obliquity (degree)
   REAL , PARAMETER :: ECCENTRICITY = 0.014   ! Orbital eccentricity 
   REAL , PARAMETER :: SEMIMAJORAXIS = 1.0    ! Ratio of semi-major axis of planet / semi-major axis of earth
   REAL , PARAMETER :: zero_date = 0.0        ! Time of perihelion passage
   REAL , PARAMETER :: EQUINOX_FRACTION= 0.0  ! Fraction into the year (from perhelion) of the occurrence of the Northern Spring Equinox

! 2012103
#if (EM_CORE == 1)
! for calls to set_tiles
   INTEGER, PARAMETER :: ZONE_SOLVE_EM = 1
   INTEGER, PARAMETER :: ZONE_SFS = 2
#endif

   !  These are the physical constants added in the LMDZ physcis

    REAL  :: wdaysec        ! duree du sol (s)  ~88775 s
    REAL  :: wperiheli      ! Dist.min. soleil-mars (Mkm) ~206.66      
    REAL  :: waphelie       ! Dist.max. soleil-mars (Mkm) ~249.22
    REAL  :: wperi_day      ! Date du perihelie (sols depuis printemps)
    REAL  :: wobliquit      ! Obliquite de la planete (deg) ~25.2
    REAL  :: wz0            ! surface roughness (m) ~0.01
    REAL  :: wlmixmin       ! longueur de melange ~100
    REAL  :: wemin_turb     ! energie minimale ~1.e-8 
    REAL  :: wemissiv       ! Emissivite du sol martien ~.95
    REAL  :: wemissiceN     !  Emissivite calotte nord
    REAL  :: wemissiceS     ! Emissivite calotte sud
    REAL  :: walbediceN     ! Albedo calotte nord !0.5
    REAL  :: walbediceS     ! Albedo calotte sud  !0.5
    REAL  :: wiceradiusN    ! mean scat radius of CO2 snow (north)
    REAL  :: wiceradiusS    ! mean scat radius of CO2 snow (south)
    REAL  :: wdtemisiceN    ! time scale for snow metamorphism (north) !2  
    REAL  :: wdtemisiceS    ! time scale for snow metamorphism (south) !2 
    REAL  :: wvolcapa       ! volumetric capacity of soil (new soil model)
    REAL  :: z_scale        ! scale height 

    REAL :: TT00
    REAL :: nu
 CONTAINS
 
 SUBROUTINE init_module_model_constants
    USE module_configure
    IMPLICIT NONE
    REAL :: rad ! radius of the planet (tmp to compute reradius)

    Call initial_config ! to read the namelist

    CALL nl_get_planet(1, planet )
    !JL22 Here are some constants that are probably not used for many planets
    ! so we initialize them to default values to avoid compiling issues
    PLANET_YEAR_REAL = PLANET_YEAR * 1.d0
    OBLIQUITY = 0.

    !  These are the physical constants used within the model
    
    IF ( planet == "mars" ) then 
! JM NOTE -- can we name this grav instead?
     g = 3.72  ! acceleration due to gravity (m {s}^-2)

!#if ( NMM_CORE == 1 )
!    REAL :: r_d          = 192.  ! gas constant m2 s-2 K-1
!    REAL :: cp           = 844.6   ! r= 8.314511E+0 *1000.E+0/mugaz
!#else
!    REAL :: r_d          = 192.
!    REAL :: cp           = 844.6
!#endif

     r_d          = 191.
     cp           = 744.5
     t0           = 220. ! earth : 300 ... � remplacer par 220 ?
     p0           = 610.
     p1000mb      = 610.
     reradius     = 1./3397200.	! Rayon de mars (m)  ~3397200 m
     EOMEG        =7.0721E-5 ! angular rotation rate (rad.s-1)
     wdaysec       = 88800.     ! duree du sol (s)  ~88775 s
     mwdry        = 43.49      ! Masse molaire de l'atm (g.mol-1) ~43.49
     EOMEG         = 7.0721E-5  ! omega (rad.s-1)
     PLANET_YEAR_REAL     = 669.       ! Duree de l'annee (sols) ~668.6
     wperiheli     = 206.66     ! Dist.min. soleil-mars (Mkm) ~206.66      
     waphelie      = 249.22     ! Dist.max. soleil-mars (Mkm) ~249.22
     wperi_day     = 485.       ! Date du perihelie (sols depuis printemps)
     OBLIQUITY     = 25.2       ! Obliquite de la planete (deg) ~25.2
     wz0           = 1.e-2      ! surface roughness (m) ~0.01
     wlmixmin      = 30.        ! longueur de melange ~100
     wemin_turb    = 1.e-6      ! energie minimale ~1.e-8 
     wemissiv      = 0.95       ! Emissivite du sol martien ~.95
     wemissiceN    = 0.95       ! Emissivite calotte nord
     wemissiceS    = 0.95       ! Emissivite calotte sud
     walbediceN    = 0.65        ! Albedo calotte nord !0.5
     walbediceS    = 0.65        ! Albedo calotte sud  !0.5
     wiceradiusN   = 100.e-6    ! mean scat radius of CO2 snow (north)
     wiceradiusS   = 100.e-6    ! mean scat radius of CO2 snow (south)
     wdtemisiceN   = 0.4  ! time scale for snow metamorphism (north) !2  
     wdtemisiceS   = 0.4  ! time scale for snow metamorphism (south) !2 
     wvolcapa      = 1.e6       ! volumetric capacity of soil (new soil model)
     TT00=0.
     nu=0.
!#endif
    ELSE if ( planet == "venus") then 
     g            = 8.87
     r_d          = 191.84383904727036
     !cpp          = 1000.
     cp           = 1000.
     t0           = 735. ! earth : 300
     p0           = 92.e5
     p1000mb      = 92.e5
     reradius     = 1./6051800.	! Rayon de venus (m)  ~6051800 m
     mwdry       = 43.49 
     EOMEG        = 0.2992549E-06
     wdaysec      = 0.1008707E08
     TT00=460.
     nu=0.35
    ELSE if ( planet == "titan") then
     g            = 1.35
     r_d          = 298.734319568
     cp           = 1038.72627727
     t0           = 94. ! earth : 300
     p0           = 146144.796875
     p1000mb      = 146144.796875
     reradius     = 1./2575500.0 ! Rayon de titan (m)  ~2575500.0 m
     mwdry       = 28.6
     EOMEG        = 0.2992549E-06 !!!!!!!!!!!!!!!!!!!
     wdaysec      = 1377665.28
     TT00=0.
     nu=0.
    ELSE if (( planet == "prescribed").or.(planet == "generic").or.(planet == "earth")) then
     open(17,file='planet_constant',form='formatted',status='old')
     rewind(17)
     read(17,*) g
     read(17,*) cp
     read(17,*) mwdry
     read(17,*) t0
     read(17,*) p0
     read(17,*) rad
     close(17)
     EOMEG = 0.d0
     r_d=8.314/(mwdry*1e-3)
     p1000mb=p0
     reradius=1./rad
     TT00=0.
     nu=0.
    ELSE 
     write(*,*) "unknown planet type:", planet
     stop
    endif
     cv           = cp-r_d
     cpv          = 3.9*r_v
     cvv          = cpv-r_v
     cvpm         = -cv/cp
     rcv          = r_d/cv
     rcp          = r_d/cp
     rovg         = r_d/g
     c2           = cp * rcv
     cpovcv       = cp/(cp-r_d)
     cvovcp       = 1./cpovcv
     rvovrd       = r_v/r_d
     gma          = -r_d*(1.-rcp)*0.5 
     EP_1         = r_v/r_d-1.
     EP_2         = r_d/r_v
     rfcp         =0.25/cp
     p608         =rvovrd-1.
     z_scale      =(r_d*t0/g)*1e-3
    write(*,*) "planet : ", planet
    write(*,*) "g = ", g
    write(*,*) "cp = ", cp
    write(*,*) "r_d = ", r_d
    write(*,*) "t0 = ", t0
    write(*,*) "p0 = ", p0
    write(*,*) "T0 = ", TT00
    write(*,*) "nu = ", nu

   !JL12 some new variables used in earth parametrizations
    CAPA = rcp
    ELOCP = 2.72E6/CP


   END SUBROUTINE init_module_model_constants
 END MODULE module_model_constants
