MODULE conf_pem_mod

IMPLICIT NONE

CONTAINS

  SUBROUTINE conf_pem

#ifdef CPP_IOIPSL
  use IOIPSL, only: getin
#else
  ! if not using IOIPSL, we still need to use (a local version of) getin
  use ioipsl_getincom, only: getin
#endif
  
  USE temps_mod_evol, ONLY: year_bp_ini, dt_pem, alpha_criterion, &
                Max_iter_pem, evol_orbit_pem
  USE comsoil_h_pem, only: soil_pem

  
!PEM parameter
  year_bp_ini=0.
  CALL getin('year_bp_ini', year_bp_ini)

  dt_pem=1
  CALL getin('dt_pem', dt_pem)

  alpha_criterion=0.2
  CALL getin('alpha_criterion', alpha_criterion)

  evol_orbit_pem=.false.
  CALL getin('evol_orbit_pem', evol_orbit_pem)

  Max_iter_pem=99999999
  CALL getin('Max_iter_pem', Max_iter_pem)

  soil_pem=.true.
  CALL getin('soil_pem', soil_pem)

  END SUBROUTINE conf_pem

END MODULE conf_pem_mod
