!
! $Id $
!
SUBROUTINE compute_tendencies_slope(tendencies_h2o_ice,min_h2o_ice_Y1,&
     min_h2o_ice_Y2,iim_input,jjm_input,ngrid,tendencies_h2o_ice_phys,nslope)

      IMPLICIT NONE

!=======================================================================
!
!  Compute the tendencies of the evolution of water ice over the years
!
!=======================================================================

!   arguments:
!   ----------

!   INPUT

     INTEGER, intent(in) :: iim_input,jjm_input,ngrid  ,nslope                           ! # of grid points along longitude/latitude/ total
     REAL, intent(in) , dimension(iim_input+1,jjm_input+1,nslope):: min_h2o_ice_Y1       ! LON x LAT field : minimum of water ice at each point for the first year
     REAL, intent(in) , dimension(iim_input+1,jjm_input+1,nslope):: min_h2o_ice_Y2       ! LON x LAT field : minimum of water ice at each point for the second year

!   OUTPUT
     REAL, intent(out) , dimension(iim_input+1,jjm_input+1,nslope) :: tendencies_h2o_ice ! LON x LAT field : difference between the minima = evolution of perenial ice
     REAL, intent(out) , dimension(ngrid,nslope)   :: tendencies_h2o_ice_phys            ! physical point field : difference between the minima = evolution of perenial ice

!   local:
!   ------

     INTEGER :: i,j,ig0,islope                                                           ! loop variable

!=======================================================================

!  We compute the difference

  DO j=1,jjm_input+1
    DO i = 1, iim_input
       DO islope = 1, nslope
         tendencies_h2o_ice(i,j,islope)=min_h2o_ice_Y2(i,j,islope)-min_h2o_ice_Y1(i,j,islope)
       enddo
    ENDDO
  ENDDO

!  If the difference is too small; there is no evolution
  DO j=1,jjm_input+1
    DO i = 1, iim_input
       DO islope = 1, nslope
         if(abs(tendencies_h2o_ice(i,j,islope)).LT.1.0E-10) then
            tendencies_h2o_ice(i,j,islope)=0.
         endif
       enddo
    ENDDO
  ENDDO

  DO islope = 1,nslope
    CALL gr_dyn_fi(1,iim_input+1,jjm_input+1,ngrid,tendencies_h2o_ice(:,:,islope),tendencies_h2o_ice_phys(:,islope))
  ENDDO

END SUBROUTINE compute_tendencies_slope

