      SUBROUTINE iniaerosol()


      use radinc_h, only: naerkind
      use aerosol_mod
      use tracer_h, only: n_rgcs, nqtot, is_rgcs
      use callkeys_mod, only: aeroco2,aeroh2o,dusttau,aeroh2so4,
     &		aeroback2lay,aeronh3, nlayaero, aeronlay, aeroaurora,
     &      aerogeneric

      IMPLICIT NONE
c=======================================================================
c   subject:
c   --------
c   Initialization related to aerosols 
c   (CO2 aerosols, dust, water, chemical species, ice...)   
c
c   author: Laura Kerber, S. Guerlet
c   ------
c        
c=======================================================================

      integer i, ia, iq

      ! Special case, dyn. allocation for n-layer depending on callphys.def
      IF(.NOT.ALLOCATED(iaero_nlay)) ALLOCATE(iaero_nlay(nlayaero))
      iaero_nlay(:) = 0
      ! Do the same for iaero_generic and i_rgcs_ice
      IF (.not. allocated(iaero_generic)) 
     &  allocate(iaero_generic(aerogeneric))
      if (.not. allocated(i_rgcs_ice))
     & allocate(i_rgcs_ice(aerogeneric)) 
      ! Init of i_rgcs_ice
      i_rgcs_ice(:) =0.0
      ia = 1
      do iq=1,nqtot
         if (is_rgcs(iq) .eq. 1) then 
            i_rgcs_ice(ia)=iq
            ia = ia+1
         endif
      enddo
      ! We check that we have the right number
      ! for aerogeneric (coherent between
      ! callphys and traceur.def)
   !    if (aerogeneric .ne. n_rgcs) then 
   !       print*,'iniaerosol: aerogeneric is not' 
   !   & 'equal to the number of RGCS in traceur.def'
   !       print*,'iniaerosol: check your' 
   !   &'callphys.def and your traceur.def'
   !       call abort_physics("inaerosol: Aborting")
   !    endif
      iaero_generic(:)=0
      ia=0
      if (aeroco2) then
         ia=ia+1
         iaero_co2=ia
      endif
      write(*,*) '--- CO2 aerosol = ', iaero_co2
 
      if (aeroh2o) then
         ia=ia+1
         iaero_h2o=ia
      endif
      write(*,*) '--- H2O aerosol = ', iaero_h2o

      if (dusttau.gt.0) then
         ia=ia+1
         iaero_dust=ia
      endif
      write(*,*) '--- Dust aerosol = ', iaero_dust

      if (aeroh2so4) then
         ia=ia+1
         iaero_h2so4=ia
      endif
      write(*,*) '--- H2SO4 aerosol = ', iaero_h2so4
      
      if (aeroback2lay) then
         ia=ia+1
         iaero_back2lay=ia
      endif
      write(*,*) '--- Two-layer aerosol = ', iaero_back2lay

      if (aeronh3) then
         ia=ia+1
         iaero_nh3=ia
      endif
      write(*,*) '--- NH3 Cloud = ', iaero_nh3

      if (aeronlay) then
         do i=1,nlayaero
           ia=ia+1
           iaero_nlay(i)=ia
         enddo
      endif
      write(*,*) '--- N-layer aerosol = ', iaero_nlay

      if (aeroaurora) then
         ia=ia+1
         iaero_aurora=ia
      endif
      write(*,*) '--- Auroral aerosols = ', iaero_aurora

      if (aerogeneric .ne. 0) then 
         do i=1,aerogeneric
            ia = ia+1
            iaero_generic(i) = ia
         enddo
      endif 
      write(*,*)'--- Radiative Generic Condensable Species = '
     &,iaero_generic
      write(*,*) '=== Number of aerosols= ', ia

! For the zero aerosol case, we currently make a dummy co2 aerosol which is zero everywhere.
! (See aeropacity.F90 for how this works). A better solution would be to turn off the 
! aerosol machinery in the no aerosol case, but this would be complicated. LK

      if (ia.eq.0) then  !For the zero aerosol case. 
         ia = 1
         noaero = .true.
         iaero_co2=ia
      endif

      if (ia.ne.naerkind) then
          print*, 'Aerosols counted not equal to naerkind'
          print*, 'Compile with tag -s',ia,'to run'
          print*, 'or change options in callphys.def'
          print*, 'Abort in iniaerosol.F'
          call abort
      endif

      end
