!
! $Id $
!
SUBROUTINE recomp_tend_co2_slope(tendencies_co2_ice_phys,vmr_co2_gcm,ps_GCM_2,global_ave_press_GCM,global_ave_press_new,timelen,ngrid,nslope)

      IMPLICIT NONE

!=======================================================================
!
!  Routine that compute the evolution of the tendencie for co2 ice
!
!=======================================================================

!   arguments:
!   ----------

!   INPUT
  INTEGER, intent(in) :: timelen,ngrid,nslope                    ! # of timepoint if diagfi, # grid point, # subslope
  REAL, INTENT(in) ::  vmr_co2_gcm(ngrid,timelen)                ! physical point x timelen field : Volume mixing ratio of co2 in the first layer
  REAL, intent(in) :: ps_GCM_2(ngrid,timelen)                    ! physical point x timelen field : Surface pressure in the GCM
  REAL, intent(in) :: global_ave_press_GCM                       ! Average pressure in the GCM output
  REAL, intent(in) :: global_ave_press_new                       ! Actual average pressure


!   OUTPUT
  REAL, intent(inout) ::  tendencies_co2_ice_phys(ngrid,nslope)  ! physical point field : Evolution of perenial ice over one year


!   local:
!   ----

  INTEGER :: i,t,islope                                          ! Loop variables 
  REAL :: eps, sigma, L, beta, alpha, coef, ave                  ! Constant

  eps=0.95
  sigma=5.678E-8
  L=5.71*10**5
  beta=3182.48
  alpha=23.3494

  coef=669*24*3600*eps*sigma/L

! Evolution of the water ice for each physical point
  do i=1,ngrid
    do islope=1,nslope
       ave=0.
       if (tendencies_co2_ice_phys(i,islope).LT. 1E-5 .and. tendencies_co2_ice_phys(i,islope).GT.-1E-5) then
       else
         do t=1,timelen
           ave=ave+(beta/(alpha-log(vmr_co2_gcm(i,t)*ps_GCM_2(i,t)/100)))**4  &
              -(beta/(alpha-log(vmr_co2_gcm(i,t)*ps_GCM_2(i,t)*global_ave_press_GCM/global_ave_press_new/100)))**4
         enddo
         tendencies_co2_ice_phys(i,islope)=tendencies_co2_ice_phys(i,islope)+coef*ave/timelen
       endif
    enddo
  enddo


END SUBROUTINE recomp_tend_co2_slope
