subroutine evap_generic(ngrid,nlayer,nq,dtime,pt,pq,pdq,pdt,igcm_generic_vap, &
                        igcm_generic_ice,dqevap,dtevap,qevap,tevap)
    Use generic_cloud_common_h
    Use tracer_h
    implicit none 
!==================================================================
!     
!     Purpose
!     -------
!     Evaporation of all generic tracers in the atmopshere.
!     
!     Authors
!     -------
!     Adapted from evap.F by Lucas Teinturier (2022)
!     evap.F is adapted from the LMDTERRE code by B. Charnay (2010)
!     Original author Z. X. Li (1993)
!     
!==================================================================
    !Inputs 
    integer, intent(in) :: ngrid,nlayer,nq 
    real, intent(in) :: pt(ngrid,nlayer) !Temperature (K)
    real, intent(in) :: pq(ngrid,nlayer,nq) ! Tracers (kg/kg)
    real, intent(in) :: pdt(ngrid,nlayer) !Tendency on temperature (K/s)
    real, intent(in) :: pdq(ngrid,nlayer,nq) ! Tendency on tracer (kg/kg/s)
    real, intent(in) :: dtime ! physical timestep
    integer,intent(in) :: igcm_generic_vap ! index of the vapor generic tracer
    integer,intent(in) :: igcm_generic_ice !index of the ice generic tracer

    ! Ouputs 
    real,intent(out) :: qevap(ngrid,nlayer,nq)
    real,intent(out) :: tevap(ngrid,nlayer)
    real,intent(out) :: dqevap(ngrid,nlayer)
    real,intent(out) :: dtevap(ngrid,nlayer)

    ! Local variables 
    real zlvdcp
    integer l,ig ! Used for loops on the layers and grid and the tracers respectively

    !   Evaporate all the ice from the tracer
    zlvdcp = RLVTT_generic/cpp ! RLVTT_generic is the latent heat of vaporization (comes from generic_cloud_common_h attention)
 
    DO l=1,nlayer
        DO ig=1,ngrid 
            qevap(ig,l,igcm_generic_vap) = pq(ig,l,igcm_generic_vap) &
                    +pdq(ig,l,igcm_generic_vap)*dtime 
            qevap(ig,l,igcm_generic_ice) = pq(ig,l,igcm_generic_ice) &
                    +pdq(ig,l,igcm_generic_ice)*dtime
            tevap(ig,l) = pt(ig,l)+pdt(ig,l)*dtime 
            dqevap(ig,l) = max(0.,qevap(ig,l,igcm_generic_ice))/dtime
            dtevap(ig,l) = -dqevap(ig,l)*zlvdcp 
            qevap(ig,l,igcm_generic_vap) = qevap(ig,l,igcm_generic_vap) &
                    +dqevap(ig,l)*dtime 
            qevap(ig,l,igcm_generic_ice) = 0.
            tevap(ig,l) = tevap(ig,l) + dtevap(ig,l)*dtime 
        ENDDO ! ngrid 
    ENDDO ! nlayer 

end subroutine evap_generic

