module generic_tracer_index_mod

!======================================================================C
!
!     This module is to get back the index of a generic condensable tracer, for both the vap & ice parts of the tracer
!
!     
!
!======================================================================C

    implicit none

    contains

    subroutine generic_tracer_index(nq,iq,igcm_generic_vap,igcm_generic_ice,one_call_ice_vap_generic)

        USE tracer_h, only: noms, is_condensable
        integer nq,iq, igcm_generic_vap, igcm_generic_ice
        logical one_call_ice_vap_generic

        if((is_condensable(iq)==1) .and. (index(noms(iq),"vap") .ne. 0) &
                                                    .and. (index(noms(iq),"h2o") .eq. 0) .and. (index(noms(iq),"co2") .eq. 0)) then
            ! Let's get the index of our tracers (we look for igcm _generic_vap and igcm_generic_ice)

            igcm_generic_vap = iq
            igcm_generic_ice = -1

            ! We look for the corresponding ice traceur (before or after in the list of traceurs, maybe could be generalised to the whole list)
            if (iq .ne. nq) then
                if ((noms(iq)(1:len(trim(noms(iq)))-4) .eq. noms(iq+1)(1:len(trim(noms(iq+1)))-4)) .and. (index(noms(iq+1),"ice") .ne. 0)) then
                    igcm_generic_ice = iq+1
                end if
            end if
            if ((iq .gt. 1)) then
                if ((noms(iq)(1:len(trim(noms(iq)))-4) .eq. noms(iq-1)(1:len(trim(noms(iq-1)))-4)) .and. (index(noms(iq-1),"ice") .ne. 0)) then
                        igcm_generic_ice = iq-1
                end if
            end if
            if (igcm_generic_ice .eq. -1) then
                write(*,*) "ERROR : You set a vap traceur but you forgot to set the corresponding ice traceur, &
                or the pair vap/ice is not written one after another in traceur.def"
            endif

            one_call_ice_vap_generic = .true.

        end if ! if((is_condensable(iq)==1) .and. (index(noms(iq),"vap") .ne. 0))

    end subroutine generic_tracer_index

end module generic_tracer_index_mod