MODULE callkeys_mod
IMPLICIT NONE  

      logical,save :: callrad,corrk,calldifv,UseTurbDiff
!$OMP THREADPRIVATE(callrad,corrk,calldifv,UseTurbDiff)
      logical,save :: calladj,calltherm,co2cond,callsoil
!$OMP THREADPRIVATE(calladj,calltherm,co2cond,callsoil)
      logical,save :: season,diurnal,tlocked,rings_shadow,lwrite
!$OMP THREADPRIVATE(season,diurnal,tlocked,rings_shadow,lwrite)
      logical,save :: callstats,calleofdump
!$OMP THREADPRIVATE(callstats,calleofdump)
      logical,save :: callgasvis,continuum,graybody
!$OMP THREADPRIVATE(callgasvis,continuum,graybody)
      logical,save :: strictboundcorrk                                     
!$OMP THREADPRIVATE(strictboundcorrk)
      logical,save :: strictboundH2H2cia                                     
!$OMP THREADPRIVATE(strictboundH2H2cia)

      logical,save :: enertest
      logical,save :: nonideal
      logical,save :: meanOLR
      logical,save :: specOLR
      logical,save :: kastprof
      logical,save :: diagdtau
!$OMP THREADPRIVATE(enertest,nonideal,meanOLR,kastprof,diagdtau)
      logical,save :: newtonian
      logical,save :: check_cpp_match
      logical,save :: force_cpp
      logical,save :: testradtimes
      logical,save :: rayleigh
!$OMP THREADPRIVATE(newtonian,check_cpp_match,force_cpp,testradtimes,rayleigh)
      logical,save :: stelbbody
      logical,save :: nearco2cond
      logical,save :: tracer
      logical,save :: mass_redistrib
!$OMP THREADPRIVATE(stelbbody,nearco2cond,tracer,mass_redistrib)
      logical,save :: varactive
      logical,save :: varfixed
      logical,save :: radfixed
      logical,save :: sedimentation
!$OMP THREADPRIVATE(varactive,varfixed,radfixed,sedimentation)
      logical,save :: water,watercond,waterrain
!$OMP THREADPRIVATE(water,watercond,waterrain)
      logical,save :: aeroco2,aeroh2o,aeroh2so4,aeroback2lay
!$OMP THREADPRIVATE(aeroco2,aeroh2o,aeroh2so4,aeroback2lay)
      logical,save :: aeronh3, aeronlay, aeroaurora
!$OMP THREADPRIVATE(aeronh3,aeronlay,aeroaurora)
      logical,save :: aerofixco2,aerofixh2o
!$OMP THREADPRIVATE(aerofixco2,aerofixh2o)
      logical,save :: hydrology
      logical,save :: sourceevol
      logical,save :: CLFvarying
      logical,save :: nosurf
      logical,save :: oblate
!$OMP THREADPRIVATE(hydrology,sourceevol,CLFvarying,nosurf,oblate)
      logical,save :: ok_slab_ocean
      logical,save :: ok_slab_sic
      logical,save :: ok_slab_heat_transp
      logical,save :: albedo_spectral_mode
!$OMP THREADPRIVATE(ok_slab_ocean,ok_slab_sic,ok_slab_heat_transp,albedo_spectral_mode)
      logical,save :: photochem
      logical,save :: photoheat
      logical,save :: jonline
      logical,save :: depos
      logical,save :: haze
!$OMP THREADPRIVATE(photochem,photoheat,jonline,depos)
      logical,save :: calllott_nonoro
!$OMP THREADPRIVATE(calllott_nonoro)
      logical,save :: global1d
      real,save    :: szangle
!$OMP THREADPRIVATE(global1d,szangle)

      integer,save :: iddist
      integer,save :: iaervar
      integer,save :: iradia
      integer,save :: startype
      integer,save :: versH2H2cia
      integer,save :: nlayaero
!$OMP THREADPRIVATE(iddist,iaervar,iradia,startype,versH2H2cia,nlayaero)
      integer,dimension(:),allocatable,save :: aeronlay_choice
!$OMP THREADPRIVATE(aeronlay_choice)

      character(64),save :: optprop_back2lay_vis
      character(64),save :: optprop_back2lay_ir
      character(64),dimension(:),allocatable,save :: optprop_aeronlay_vis
      character(64),dimension(:),allocatable,save :: optprop_aeronlay_ir
!$OMP THREADPRIVATE(optprop_back2lay_vis,optprop_back2lay_ir,optprop_aeronlay_vis,optprop_aeronlay_ir)

      real,save :: tplanckmin
      real,save :: tplanckmax
      real,save :: dtplanck
!$OMP THREADPRIVATE(tplanckmin,tplanckmax,dtplanck)
      real,save :: topdustref
      real,save :: Nmix_co2
      real,save :: dusttau
      real,save :: Fat1AU
      real,save :: stelTbb
!$OMP THREADPRIVATE(topdustref,Nmix_co2,dusttau,Fat1AU,stelTbb)
      real,save :: Tstrat
      real,save :: tplanet
      real,save :: obs_tau_col_tropo
      real,save :: obs_tau_col_strato
!$OMP THREADPRIVATE(Tstrat,tplanet,obs_tau_col_tropo,obs_tau_col_strato)
      real,save :: pres_bottom_tropo
      real,save :: pres_top_tropo
      real,save :: pres_bottom_strato
      real,save :: pres_top_strato
!$OMP THREADPRIVATE(pres_bottom_tropo,pres_top_tropo,pres_bottom_strato,pres_top_strato)
      real,save :: size_tropo
      real,save :: size_strato
      real,save :: satval
      real,save :: CLFfixval
      real,save :: n2mixratio
!$OMP THREADPRIVATE(size_tropo,size_strato,satval,CLFfixval,n2mixratio)
      real,save :: size_nh3_cloud
      real,save :: pres_nh3_cloud
      real,save :: tau_nh3_cloud
!$OMP THREADPRIVATE(size_nh3_cloud, pres_nh3_cloud, tau_nh3_cloud)
      real,dimension(:),allocatable,save :: aeronlay_tauref
      real,dimension(:),allocatable,save :: aeronlay_lamref
      real,dimension(:),allocatable,save :: aeronlay_ptop
      real,dimension(:),allocatable,save :: aeronlay_pbot
      real,dimension(:),allocatable,save :: aeronlay_sclhght
      real,dimension(:),allocatable,save :: aeronlay_size
      real,dimension(:),allocatable,save :: aeronlay_nueff
!$OMP THREADPRIVATE(aeronlay_tauref,aeronlay_lamref,aeronlay_ptop,aeronlay_pbot,aeronlay_sclhght,aeronlay_size,aeronlay_nueff)
      real,save :: co2supsat
      real,save :: pceil
      real,save :: albedosnow
      real,save :: alb_ocean
      real,save :: albedoco2ice
      real,save :: maxicethick
!$OMP THREADPRIVATE(co2supsat,pceil,albedosnow,alb_ocean,albedoco2ice,maxicethick)
      real,save :: Tsaldiff
      real,save :: tau_relax
      real,save :: cloudlvl
      real,save :: icetstep
      real,save :: intheat
!$OMP THREADPRIVATE(Tsaldiff,tau_relax,cloudlvl,icetstep,intheat)
      real,save :: flatten
      real,save :: Rmean
      real,save :: J2
      real,save :: MassPlanet
!$OMP THREADPRIVATE(flatten,Rmean,J2,MassPlanet)
      real,save :: surfalbedo
      real,save :: surfemis
!$OMP THREADPRIVATE(surfalbedo,surfemis)
      real,save :: noseason_day
!$OMP THREADPRIVATE(noseason_day)
      real,save :: kmixmin
!$OMP THREADPRIVATE(kmixmin)
      
      logical,save :: iscallphys=.false.!existence of callphys.def
!$OMP THREADPRIVATE(iscallphys)

      ! do we read a startphy.nc file (default=.true.)
      logical,save :: startphy_file=.true. 
!$OMP THREADPRIVATE(startphy_file)

END MODULE callkeys_mod
