subroutine su_gases

  use gases_h

  implicit none

  integer igas, ierr, count

  !==================================================================
  !     
  !     Purpose
  !     -------
  !     Load atmospheric composition info
  !     
  !     Authors
  !     -------
  !     R. Wordsworth (2011)
  !     Allocatable arrays by A. Spiga (2011)
  !     
  !==================================================================

!$OMP MASTER

! radiative gases names, linked to the corrk table. Hardcoded here...

  write(*,*) "*** sugases.F90: assigning gases for corrk table. Hardcoded..."
  ngasmx = 5
  print*,ngasmx, " gases for corrk table. Allocating names and molar fractions..."
  if (.not.allocated(gnom)) allocate(gnom(ngasmx))
  gnom(1)="CO2"
   igas_CO2=1
  gnom(2)="H2O"
   igas_H2O=2
  gnom(3)="SO2"
   igas_SO2=3
  gnom(4)="CO"
   igas_CO=4
  gnom(5)="OCS"
   igas_OCS=5

  vgas=0
  if(.not.allocated(gfrac)) allocate(gfrac(ngasmx))
! ICI, yCO2 est ajuste pour compenser l'absence de N2 dans la liste des gas...
! (non radiativement actif...)
  gfrac(1)=0.965
  gfrac(2)=0.311000000E-04
  gfrac(3)=0.180000000E-03
  gfrac(4)=0.120000000E-04
  gfrac(5)=0.510000000E-04
! ces valeurs ne servent pas... Seules les valeurs utilisées dans le calcul des spectres jouent.
! Les valeurs reproduites ici correspondent aux valeurs à la surface (VenusNoCIA).

  do igas=1,ngasmx
     write(*,*) gnom(igas),gfrac(igas)
  enddo
print*,"end su_gases ***"

!$OMP END MASTER
!$OMP BARRIER

end subroutine su_gases
