   subroutine su_aer_radii(ngrid,nlayer,reffrad,nueffrad)
!==================================================================
!     Purpose
!     -------
!     Compute the effective radii of liquid and icy water particles
!
!     Authors
!     -------
!     Jeremy Leconte (2012)
!
!==================================================================
      use radinc_h, only: naerkind
      use aerosol_mod, only: iaero_venus1, iaero_venus2, iaero_venus2p, &
                             iaero_venus3, iaero_venusUV

      Implicit none

      integer,intent(in) :: ngrid
      integer,intent(in) :: nlayer

      real, intent(out) :: reffrad(ngrid,nlayer,naerkind)      !aerosols radii (K)
      real, intent(out) :: nueffrad(ngrid,nlayer,naerkind)     !variance     

      logical, save :: firstcall=.true.
!$OMP THREADPRIVATE(firstcall)
      integer :: iaer
      
!      print*,'enter su_aer_radii'
          do iaer=1,naerkind
!     these values will change once the microphysics gets to work
!     UNLESS tracer=.false., in which case we should be working with
!     a fixed aerosol layer, and be able to define reffrad in a 
!     .def file. To be improved!
!                |-> Done in th n-layer aerosol case (JVO 20)

            if(iaer.eq.iaero_venus1)then ! Venus cloud, mode 1, Haus13 model
               reffrad(1:ngrid,1:nlayer,iaer)  = 0.49e-6
               nueffrad(1:ngrid,1:nlayer,iaer) = 0.21
            endif

            if(iaer.eq.iaero_venus2)then ! Venus cloud, mode 2, Haus13 model
               reffrad(1:ngrid,1:nlayer,iaer)  = 1.23e-6
               nueffrad(1:ngrid,1:nlayer,iaer) = 0.067
            endif

            if(iaer.eq.iaero_venus2p)then ! Venus cloud, mode 2p, Haus13 model
               reffrad(1:ngrid,1:nlayer,iaer)  = 1.56e-6
               nueffrad(1:ngrid,1:nlayer,iaer) = 0.044
            endif

            if(iaer.eq.iaero_venus3)then ! Venus cloud, mode 3, Haus13 model
               reffrad(1:ngrid,1:nlayer,iaer)  = 4.25e-6
               nueffrad(1:ngrid,1:nlayer,iaer) = 0.062
            endif

            if(iaer.eq.iaero_venusUV)then ! Venus cloud, UV abs, 1 val as in table 
               reffrad(1:ngrid,1:nlayer,iaer)  = 0.5e-6
               nueffrad(1:ngrid,1:nlayer,iaer) = 0.1
            endif

         enddo

!      print*,'exit su_aer_radii'
  end subroutine su_aer_radii


