module radcommon_h
      use radinc_h, only: L_NSPECTV, NTstart, NTstop, &
                          naerkind, nsizemax
      implicit none

!----------------------------------------------------------------------C
!
!                             radcommon.h
!
!----------------------------------------------------------------------C
!
!  "Include" grid.h and radinc.h before this file in code that uses
!  some or all of this common data set
!
!     WNOV       - Array of wavenumbers at the spectral interval
!                  center for the VISUAL.  Array is NSPECTV
!                  elements long.
!     DWNV       - Array of "delta wavenumber", i.e., the width,
!                  in wavenumbers (cm^-1) of each VISUAL spectral
!                  interval.  NSPECTV elements long.
!     WAVEV      - Array (NSPECTV elements long) of the wavelenght
!                  (in microns) at the center of each VISUAL spectral
!                  interval.
!     STELLARF   - Array (NSPECTV elements) of stellar flux (W/M^2) in
!                  each spectral interval.  Values are for 1 AU,
!                  scaled to the planetary distance elsewhere.
!     TAURAY     - Array (NSPECTV elements) of the pressure-independent
!                  part of Rayleigh scattering optical depth.
!     TAURAYVAR  - Array (NSPECTV elements) of the pressure-independent
!                  part of Rayleigh scattering optical depth for the variable gas.
!     FZEROV     - Fraction of zeros in the VISUAL CO2 k-coefficients, for
!                  each temperature, pressure, and spectral interval
!
!     AEROSOL RADIATIVE OPTICAL CONSTANTS
! 
!   Shortwave
!   ~~~~~~~~~
! 
! For the "naerkind" kind of aerosol radiative properties : 
! QVISsQREF  :  Qext / Qext("longrefvis")
! omegavis   :  single scattering albedo
! gvis       :  assymetry factor
! 

      REAL*8 BWNV(L_NSPECTV+1), WNOV(L_NSPECTV), DWNV(L_NSPECTV), WAVEV(L_NSPECTV) !BWNV read by master in setspv
      REAL*8 STELLARF(L_NSPECTV), TAURAY(L_NSPECTV), TAURAYVAR(L_NSPECTV)
!$OMP THREADPRIVATE(WNOV,DWNV,WAVEV,&
	!$OMP STELLARF,TAURAY,TAURAYVAR)

      REAL*8 blamv(L_NSPECTV+1) ! these are needed by suaer.F90
!$OMP THREADPRIVATE(blamv)

      !! AS: introduced to avoid doing same computations again for continuum
      INTEGER, DIMENSION(:,:,:), ALLOCATABLE :: indv
!$OMP THREADPRIVATE(indi,indv)

      !!! ALLOCATABLE STUFF SO THAT DIMENSIONS ARE READ in *.dat FILES -- AS 12/2011  
      REAL*8, DIMENSION(:,:,:,:,:), ALLOCATABLE :: gasv
      REAL*8, DIMENSION(:), ALLOCATABLE :: PGASREF, TGASREF, PFGASREF, GWEIGHT
      real*8 FZEROV(L_NSPECTV)
      real*8 pgasmin, pgasmax
      real*8 tgasmin, tgasmax
!$OMP THREADPRIVATE(gasv,&  !pgasref,tgasref,pfgasref read by master in sugas_corrk
	!$OMP FZEROV)           !pgasmin,pgasmax,tgasmin,tgasmax read by master in sugas_corrk

      real QVISsQREF(L_NSPECTV,naerkind,nsizemax)
      real omegavis(L_NSPECTV,naerkind,nsizemax)
      real gvis(L_NSPECTV,naerkind,nsizemax)
!$OMP THREADPRIVATE(QVISsQREF,omegavis,gvis)


! Reference wavelengths used to compute reference optical depth (m)
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      REAL lamrefvis(naerkind)

! Actual number of grain size classes in each domain for a
!   given aerosol:

      INTEGER          :: nsize(naerkind,2)

! Particle size axis (depend on the kind of aerosol and the
!   radiation domain)

      DOUBLE PRECISION :: radiustab(naerkind,2,nsizemax)
!$OMP THREADPRIVATE(lamrefir,lamrefvis,radiustab) !nsize read by suaer_corrk

! Extinction coefficient at reference wavelengths;
!   These wavelengths are defined in aeroptproperties, and called longrefvis

      REAL :: QREFvis(naerkind,nsizemax)

      REAL,SAVE :: tstellar ! Stellar brightness temperature (SW)

      real*8,save :: PTOP

      real*8,parameter :: UBARI = 0.5D0

!$OMP THREADPRIVATE(QREFvis,& 	! gweight read by master in sugas_corrk
		!$OMP tstellar,PTOP)

!     If the gas optical depth (top to the surface) is less than
!     this value, we place that Gauss-point into the "zeros"
!     channel.
      real*8, parameter :: TLIMIT =  1.0D-30

!     Factor to convert pressures from millibars to Pascals
      real*8, parameter :: SCALEP = 1.00D+2

      real*8, parameter :: sigma = 5.67032D-8
      real*8, parameter :: grav = 6.672E-11

end module radcommon_h
