      SUBROUTINE iniaerosol()


      use radinc_h, only: naerkind
      use aerosol_mod

      IMPLICIT NONE
c=======================================================================
c   subject:
c   --------
c   Initialization related to aerosols 
c   (CO2 aerosols, dust, water, chemical species, ice...)   
c
c   author: Laura Kerber, S. Guerlet
c   ------
c        
c=======================================================================

      integer i, ia
      character(len=100) :: message
      character(len=10),parameter :: subname="iniaerosol"

      ia=0

!      if (aerovenus1) then
         ia=ia+1
         iaero_venus1=ia
!      endif
      write(*,*) '--- Venus cloud, mode 1 aerosol = ', iaero_venus1

!      if (aerovenus2) then
         ia=ia+1
         iaero_venus2=ia
!      endif
      write(*,*) '--- Venus cloud, mode 2 aerosol = ', iaero_venus2

!      if (aerovenus2p) then
         ia=ia+1
         iaero_venus2p=ia
!      endif
      write(*,*) '--- Venus cloud, mode 2p aerosol = ', iaero_venus2p

!      if (aerovenus3) then
         ia=ia+1
         iaero_venus3=ia
!      endif
      write(*,*) '--- Venus cloud, mode 3 aerosol = ', iaero_venus3

!      if (aerovenusUV) then
         ia=ia+1
         iaero_venusUV=ia
!      endif
      write(*,*) '--- Venus cloud, UV absorber = ', iaero_venusUV

      write(*,*) '=== Number of aerosols= ', ia
      
! For the zero aerosol case, we currently make a dummy co2 aerosol which is zero everywhere.
! (See aeropacity.F90 for how this works). A better solution would be to turn off the 
! aerosol machinery in the no aerosol case, but this would be complicated. LK

      if (ia.eq.0) then  !For the zero aerosol case. 
         ia = 1
         noaero = .true.
         iaero_co2=ia
      endif

      if (ia.ne.naerkind) then
          print*, 'Aerosols counted not equal to naerkind'
          print*, 'Compile with tag -s',ia,'to run'
          print*, 'or change options in callphys.def'
          message="Abort in iniaerosol.F"
          call abort_physic(subname,message,1)
      endif

      end
