module types_asis

implicit none

integer, parameter :: jpim = 4
integer, parameter :: jprb = 8

type z3spec
    real(kind=jprb)    :: z1
    integer(kind=jpim) :: z2
    real(kind=jprb)    :: z3
    integer(kind=jpim) :: z4
    real(kind=jprb)    :: z5
    integer(kind=jpim) :: z6
end type z3spec
type z4spec
    real(kind=jprb)    :: z1
    integer(kind=jpim) :: z2
    real(kind=jprb)    :: z3
    integer(kind=jpim) :: z4
    real(kind=jprb)    :: z5
    integer(kind=jpim) :: z6
    real(kind=jprb)    :: z7
    integer(kind=jpim) :: z8
end type z4spec

! indexes for the jacobian matrix

type(z3spec), allocatable, save :: indice_phot(:)
type(z3spec), allocatable, save :: indice_3(:)
type(z4spec), allocatable, save :: indice_4(:)

! dimension of indexes variables

integer, save :: nb_phot_max       ! dimension of phot reaction, including photolysis and quenching reaction
integer, save :: nb_reaction_3_max
integer, save :: nb_reaction_4_max
integer, save :: nb_phot_hv_max    ! dimension of photolysis, including three product photolysis

! photolysis reaction rate and label

real (kind = 8),      allocatable, save :: v_phot_3d(:,:,:)
character(len = 20),  allocatable, save :: jlabel(:,:)        ! photolysis label and species name
character(len = 300), allocatable, save :: jparamline(:)      ! line of jonline parameters

! pfunc type

type rtype1
    real(kind=jprb)    :: a
    real(kind=jprb)    :: b
    real(kind=jprb)    :: c
    real(kind=jprb)    :: t0
    real(kind=jprb)    :: d
end type rtype1

type rtype2
    real(kind=jprb)    :: k0
    real(kind=jprb)    :: n
    real(kind=jprb)    :: a
    real(kind=jprb)    :: kinf
    real(kind=jprb)    :: m
    real(kind=jprb)    :: b
    real(kind=jprb)    :: t0
    real(kind=jprb)    :: fc
    real(kind=jprb)    :: g
    real(kind=jprb)    :: h
    real(kind=jprb)    :: dup
    real(kind=jprb)    :: ddown
end type rtype2

type rtype3
    real(kind=jprb)    :: k0
    real(kind=jprb)    :: n
    real(kind=jprb)    :: a
    real(kind=jprb)    :: kinf
    real(kind=jprb)    :: m
    real(kind=jprb)    :: b
    real(kind=jprb)    :: t0
    real(kind=jprb)    :: atroe
    real(kind=jprb)    :: btroe
    real(kind=jprb)    :: ctroe
    real(kind=jprb)    :: dtroe
    real(kind=jprb)    :: dup
    real(kind=jprb)    :: ddown
end type rtype3

! reaction type

type reaction
    character(5)    :: vtype 
    integer         :: rtype
    integer         :: third_body
    logical         :: three_prod
    integer         :: ir1
    integer         :: r1
    integer         :: ir2
    integer         :: r2
    integer         :: ir3
    integer         :: r3
    integer         :: ip1
    integer         :: p1
    integer         :: ip2
    integer         :: p2
    integer         :: ip3
    integer         :: p3
end type reaction

! pfunc parameters for the reaction rates

type(rtype1), allocatable, save :: pfunc1_param(:)
type(rtype2), allocatable, save :: pfunc2_param(:)
type(rtype3), allocatable, save :: pfunc3_param(:)

! reactions attributs

type(reaction), allocatable, save :: reactions(:)

! dimension of pfunc type variables

integer, save :: nb_hv_max
integer, save :: nb_pfunc1_max
integer, save :: nb_pfunc2_max
integer, save :: nb_pfunc3_max

end module types_asis
