#!/usr/bin/bash
#
# Bash script to post-process files startphy_icosa.nc and start_icosa.nc
# generated by start_archive2icosa and create files
# start.nc and startphy.nc (usable as inputs for icosa_lmdz.exe)

# load nco module
module purge
source /scratch/cnt0027/lmd1167/adelavois/models/code/XIOS/arch.env
module load nco/4.7.9-gcc-4.8.5-hdf5-1.8.18-openmpi-2.0.4

#conversion to netcdf 3 in order to rename and add variables, not properly done with netcdf4 files
nccopy -k 'classic' startfi_prefinalize.nc startphy_icosa_nc3.nc

# rename lat and lon variables as latitude and longitude and put result in
# file startphy.nc
ncrename -v lon,longitude -v lat,latitude -d cell,physical_points\
         startphy_icosa_nc3.nc startphy_nc3.nc
# Temporarily added because program is not yet able to read topography
# SSO parameters are now taken from a dedicated startarchive.nc 
# see start2archive_SSO.f90
#ncks -A -v albedodat,ZMEA,ZSTD,ZSIG,ZGAM,ZTHE \
#         startphy_icosa_ref.nc startphy_nc3.nc
#Temporay soildepth array from Dynamico restartfi
ncks -A -v soildepth \
         ../../mars_dynamico_update_basic/startfi_0.nc startphy_nc3.nc

nccopy -k 'netCDF-4' startphy_nc3.nc startfi.nc

#Temporary Time variable from start2archive; should be added with xios
ncks -A -v Time \
         start_archive_nc4.nc startfi.nc

rearrange_startphy > rearrange_startphy.out 2>&1

# make a proper start.nc file based on start_icosa.nc
cp start_icosa_prefinalize.nc start_icosa.nc

# add u,u_lat,u_lon,bounds_lat_u and bound_lon_u from start_icosa_ref.nc
ncks -A -v u,lon_u,lat_u,bounds_lon_u,bounds_lat_u \
     start_icosa_ref.nc start_icosa.nc
ncrename -d cell,cell_mesh \
         start_icosa.nc
ncrename -d nvertex,nvertex_mesh \
         start_icosa.nc
ncks -A -v xcell,ycell,zcell \
     start_icosa_ref.nc start_icosa.nc

# cleanup
rm -rf startphy_icosa_nc3.nc startphy_nc3.nc
