module dust_scaling_mod

implicit none

contains

  subroutine compute_tauscaling(ngrid,nlayer,naerkind,naerdust, &
                                zday,pplev, &
                                tauref,tauscaling,aerosol)
    
    use dust_param_mod, only: tauscaling_mode, odpref
    use dimradmars_mod, only: iaerdust ! dust aerosol indexes 
    
    implicit none
    
    integer,intent(in) :: ngrid ! number of atmospheric columns
    integer,intent(in) :: nlayer ! number of atmospheric layers
    integer,intent(in) :: naerkind ! total number of aerosols
    integer,intent(in) :: naerdust ! number of dust aerosols
    real,intent(in) :: zday
    real,intent(in) :: pplev(ngrid,nlayer+1) ! inter-layer pressure (Pa)
    real,intent(in) :: tauref(ngrid) ! prescribed dust opacity
    real,intent(out) :: tauscaling(ngrid) ! dust scaling factor
    real,intent(inout) :: aerosol(ngrid,nlayer,naerkind) ! opacities
    
    integer :: ig, l , iaer
    real :: taudust(ngrid)
    
  ! 1. compute/set tauscaling

    if (tauscaling_mode == 0) then
      ! simple "freedust" case, no rescaling, ever
      tauscaling(:) = 1
    endif
    
    if (tauscaling_mode == 1) then
      ! GCM v5.3 style: tauscaling is computed so that
      ! aerosol() opacities correspond to the prescribed tauref()
      
      ! 1. compute dust column opacity using aerosol() dusts
      taudust(:) = 0
      do iaer=1,naerdust ! loop on all dust aerosols
        do l=1,nlayer
          do ig=1,ngrid
              taudust(ig)=taudust(ig)+aerosol(ig,l,iaerdust(iaer))
          enddo
        enddo
      enddo
      
      ! 2. compute the scaling factor
      tauscaling(:)=tauref(:)*pplev(:,1)/odpref/taudust(:)
    endif ! of if (tauscaling_mode == 1)
    
  ! 2. dust opacities rescaling
    do iaer=1,naerdust
      do l=1,nlayer
        do ig=1,ngrid
            aerosol(ig,l,iaerdust(iaer)) = max(1E-20, &
                      aerosol(ig,l,iaerdust(iaer))* tauscaling(ig))
        enddo
      enddo
    enddo

  end subroutine compute_tauscaling

end module dust_scaling_mod
