module dust_param_mod
! This module contains flags and saved variables for the dust cycle 
implicit none
  LOGICAL,SAVE :: active ! is dust radiatively active?
  LOGICAL,SAVE :: doubleq ! use 2-moment schmeme for dust? (dustbin must then be >=2)
  LOGICAL,SAVE :: submicron ! include a secondary dust distribution (submicron particules)
  LOGICAL,SAVE :: lifting ! flag to activate injection of dust from the surface
  LOGICAL,SAVE :: freedust ! if true: no rescaling (via tauscaling) of the dust mass and number
  LOGICAL,SAVE :: callddevil ! flag to activate dust devil (dust lifing/injection) parametrization
  
  INTEGER,SAVE :: dustbin ! number of bins of dust tracers

  REAL,PARAMETER :: odpref = 610. ! Reference pressure (Pa) of
                     ! DOD (Dust optical Depth) tauref
  
  REAL,SAVE,ALLOCATABLE :: tauscaling(:)   ! Convertion factor for qdust and Ndust
  INTEGER,SAVE :: tauscaling_mode ! =0, no rescaling (freedust)
                                  ! =1, prescribed scaling GCM5.3 style

contains

  subroutine ini_dust_param_mod(ngrid)
    implicit none
    integer,intent(in) :: ngrid ! number of atmospheric columns
  
    allocate(tauscaling(ngrid))
  
  end subroutine ini_dust_param_mod

  subroutine end_dust_param_mod
    implicit none
    
    if (allocated(tauscaling))  deallocate(tauscaling)

  end subroutine end_dust_param_mod
end module dust_param_mod
