def errormess(text):
    print text
    exit()
    return

def whatkindfile (nc):
    if 'controle' in nc.variables:   typefile = 'gcm'
    elif 'vert' in nc.variables:     typefile = 'mesoapi'
    elif 'U' in nc.variables:        typefile = 'meso'
    elif 'HGT_M' in nc.variables:    typefile = 'geo'
    else:                            errormess("whatkindfile: typefile not supported.")
    return typefile

def getfield (nc,var):
    ## this allows to get much faster (than simply referring to nc.variables[var])
    dimension = len(nc.variables[var].dimensions)
    if dimension == 2:    field = nc.variables[var][:,:]
    elif dimension == 3:  field = nc.variables[var][:,:,:]
    elif dimension == 4:  field = nc.variables[var][:,:,:,:]
    return field

def reducefield (input,d4=None,d3=None,d2=None,d1=None):
    ### do it the reverse way to be compliant with netcdf "t z y x" or "t y x" or "y x"
    ### it would be actually better to name d4 d3 d2 d1 as t z y x
    import numpy as np
    dimension = np.array(input).ndim
    shape = np.array(input).shape
    print 'dim,shape: ',dimension,shape
    output = input
    error = False
    if dimension == 2:
        if   d2 >= shape[0]: error = True
        elif d1 >= shape[1]: error = True
        elif d1 is not None and d2 is not None:  output = input[d2,d1]
        elif d1 is not None:         output = input[:,d1]
        elif d2 is not None:         output = input[d2,:]
    elif dimension == 3:
        if   d4 >= shape[0]: error = True
        elif d2 >= shape[1]: error = True
        elif d1 >= shape[2]: error = True
        elif d4 is not None and d2 is not None and d1 is not None:  output = input[d4,d2,d1]
        elif d4 is not None and d2 is not None:         output = input[d4,d2,:]
        elif d4 is not None and d1 is not None:         output = input[d4,:,d1]
        elif d2 is not None and d1 is not None:         output = input[:,d2,d1]
        elif d1 is not None:                output = input[:,:,d1]
        elif d2 is not None:                output = input[:,d2,:]
        elif d4 is not None:                output = input[d4,:,:]
    elif dimension == 4:
        if   d4 >= shape[0]: error = True
        elif d3 >= shape[1]: error = True
        elif d2 >= shape[2]: error = True
        elif d1 >= shape[3]: error = True
        elif d4 is not None and d3 is not None and d2 is not None and d1 is not None:  output = input[d4,d3,d2,d1]
        elif d4 is not None and d3 is not None and d2 is not None:         output = input[d4,d3,d2,:]
        elif d4 is not None and d3 is not None and d1 is not None:         output = input[d4,d3,:,d1]
        elif d4 is not None and d2 is not None and d1 is not None:         output = input[d4,:,d2,d1]
        elif d3 is not None and d2 is not None and d1 is not None:         output = input[:,d3,d2,d1]
        elif d4 is not None and d3 is not None:                output = input[d4,d3,:,:]
        elif d4 is not None and d2 is not None:                output = input[d4,:,d2,:]
        elif d4 is not None and d1 is not None:                output = input[d4,:,:,d1]
        elif d3 is not None and d2 is not None:                output = input[:,d3,d2,:]
        elif d3 is not None and d1 is not None:                output = input[:,d3,:,d1]
        elif d2 is not None and d1 is not None:                output = input[:,:,d2,d1]
        elif d1 is not None:                       output = input[:,:,:,d1]
        elif d2 is not None:                       output = input[:,:,d2,:]
        elif d3 is not None:                       output = input[:,d3,:,:]
        elif d4 is not None:                       output = input[d4,:,:,:]
    dimension = np.array(output).ndim
    shape = np.array(output).shape
    print 'dim,shape: ',dimension,shape
    return output, error

def latinterv (area):
	if   area == "Europe": 
		wlat = [20.,80.]
		wlon = [-50.,50.]
	elif area == "Central_America":
		wlat = [-10.,40.]
		wlon = [230.,300.]
	elif area == "Africa":
		wlat = [-20.,50.]
		wlon = [-50.,50.]
	elif area == "Whole":
		wlat = [-90.,90.]
		wlon = [-180.,180.]
	elif area == "Southern_Hemisphere":
		wlat = [-90.,60.]
		wlon = [-180.,180.]
        elif area == "Northern_Hemisphere":
                wlat = [-60.,90.]
                wlon = [-180.,180.]
        elif area == "Tharsis":
		wlat = [-30.,60.]
		wlon = [-170.,-10.]
	elif area == "Whole_No_High":
		wlat = [-60.,60.]
		wlon = [-180.,180.]
	elif area == "Chryse":
                wlat = [-60.,60.]
                wlon = [-60.,60.]
        elif area == "North_Pole":
                wlat = [60.,90.]
                wlon = [-180.,180.]
        elif area == "Close_North_Pole":
                wlat = [75.,90.]
                wlon = [-180.,180.]
	return wlon,wlat

def definesubplot ( numplot, fig ):
    from matplotlib.pyplot import rcParams
    rcParams['font.size'] = 12. ## default (important for multiple calls)
    if   numplot == 4:
        sub = 221
        fig.subplots_adjust(wspace = 0.3, hspace = 0.3)
        rcParams['font.size'] = int( rcParams['font.size'] * 2. / 3. )
    elif numplot == 2:
        sub = 121
        fig.subplots_adjust(wspace = 0.35)
        rcParams['font.size'] = int( rcParams['font.size'] * 3. / 4. )
    elif numplot == 3:
        sub = 131
        fig.subplots_adjust(wspace = 0.5)
        rcParams['font.size'] = int( rcParams['font.size'] * 1. / 2. )
    elif numplot == 6:
        sub = 231
        fig.subplots_adjust(wspace = 0.4, hspace = 0.0)
        rcParams['font.size'] = int( rcParams['font.size'] * 1. / 2. )
    elif numplot == 8:
        sub = 331 #241
        fig.subplots_adjust(wspace = 0.3, hspace = 0.3)
        rcParams['font.size'] = int( rcParams['font.size'] * 1. / 2. )
    elif numplot == 9:
        sub = 331
        fig.subplots_adjust(wspace = 0.3, hspace = 0.3)
        rcParams['font.size'] = int( rcParams['font.size'] * 1. / 2. )
    elif numplot == 1:
        sub = 99999
    elif numplot < 0: 
        sub = 99999
    else:
        print "supported: 1,2,3,4,6,8,9"
        exit()
    return sub

def getstralt(nc,nvert):
    typefile = whatkindfile(nc)
    if typefile is 'meso':                      
        stralt = "_lvl" + str(nvert)
    elif typefile is 'mesoapi':
        zelevel = int(nc.variables['vert'][nvert])
        if abs(zelevel) < 10000.:   strheight=str(zelevel)+"m"
        else:                       strheight=str(int(zelevel/1000.))+"km"
        if 'altitude'       in nc.dimensions:   stralt = "_"+strheight+"-AMR"
        elif 'altitude_abg' in nc.dimensions:   stralt = "_"+strheight+"-ALS"
        elif 'bottom_top'   in nc.dimensions:   stralt = "_"+strheight
        elif 'pressure'     in nc.dimensions:   stralt = "_"+str(zelevel)+"Pa"
        else:                                   stralt = ""
    else:
        stralt = ""
    return stralt

def getlschar ( namefile ):
    from netCDF4 import Dataset
    from timestuff import sol2ls
    from numpy import array
    nc  = Dataset(namefile)
    zetime = None
    if 'Times' in nc.variables: 
        zetime = nc.variables['Times'][0]
        shape = array(nc.variables['Times']).shape
        if shape[0] < 2: zetime = None
    if zetime is not None \
       and 'vert' not in nc.variables:
       #### strangely enough this does not work for api or ncrcat results!
        zetimestart = getattr(nc, 'START_DATE')
        zeday = int(zetime[8]+zetime[9]) - int(zetimestart[8]+zetimestart[9])
        if zeday < 0:    lschar=""  ## might have crossed a month... fix soon
        else:            lschar="_Ls"+str( int( sol2ls ( getattr( nc, 'JULDAY' ) + zeday ) ) )
        ###
        zetime2 = nc.variables['Times'][1]
        one  = int(zetime[11]+zetime[12]) + int(zetime[14]+zetime[15])/37.
        next = int(zetime2[11]+zetime2[12]) + int(zetime2[14]+zetime2[15])/37. 
        zehour    = one
        zehourin  = abs ( next - one )
    else:
        lschar=""
        zehour = 0
        zehourin = 1  
    return lschar, zehour, zehourin

def getprefix (nc):
    prefix = 'LMD_MMM_'
    prefix = prefix + 'd'+str(getattr(nc,'GRID_ID'))+'_'
    prefix = prefix + str(int(getattr(nc,'DX')/1000.))+'km_'
    return prefix

def getproj (nc):
    typefile = whatkindfile(nc)
    if typefile in ['mesoapi','meso','geo']:
        ### (il faudrait passer CEN_LON dans la projection ?)
        map_proj = getattr(nc, 'MAP_PROJ')
        cen_lat  = getattr(nc, 'CEN_LAT')
        if map_proj == 2:
            if cen_lat > 10.:    
                proj="npstere"
                print "NP stereographic polar domain" 
            else:            
                proj="spstere"
                print "SP stereographic polar domain"
        elif map_proj == 1: 
            print "lambert projection domain" 
            proj="lcc"
        elif map_proj == 3: 
            print "mercator projection"
            proj="merc"
        else:
            proj="merc"
    elif typefile in ['gcm']:  proj="cyl"  ## pb avec les autres (de trace derriere la sphere ?)
    else:                      proj="ortho"
    return proj    

def ptitle (name):
    from matplotlib.pyplot import title
    title(name)
    print name

def simplinterv (lon2d,lat2d):
    import numpy as np
    return [[np.min(lon2d),np.max(lon2d)],[np.min(lat2d),np.max(lat2d)]]

def wrfinterv (lon2d,lat2d):
    nx = len(lon2d[0,:])-1
    ny = len(lon2d[:,0])-1
    lon1 = lon2d[0,0] 
    lon2 = lon2d[nx,ny] 
    lat1 = lat2d[0,0] 
    lat2 = lat2d[nx,ny] 
    if abs(0.5*(lat1+lat2)) > 60.:  wider = 0.5 * (abs(lon1)+abs(lon2)) * 0.1
    else:                           wider = 0.
    if lon1 < lon2:  wlon = [lon1, lon2 + wider]  
    else:            wlon = [lon2, lon1 + wider]
    if lat1 < lat2:  wlat = [lat1, lat2]
    else:            wlat = [lat2, lat1]
    return [wlon,wlat]

def makeplotpngres (filename,res,pad_inches_value=0.25,folder='',disp=True):
    import  matplotlib.pyplot as plt
    res = int(res)
    name = filename+"_"+str(res)+".png"
    if folder != '':      name = folder+'/'+name
    plt.savefig(name,dpi=res,bbox_inches='tight',pad_inches=pad_inches_value)
    if disp:              display(name)		
    return

def makeplotpng (filename,pad_inches_value=0.25,minres=100.,folder='',disp=True):
    makeplotpngres(filename,minres,     pad_inches_value=pad_inches_value,folder=folder,disp=disp)
    makeplotpngres(filename,minres+200.,pad_inches_value=pad_inches_value,folder=folder,disp=False)
    return

def dumpbdy (field,stag=None):
    nx = len(field[0,:])-1
    ny = len(field[:,0])-1
    if stag == 'U': nx = nx-1
    if stag == 'V': ny = ny-1
    return field[5:ny-5,5:nx-5]

def getcoorddef ( nc ):   
    ## getcoord2d for predefined types
    typefile = whatkindfile(nc)
    if typefile in ['mesoapi','meso']:
        [lon2d,lat2d] = getcoord2d(nc)
        lon2d = dumpbdy(lon2d)
        lat2d = dumpbdy(lat2d)
    elif typefile in ['gcm']:
        [lon2d,lat2d] = getcoord2d(nc,nlat="latitude",nlon="longitude",is1d=True)
    elif typefile in ['geo']:
        [lon2d,lat2d] = getcoord2d(nc,nlat='XLAT_M',nlon='XLONG_M')
    return lon2d,lat2d    

def getcoord2d (nc,nlat='XLAT',nlon='XLONG',is1d=False):
    import numpy as np
    if is1d:
        lat = nc.variables[nlat][:]
        lon = nc.variables[nlon][:]
        [lon2d,lat2d] = np.meshgrid(lon,lat)
    else:
        lat = nc.variables[nlat][0,:,:]
        lon = nc.variables[nlon][0,:,:]
        [lon2d,lat2d] = [lon,lat]
    return lon2d,lat2d

def smooth (field, coeff):
	## actually blur_image could work with different coeff on x and y
	if coeff > 1:	result = blur_image(field,int(coeff))
	else:		result = field
	return result

def gauss_kern(size, sizey=None):
	import numpy as np
	## FROM COOKBOOK http://www.scipy.org/Cookbook/SignalSmooth	
    	# Returns a normalized 2D gauss kernel array for convolutions
    	size = int(size)
    	if not sizey:
	        sizey = size
	else:
	        sizey = int(sizey)
	x, y = np.mgrid[-size:size+1, -sizey:sizey+1]
	g = np.exp(-(x**2/float(size)+y**2/float(sizey)))
	return g / g.sum()

def blur_image(im, n, ny=None) :
	from scipy.signal import convolve
	## FROM COOKBOOK http://www.scipy.org/Cookbook/SignalSmooth
	# blurs the image by convolving with a gaussian kernel of typical size n. 
	# The optional keyword argument ny allows for a different size in the y direction.
    	g = gauss_kern(n, sizey=ny)
    	improc = convolve(im, g, mode='same')
    	return improc

def getwinddef (nc):    
    ## getwinds for predefined types
    typefile = whatkindfile(nc)
    ###
    if typefile is 'mesoapi':    [uchar,vchar] = ['Um','Vm']
    elif typefile is 'gcm':      [uchar,vchar] = ['u','v']
    elif typefile is 'meso':     [uchar,vchar] = ['U','V']
    else:                        [uchar,vchar] = ['not found','not found']
    ###
    if typefile in ['meso']:     metwind = False ## geometrical (wrt grid) 
    else:                        metwind = True  ## meteorological (zon/mer)
    if metwind is False:         print "Not using meteorological winds. You trust numerical grid as being (x,y)"
    ###
    return uchar,vchar,metwind

def vectorfield (u, v, x, y, stride=3, scale=15., factor=250., color='black', csmooth=1, key=True):
    ## scale regle la reference du vecteur
    ## factor regle toutes les longueurs (dont la reference). l'AUGMENTER pour raccourcir les vecteurs.
    import  matplotlib.pyplot               as plt
    import  numpy                           as np
    posx = np.min(x) - np.std(x) / 10.
    posy = np.min(y) - np.std(y) / 10.
    u = smooth(u,csmooth)
    v = smooth(v,csmooth)
    widthvec = 0.003 #0.005 #0.003
    q = plt.quiver( x[::stride,::stride],\
                    y[::stride,::stride],\
                    u[::stride,::stride],\
                    v[::stride,::stride],\
                    angles='xy',color=color,pivot='middle',\
                    scale=factor,width=widthvec )
    if color in ['white','yellow']:     kcolor='black'
    else:                               kcolor=color
    if key: p = plt.quiverkey(q,posx,posy,scale,\
                   str(int(scale)),coordinates='data',color=kcolor,labelpos='S',labelsep = 0.03)
    return 

def display (name):
    from os import system
    system("display "+name+" > /dev/null 2> /dev/null &")
    return name

def findstep (wlon):
    steplon = int((wlon[1]-wlon[0])/4.)  #3
    step = 120.
    while step > steplon and step > 15. :       step = step / 2.
    if step <= 15.:
        while step > steplon and step > 5.  :   step = step - 5.
    if step <= 5.:
        while step > steplon and step > 1.  :   step = step - 1.
    if step <= 1.:
        step = 1. 
    return step

def define_proj (char,wlon,wlat,back=None):
    from    mpl_toolkits.basemap            import Basemap
    import  numpy                           as np
    import  matplotlib                      as mpl
    meanlon = 0.5*(wlon[0]+wlon[1])
    meanlat = 0.5*(wlat[0]+wlat[1])
    if   wlat[0] >= 80.:   blat =  40. 
    elif wlat[0] <= -80.:  blat = -40. 
    else:                  blat = wlat[0]
    h = 50.  ## en km
    radius = 3397200.
    if   char == "cyl":     m = Basemap(rsphere=radius,projection='cyl',\
                              llcrnrlat=wlat[0],urcrnrlat=wlat[1],llcrnrlon=wlon[0],urcrnrlon=wlon[1])
    elif char == "moll":    m = Basemap(rsphere=radius,projection='moll',lon_0=meanlon)
    elif char == "ortho":   m = Basemap(rsphere=radius,projection='ortho',lon_0=meanlon,lat_0=meanlat)
    elif char == "lcc":     m = Basemap(rsphere=radius,projection='lcc',lat_1=meanlat,lat_0=meanlat,lon_0=meanlon,\
                              llcrnrlat=wlat[0],urcrnrlat=wlat[1],llcrnrlon=wlon[0],urcrnrlon=wlon[1])
    elif char == "npstere": m = Basemap(rsphere=radius,projection='npstere', boundinglat=blat, lon_0=0.)
    elif char == "spstere": m = Basemap(rsphere=radius,projection='spstere', boundinglat=blat, lon_0=0.)
    elif char == "nplaea":  m = Basemap(rsphere=radius,projection='nplaea', boundinglat=wlat[0], lon_0=meanlon)
    elif char == "laea":    m = Basemap(rsphere=radius,projection='laea',lon_0=meanlon,lat_0=meanlat,lat_ts=meanlat,\
                              llcrnrlat=wlat[0],urcrnrlat=wlat[1],llcrnrlon=wlon[0],urcrnrlon=wlon[1])
    elif char == "nsper":   m = Basemap(rsphere=radius,projection='nsper',lon_0=meanlon,lat_0=meanlat,satellite_height=h*1000.)
    elif char == "merc":    m = Basemap(rsphere=radius,projection='merc',lat_ts=0.,\
                              llcrnrlat=wlat[0],urcrnrlat=wlat[1],llcrnrlon=wlon[0],urcrnrlon=wlon[1])
    fontsizemer = int(mpl.rcParams['font.size']*3./4.)
    if char in ["cyl","lcc","merc","nsper","laea"]:   step = findstep(wlon)
    else:                                             step = 10.
    print step
    m.drawmeridians(np.r_[-180.:180.:step*2.], labels=[0,0,0,1], color='grey', fontsize=fontsizemer)
    m.drawparallels(np.r_[-90.:90.:step], labels=[1,0,0,0], color='grey', fontsize=fontsizemer)
    if back: m.warpimage(marsmap(back),scale=0.75)
            #if not back:
            #    if not var:                                        back = "mola"    ## if no var:         draw mola
            #    elif typefile in ['mesoapi','meso','geo'] \
            #       and proj not in ['merc','lcc','nsper','laea']:  back = "molabw"  ## if var but meso:   draw molabw
            #    else:                                              pass             ## else:              draw None
    return m

#### test temporaire
def putpoints (map,plot):
    #### from http://www.scipy.org/Cookbook/Matplotlib/Maps
    # lat/lon coordinates of five cities.
    lats = [18.4]
    lons = [-134.0]
    points=['Olympus Mons']
    # compute the native map projection coordinates for cities.
    x,y = map(lons,lats)
    # plot filled circles at the locations of the cities.
    map.plot(x,y,'bo')
    # plot the names of those five cities.
    wherept = 0 #1000 #50000
    for name,xpt,ypt in zip(points,x,y):
       plot.text(xpt+wherept,ypt+wherept,name)
    ## le nom ne s'affiche pas...
    return

def calculate_bounds(field,vmin=None,vmax=None):
    import numpy as np
    from mymath import max,min,mean
    ind = np.where(field < 9e+35)
    fieldcalc = field[ ind ] # la syntaxe compacte ne marche si field est un tuple
    ###
    dev = np.std(fieldcalc)*3.0
    ###
    if vmin is None:
        zevmin = mean(fieldcalc) - dev
    else:             zevmin = vmin
    ###
    if vmax is None:  zevmax = mean(fieldcalc) + dev
    else:             zevmax = vmax
    if vmin == vmax:
                      zevmin = mean(fieldcalc) - dev  ### for continuity
                      zevmax = mean(fieldcalc) + dev  ### for continuity            
    ###
    if zevmin < 0. and min(fieldcalc) > 0.: zevmin = 0.
    print "field ", min(fieldcalc), max(fieldcalc)
    print "bounds ", zevmin, zevmax
    return zevmin, zevmax

def bounds(what_I_plot,zevmin,zevmax):
    ### might be convenient to add the missing value in arguments
    what_I_plot[ what_I_plot < zevmin ] = zevmin*(1. + 1.e-7)
    what_I_plot[ what_I_plot > 9e+35  ] = -9e+35
    what_I_plot[ what_I_plot > zevmax ] = zevmax*(1. - 1.e-7)
    return what_I_plot

def zoomset (wlon,wlat,zoom):
    dlon = abs(wlon[1]-wlon[0])/2.
    dlat = abs(wlat[1]-wlat[0])/2.
    [wlon,wlat] = [ [wlon[0]+zoom*dlon/100.,wlon[1]-zoom*dlon/100.],\
                    [wlat[0]+zoom*dlat/100.,wlat[1]-zoom*dlat/100.] ]
    print "zoom %",zoom,wlon,wlat
    return wlon,wlat

def fmtvar (whichvar="def"):
    fmtvar    =     { \
             "tk":           "%.0f",\
             "tpot":         "%.0f",\
             "def":          "%.1e",\
             "PTOT":         "%.0f",\
             "HGT":          "%.1e",\
             "USTM":         "%.2f",\
             "HFX":          "%.0f",\
             "ICETOT":       "%.1e",\
             "TAU_ICE":      "%.2f",\
                    }
    if whichvar not in fmtvar:
        whichvar = "def"
    return fmtvar[whichvar]

####################################################################################################################
### Colorbars http://www.scipy.org/Cookbook/Matplotlib/Show_colormaps?action=AttachFile&do=get&target=colormaps3.png
def defcolorb (whichone="def"):
    whichcolorb =    { \
             "def":          "spectral",\
             "HGT":          "spectral",\
             "tk":           "gist_heat",\
             "QH2O":         "PuBu",\
             "USTM":         "YlOrRd",\
             "HFX":          "RdYlBu",\
             "ICETOT":       "YlGnBu",\
             "TAU_ICE":      "YlGnBu",\
                     }
    if whichone not in whichcolorb:
        whichone = "def"
    return whichcolorb[whichone]

def definecolorvec (whichone="def"):
        whichcolor =    { \
                "def":          "black",\
                "vis":          "yellow",\
                "vishires":     "yellow",\
                "molabw":       "yellow",\
                "mola":         "black",\
                "gist_heat":    "white",\
                "hot":          "tk",\
                "gist_rainbow": "black",\
                "spectral":     "black",\
                "gray":         "red",\
                "PuBu":         "black",\
                        }
        if whichone not in whichcolor:
                whichone = "def"
        return whichcolor[whichone]

def marsmap (whichone="vishires"):
        from os import uname
        mymachine = uname()[1]
        ### not sure about speed-up with this method... looks the same
        if "lmd.jussieu.fr" in mymachine: domain = "/u/aslmd/WWW/maps/"
        else:                             domain = "http://www.lmd.jussieu.fr/~aslmd/maps/"
	whichlink = 	{ \
		#"vis":		"http://maps.jpl.nasa.gov/pix/mar0kuu2.jpg",\
		#"vishires":	"http://www.lmd.jussieu.fr/~aslmd/maps/MarsMap_2500x1250.jpg",\
                #"geolocal":    "http://dl.dropbox.com/u/11078310/geolocal.jpg",\
		#"mola":	"http://www.lns.cornell.edu/~seb/celestia/mars-mola-2k.jpg",\
		#"molabw":	"http://dl.dropbox.com/u/11078310/MarsElevation_2500x1250.jpg",\
                "vis":         domain+"mar0kuu2.jpg",\
                "vishires":    domain+"MarsMap_2500x1250.jpg",\
                "geolocal":    domain+"geolocal.jpg",\
                "mola":        domain+"mars-mola-2k.jpg",\
                "molabw":      domain+"MarsElevation_2500x1250.jpg",\
			}
	if whichone not in whichlink: 
		print "marsmap: choice not defined... you'll get the default one... "
		whichone = "vishires"  
        return whichlink[whichone]

def earthmap (whichone):
	if   whichone == "contrast":	whichlink="http://users.info.unicaen.fr/~karczma/TEACH/InfoGeo/Images/Planets/EarthMapAtmos_2500x1250.jpg"
	elif whichone == "bw":		whichlink="http://users.info.unicaen.fr/~karczma/TEACH/InfoGeo/Images/Planets/EarthElevation_2500x1250.jpg"
	elif whichone == "nice":	whichlink="http://users.info.unicaen.fr/~karczma/TEACH/InfoGeo/Images/Planets/earthmap1k.jpg"
	return whichlink

