      subroutine test_vmr(zq, zdq, timestep, ngrid, nlay, message)
      
      implicit none
      integer, intent(in)  :: ngrid, nlay
      real, intent(in) :: zq(ngrid, nlay), zdq(ngrid, nlay), timestep
      character(len=*), intent(in) :: message
      integer :: i, j
      real :: test
      
      do i = 1, nlay
        do j = 1, ngrid
          test = zq(j,i) + zdq(j,i)*timestep
          if (test.gt.1.) then
             write(*,*)zq(j,i), zdq(j,i), timestep
             write(*,*)test, j, i
             write(*,*)'Warning: mmr > 1'
ci             call abort_physic('test_vmr', trim(message), 1)
          end if
        end do
      end do
      
      end subroutine test_vmr
