!
! $Id: phys_state_var_mod.F90 1670 2012-10-17 08:42:04Z idelkadi $
!
      MODULE phys_state_var_mod
! Variables sauvegardees pour le startphy.nc
!======================================================================
!
!
!======================================================================
! Declaration des variables
      USE dimphy, only : klon,klev
      USE comsoil_h, only : nsoilmx
      use comsaison_h, only: mu0, fract
      use radcommon_h, only: gzlat, gzlat_ig, Cmk 
      USE radinc_h, only : L_NSPECTI, L_NSPECTV,naerkind
      use turb_mod, only: q2,sensibFlux,wstar,ustar,tstar,hfmax_th,zmax_th

      real,allocatable,dimension(:,:),save :: ztprevious ! Previous loop Atmospheric Temperature (K) ! Useful for Dynamical Heating calculation.
      real,allocatable,dimension(:,:),save :: zuprevious ! Previous loop Zonal Wind (m.s-1)          ! Useful for Zonal Wind tendency calculation.

      real, dimension(:),allocatable,save ::  tsurf                ! Surface temperature (K).
      real, dimension(:,:),allocatable,save ::  tsoil              ! Sub-surface temperatures (K).
      real, dimension(:,:),allocatable,save :: albedo              ! Surface Spectral albedo. By MT2015.
      real, dimension(:),allocatable,save :: albedo_equivalent     ! Spectral Mean albedo.

      real,dimension(:),allocatable,save :: albedo_bareground ! Bare Ground Albedo. By MT 2015.

       real, dimension(:), allocatable, save       :: tankCH4    ! Depth of surface methane tank (m)

      real,dimension(:),allocatable,save :: emis        ! Thermal IR surface emissivity.
      real,dimension(:,:),allocatable,save :: dtrad     ! Net atmospheric radiative heating rate (K.s-1).
      real,dimension(:),allocatable,save :: fluxrad_sky ! Radiative flux from sky absorbed by surface (W.m-2).
      real,dimension(:),allocatable,save :: fluxrad     ! Net radiative surface flux (W.m-2).
      real,dimension(:),allocatable,save :: capcal      ! Surface heat capacity (J m-2 K-1).
      real,dimension(:),allocatable,save :: fluxgrd     ! Surface conduction flux (W.m-2).
      real,dimension(:,:),allocatable,save :: qsurf     ! Tracer on surface (e.g. kg.m-2).

      ! FOR DIAGNOSTIC :

      real,dimension(:),allocatable,save :: fluxsurf_lw     ! Incident Long Wave (IR) surface flux (W.m-2).
      real,dimension(:),allocatable,save :: fluxsurf_sw     ! Incident Short Wave (stellar) surface flux (W.m-2).
      real,dimension(:),allocatable,save :: fluxsurfabs_sw  ! Absorbed Short Wave (stellar) flux by the surface (W.m-2).

      real,dimension(:),allocatable,save :: fluxtop_lw      ! Outgoing LW (IR) flux to space (W.m-2).
      real,dimension(:),allocatable,save :: fluxabs_sw      ! Absorbed SW (stellar) flux (W.m-2).
      real,dimension(:),allocatable,save :: fluxtop_dn      ! Incoming SW (stellar) radiation at the top of the atmosphere (W.m-2).
      real,dimension(:),allocatable,save :: fluxdyn         ! Horizontal heat transport by dynamics (W.m-2).

      real,dimension(:,:),allocatable,save :: OLR_nu        ! Outgoing LW radiation in each band (Normalized to the band width (W/m2/cm-1)).
      real,dimension(:,:),allocatable,save :: OSR_nu        ! Outgoing SW radiation in each band (Normalized to the band width (W/m2/cm-1)).
      real,dimension(:,:),allocatable,save :: zdtlw         ! LW heating tendencies (K/s).
      real,dimension(:,:),allocatable,save :: zdtsw         ! SW heating tendencies (K/s).
      !real,dimension(:),allocatable,save :: sensibFlux      ! Turbulent flux given by the atmosphere to the surface (W.m-2).
      real,dimension(:,:,:),allocatable,save :: int_dtauv   ! VI optical thickness of layers within narrowbands for diags ().
      real,dimension(:,:,:),allocatable,save :: int_dtaui   ! IR optical thickness of layers within narrowbands for diags ().


      real,allocatable,dimension(:,:),save :: qsurf_hist
 
CONTAINS

!======================================================================
SUBROUTINE phys_state_var_init(nqtot)

IMPLICIT NONE

        integer,intent(in) :: nqtot

!  Parametres de l'Orographie a l'Echelle Sous-Maille (OESM):
!
!zmea(:)   ! orographie moyenne
!zstd(:)   ! deviation standard de l'OESM
!zsig(:)   ! pente de l'OESM
!zgam(:)   ! anisotropie de l'OESM
!zthe(:)   ! orientation de l'OESM
!zpic(:)   ! Maximum de l'OESM
!zval(:)   ! Minimum de l'OESM
!rugoro(:) ! longueur de rugosite de l'OESM 
        print*,'klon',klon,'klev',klev
        ALLOCATE(tsurf(klon))
        ALLOCATE(tsoil(klon,nsoilmx))
        ALLOCATE(albedo(klon,L_NSPECTV))
        ALLOCATE(albedo_equivalent(klon))
        ALLOCATE(albedo_bareground(klon))
        ALLOCATE(emis(klon))
        ALLOCATE(dtrad(klon,klev))
        ALLOCATE(fluxrad_sky(klon))
        ALLOCATE(fluxrad(klon))
        ALLOCATE(capcal(klon))
        ALLOCATE(fluxgrd(klon))
        ALLOCATE(qsurf(klon,nqtot))
        ALLOCATE(q2(klon,klev+1))
        ALLOCATE(tankCH4(klon))
        ALLOCATE(ztprevious(klon,klev))
        ALLOCATE(zuprevious(klon,klev))
        ALLOCATE(qsurf_hist(klon,nqtot))
        ALLOCATE(fluxsurf_lw(klon))
        ALLOCATE(fluxsurf_sw(klon))
        ALLOCATE(fluxsurfabs_sw(klon))
        ALLOCATE(fluxtop_lw(klon))
        ALLOCATE(fluxabs_sw(klon))
        ALLOCATE(fluxtop_dn(klon))
        ALLOCATE(fluxdyn(klon))
        ALLOCATE(OLR_nu(klon,L_NSPECTI))
        ALLOCATE(OSR_nu(klon,L_NSPECTV))
        ALLOCATE(sensibFlux(klon))
        ALLOCATE(zdtlw(klon,klev))
        ALLOCATE(zdtsw(klon,klev))
        ALLOCATE(int_dtaui(klon,klev,L_NSPECTI))
        ALLOCATE(int_dtauv(klon,klev,L_NSPECTV))
        ! This is defined in comsaison_h
        ALLOCATE(mu0(klon))
        ALLOCATE(fract(klon))
         ! This is defined in radcommon_h
        ALLOCATE(gzlat(klon,klev))
        ALLOCATE(gzlat_ig(klon))
        ALLOCATE(Cmk(klon))
        allocate(wstar(klon))
        allocate(ustar(klon))
        allocate(tstar(klon))
        allocate(hfmax_th(klon))
        allocate(zmax_th(klon))

END SUBROUTINE phys_state_var_init

!======================================================================
SUBROUTINE phys_state_var_end

IMPLICIT NONE

        DEALLOCATE(tsurf)
        DEALLOCATE(tsoil)
        DEALLOCATE(albedo)
        DEALLOCATE(albedo_equivalent)
        DEALLOCATE(albedo_bareground)
        DEALLOCATE(emis)
        DEALLOCATE(dtrad)
        DEALLOCATE(fluxrad_sky)
        DEALLOCATE(fluxrad)
        DEALLOCATE(capcal)
        DEALLOCATE(fluxgrd)
        DEALLOCATE(qsurf)
        DEALLOCATE(q2)
        DEALLOCATE(tankCH4)
        DEALLOCATE(ztprevious)
        DEALLOCATE(zuprevious)
        DEALLOCATE(qsurf_hist)
        DEALLOCATE(fluxsurf_lw)
        DEALLOCATE(fluxsurf_sw)
        DEALLOCATE(fluxsurfabs_sw)
        DEALLOCATE(fluxtop_lw)
        DEALLOCATE(fluxabs_sw)
        DEALLOCATE(fluxtop_dn)
        DEALLOCATE(fluxdyn)
        DEALLOCATE(OLR_nu)
        DEALLOCATE(OSR_nu)
        DEALLOCATE(sensibFlux)
        DEALLOCATE(zdtlw)
        DEALLOCATE(zdtsw)
        DEALLOCATE(int_dtaui)
        DEALLOCATE(int_dtauv)
        DEALLOCATE(mu0)
        DEALLOCATE(fract)
        DEALLOCATE(gzlat)
        DEALLOCATE(gzlat_ig)
        DEALLOCATE(Cmk)
        deallocate(wstar)
        deallocate(ustar)
        deallocate(tstar)
        deallocate(hfmax_th)
        deallocate(zmax_th)


END SUBROUTINE phys_state_var_end

      END MODULE phys_state_var_mod
