      subroutine phytrac_chimie (
     $                    debutphy,
     $                    gmtime,
     $                    nqmax,
     $                    n_lon,
     $                    lat,
     $                    lon,
     $                    n_lev, 
     $                    pdtphys,
     $                    temp,
     $                    pplay,
     $                    trac)

!    $                    iter) temporary

      use chemparam_mod
      use conc, only: mmean

      implicit none
      
#include "clesphys.h" 
#include "YOMCST.h"

!===================================================================
!     input
!===================================================================

      integer :: n_lon, n_lev               ! number of gridpoints and levels
      integer :: nqmax                      ! number of tracers

      real :: gmtime
      real :: pdtphys                       ! physics timestep (s)
      real, dimension(n_lon,n_lev) :: temp  ! temperature (k)
      real, dimension(n_lon,n_lev) :: pplay ! pressure (pa)

      logical :: debutphy                   ! first call flag

!===================================================================
!     output
!===================================================================

      integer, dimension(n_lon,n_lev) :: iter ! chemical iterations

!===================================================================
!     input/output
!===================================================================

      real, dimension(n_lon,n_lev,nqmax) :: trac ! tracer mass mixing ratio

!===================================================================
!     local
!===================================================================

      real :: sza_local   ! solar zenith angle (deg)
      real :: lon_sun

      integer :: i, iq
      integer :: ilon, ilev

      real  lat(n_lon), lat_local(n_lon)
      real  lon(n_lon), lon_local(n_lon)

      real, dimension(n_lon,n_lev) :: mrtwv, mrtsa ! total water and total sulfuric acid
      real, dimension(n_lon,n_lev) :: mrwv, mrsa   ! gas-phase water and gas-phase sulfuric acid
      real, dimension(n_lon,n_lev) :: trac_sum
     
!===================================================================
!     first call : initialisations
!===================================================================

      if (debutphy) then
      
!-------------------------------------------------------------------
!        case of tracers re-initialisation with chemistry
!-------------------------------------------------------------------
         if (reinit_trac .and. ok_chem) then

            print*, "Tracers are re-initialised"
            trac(:,:,:) = 1.0e-30

            if ((i_ocs /= 0) .and. (i_co /= 0) .and. (i_hcl /= 0) 
     $           .and. (i_so2 /= 0) .and. (i_h2o /= 0) .and. (i_n2/ = 0)
     $           .and. (i_co2 /= 0)) then

               trac(:,1:22,i_ocs) = 3.e-6
               trac(:,1:22,i_co)  = 25.e-6
               trac(:,:,i_hcl)    = 0.4e-6
               trac(:,1:22,i_so2) = 10.e-6
               trac(:,1:22,i_h2o) = 30.e-6
               trac(:,:,i_n2)     = 0.35e-1
   
!          ensure that sum of mixing ratios = 1

               trac_sum(:,:) = 0.

               do iq = 1,nqmax - nmicro
                  if (iq /= i_co2) then
                     trac_sum(:,:) = trac_sum(:,:) + trac(:,:,iq) 
                  end if
               end do

!          initialise co2

               trac(:,:,i_co2) = 1. - trac_sum(:,:)

            else
               write(*,*) "at least one tracer is missing : stop"
               stop
            end if
        
!           convert volume to mass mixing ratio

            do iq = 1,nqmax - nmicro
               trac(:,:,iq) = trac(:,:,iq)*m_tr(iq)/mmean(:,:)
            end do
    
         end if  ! reinit_trac

!-------------------------------------------------------------------
!        case of detailed microphysics without chemistry
!-------------------------------------------------------------------
         if (.not. ok_chem .and. ok_cloud .and. cl_scheme==2) then

!           convert mass to volume mixing ratio

            do iq = 1,nqmax - nmicro
               trac(:,:,iq) = trac(:,:,iq)*mmean(:,:)/m_tr(iq)
            end do
          
!           initialise microphysics
 
            call vapors4muphy_ini(n_lon,n_lev,trac)

!           convert volume to mass mixing ratio

            do iq = 1,nqmax - nmicro
               trac(:,:,iq) = trac(:,:,iq)*m_tr(iq)/mmean(:,:)
            end do
    
         end if

      end if  ! debutphy 

!===================================================================
!     convert mass to volume mixing ratio : gas phase
!===================================================================

      do iq = 1,nqmax - nmicro
        trac(:,:,iq) = max(trac(:,:,iq)*mmean(:,:)/m_tr(iq),1.e-30)
      end do

!===================================================================
!     microphysics: simplified scheme (phd aurelien stolzenbach)
!===================================================================

      if (ok_cloud .and. cl_scheme == 1) then

!     convert mass to volume mixing ratio : liquid phase

         trac(:,:,i_h2so4liq) = max(trac(:,:,i_h2so4liq)
     $                              *mmean(:,:)/m_tr(i_h2so4liq),1.e-30)
         trac(:,:,i_h2oliq) = max(trac(:,:,i_h2oliq)
     $                            *mmean(:,:)/m_tr(i_h2oliq),1.e-30)
              
!     total water and sulfuric acid (gas + liquid)

         mrtwv(:,:) = trac(:,:,i_h2o) + trac(:,:,i_h2oliq)
         mrtsa(:,:) = trac(:,:,i_h2so4) + trac(:,:,i_h2so4liq)

!     all water and sulfuric acid is put in the gas-phase

         mrwv(:,:) = mrtwv(:,:)
         mrsa(:,:) = mrtsa(:,:)

!     call microphysics

         call new_cloud_venus(n_lev, n_lon, temp, pplay, 
     $                        mrtwv, mrtsa, mrwv, mrsa)

!     update water vapour and sulfuric acid

         trac(:,:,i_h2o) = mrwv(:,:)
         trac(:,:,i_h2oliq) = mrtwv(:,:) - trac(:,:,i_h2o)
     
         trac(:,:,i_h2so4) = mrsa(:,:)
         trac(:,:,i_h2so4liq) = mrtsa(:,:) - trac(:,:,i_h2so4)

      end if  ! simplified scheme

!===================================================================
!     microphysics: detailed scheme (phd sabrina guilbon)
!===================================================================

      if (ok_cloud .and. cl_scheme == 2) then

c	Boucle sur grille (n_lon) et niveaux (n_lev)
        DO ilon=1, n_lon       
         DO ilev=1, n_lev

         if (temp(ilon,ilev).lt.500.) then
           CALL MAD_MUPHY(pdtphys,                               ! Timestep
     &  temp(ilon,ilev),pplay(ilon,ilev),                        ! Temperature and pressure
     &  trac(ilon,ilev,i_h2o),trac(ilon,ilev,i_h2so4),           ! Mixing ratio of SA and W
     &  trac(ilon,ilev,i_m0_aer),trac(ilon,ilev,i_m3_aer),       ! Moments of aerosols
     &  trac(ilon,ilev,i_m0_mode1drop),trac(ilon,ilev,i_m0_mode1ccn),  ! Moments of mode 1
     &  trac(ilon,ilev,i_m3_mode1sa),trac(ilon,ilev,i_m3_mode1w),      ! Moments of mode 1
     &  trac(ilon,ilev,i_m3_mode1ccn),                                 ! Moments of mode 1
     &  trac(ilon,ilev,i_m0_mode2drop),trac(ilon,ilev,i_m0_mode2ccn),  ! Moments of mode 2
     &  trac(ilon,ilev,i_m3_mode2sa),trac(ilon,ilev,i_m3_mode2w),      ! Moments of mode 2
     &  trac(ilon,ilev,i_m3_mode2ccn))                                 ! Moments of mode 2
          else
           trac(ilon,ilev,i_m0_aer)=0. 
           trac(ilon,ilev,i_m3_aer)=0.
           trac(ilon,ilev,i_m0_mode1drop)=0.
           trac(ilon,ilev,i_m0_mode1ccn)=0.
           trac(ilon,ilev,i_m3_mode1sa)=0.
           trac(ilon,ilev,i_m3_mode1w)=0.
           trac(ilon,ilev,i_m3_mode1ccn)=0.
           trac(ilon,ilev,i_m0_mode2drop)=0.
           trac(ilon,ilev,i_m0_mode2ccn)=0.
           trac(ilon,ilev,i_m3_mode2sa)=0.
           trac(ilon,ilev,i_m3_mode2w)=0.
           trac(ilon,ilev,i_m3_mode2ccn)=0.
          endif
         ENDDO
        ENDDO

      end if  ! detailed scheme
            
!===================================================================
!     photochemistry
!===================================================================

      if (ok_chem) then

         lon_sun = (0.5 - gmtime)*2.*rpi
         lon_local(:) = lon(:)*rpi/180.
         lat_local(:) = lat(:)*rpi/180.

         do ilon = 1,n_lon

!           solar zenith angle

            sza_local = acos(cos(lat_local(ilon))*cos(lon_local(ilon))
     $                 *cos(lon_sun) + cos(lat_local(ilon))
     $                 *sin(lon_local(ilon))*sin(lon_sun))*180./rpi 
      
            call photochemistry_venus(n_lev, n_lon, pdtphys,
     $                                pplay(ilon,:)/100.,
     $                                temp(ilon,:),
     $                                trac(ilon,:,:),
     $                                mmean(ilon,:),
     $                                sza_local, nqmax, iter(ilon,:))

         end do

      end if  ! ok_chem

!===================================================================
!     convert volume to mass mixing ratio
!===================================================================

!     gas phase

      do iq = 1,nqmax - nmicro
         trac(:,:,iq) = trac(:,:,iq)*m_tr(iq)/mmean(:,:)
      end do

!     liquid phase

      if (ok_cloud .and. cl_scheme == 1) then
         trac(:,:,i_h2so4liq) = trac(:,:,i_h2so4liq)*m_tr(i_h2so4liq)
     &                          /mmean(:,:)
         trac(:,:,i_h2oliq) = trac(:,:,i_h2oliq)*m_tr(i_h2oliq)
     &                        /mmean(:,:)
      end if
      
      end subroutine phytrac_chimie
