!
!
!
SUBROUTINE thermcell_env(ngrid,nlay,nq,pq,pt,pu,pv,pplay,pplev,               &
                         zqt,zql,zt,ztv,zhl,zu,zv,zpopsk,zqs)
      
      
!===============================================================================
!  Purpose: calcul des caracteristiques de l'environnement necessaires au calcul
!           des proprietes dans le thermique.
!  
!  Modif 2019/04 (AB alexandre.boissinot@lmd.jussieu.fr)
!  
!  Nota Bene
!     ql   means "non-gaseous water mass mixing ratio" (liquid and solid)
!     qv   means "vapor mass mixing ratio"
!     qt   means "total water mass mixing ratio"
!     TP   means "potential temperature"
!     TRPV means "virtual potential temperature with latent heat release"  
!     TPV  means "virtual potential temperature"
!     TR   means "temperature with latent heat release"
!===============================================================================
      
      USE print_control_mod, ONLY: prt_level
      USE thermcell_mod, ONLY: RKAPPA
      USE watercommon_h, ONLY: RLvCp, RETV, Psat_water
      USE tracer_h, ONLY: igcm_h2o_vap, igcm_h2o_ice
      USE callkeys_mod, ONLY: water
      
      IMPLICIT NONE
      
      
!===============================================================================
! Declaration
!===============================================================================
      
!     Inputs:
!     -------
      
      INTEGER ngrid, nlay, nq
      
      REAL pq(ngrid,nlay,nq)                    ! Large scale water
      REAL pt(ngrid,nlay)                       ! Large scale temperature
      REAL pu(ngrid,nlay)                       ! Large scale zonal wind
      REAL pv(ngrid,nlay)                       ! Large scale meridional wind
      REAL pplay(ngrid,nlay)                    ! Layers pressure
      REAL pplev(ngrid,nlay+1)                  ! Levels pressure
      REAL zpopsk(ngrid,nlay)                   ! Exner function
      
!     Outputs:
!     --------
      
      REAL zqt(ngrid,nlay)                      ! qt   environment
      REAL zql(ngrid,nlay)                      ! ql   environment
      REAL zt(ngrid,nlay)                       ! T    environment
      REAL ztv(ngrid,nlay)                      ! TRPV environment
      REAL zhl(ngrid,nlay)                      ! TP   environment
      REAL zu(ngrid,nlay)                       ! u    environment
      REAL zv(ngrid,nlay)                       ! v    environment
      REAL zqs(ngrid,nlay)                      ! qsat environment
      
!     Local:
!     ------
      
      INTEGER ig, l
      
      REAL psat                                 ! Dummy argument for Psat_water()
      
!===============================================================================
! Initialization
!===============================================================================
      
      zu(:,:) = pu(:,:)
      zv(:,:) = pv(:,:)
      
      zhl(:,:) = pt(:,:) / zpopsk(:,:)
      
      zqt(:,:) = pq(:,:,igcm_h2o_vap)
      zql(:,:) = 0.
      
!===============================================================================
! Condensation and latent heat release
!===============================================================================
      
      IF (water) THEN
         
         DO l=1,nlay
            DO ig=1,ngrid
               CALL Psat_water(pt(ig,l), pplev(ig,l), psat, zqs(ig,l))
            ENDDO
         ENDDO
         
         DO l=1,nlay
            DO ig=1,ngrid
               zql(ig,l) = max(0.,pq(ig,l,igcm_h2o_vap) - zqs(ig,l))
               zt(ig,l) = pt(ig,l) + RLvCp * zql(ig,l)
               ztv(ig,l) = zt(ig,l) / zpopsk(ig,l)                            &
               &         * (1. + RETV * (zqt(ig,l)-zql(ig,l)) - zql(ig,l))
            ENDDO
         ENDDO
         
      ELSE
         
         zt(:,:) = pt(:,:)
         ztv(:,:) = pt(:,:) / zpopsk(:,:)
         
      ENDIF
      
      
RETURN
END
