MODULE thermcell_mod
      
      IMPLICIT NONE
      
      
! Flags for computations
                                                                  !  default
      INTEGER,PARAMETER :: iflag_thermals_optflux     = 1         !  0        !
      INTEGER,PARAMETER :: iflag_thermals_closure     = 2         !  2        !
      INTEGER,PARAMETER :: iflag_thermals             = 18        !  18       !
      
! Flags for (terrestrial) diagnoses
      
      LOGICAL,PARAMETER :: sorties                    = .false.   !  false
      INTEGER,PARAMETER :: iflag_trig_bl              = 1         !  1
      INTEGER,PARAMETER :: iflag_clos_bl              = 1         !  1
      INTEGER,PARAMETER :: iflag_coupl                = 5         !  5
      
! Physical parameters
      
      REAL,PARAMETER :: fact_thermals_ed_dz           = 0.007     !  0.007    !
      REAL,PARAMETER :: r_aspect_thermals             = 1.0       !           Aspect ratio of the thermals (width / height)
      REAL,PARAMETER :: tau_thermals                  = 0.        !  0.       Relaxation time
      REAL,PARAMETER :: betalpha                      = 0.9       !  0.9      !
      REAL,PARAMETER :: afact                         = 2./3.     !  2./3.    !
      REAL,PARAMETER :: fact_epsilon                  = 0.000     !  0.002    !
      REAL,PARAMETER :: detr_q_power                  = 0.5       !  0.5      !
      REAL,PARAMETER :: detr_q_coef                   = 0.012     !  0.012    !
      REAL,PARAMETER :: mix0                          = 0.        !  0.       !
      REAL,PARAMETER :: detr_min                      = 1.d-5     !  1.e-5    Minimal detrainment value
      REAL,PARAMETER :: entr_min                      = 1.d-5     !  1.e-5    Maximal detrainment value
      REAL,PARAMETER :: alphamax                      = 0.7       !           Maximal permitted updraft fraction
      REAL,PARAMETER :: fomass_max                    = 0.5       !           Maximal permitted outgoing layer mass fraction
      REAL,PARAMETER :: pres_limit                    = 1.e5      !  1.e5     !
      
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! AB : linf is used to set the lowest possible first level because we allow it
!      to begin higher than the surface. It is set to 2 in order to remove the
!      first layer for gas giant.
!      If there is a surface, it has to be set to 1.
!      If someone want to call more than once the thermal plume model in some
!      grid points, this variable may become a saved array of INTEGER with size
!      ngrid. 
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      INTEGER,PARAMETER :: linf                       = 2         !     1
      
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! AB : d_temp is an artificial virtual potential temperature offset added in
!      layer linf which can be used to force convection to begin in it.
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      REAL,PARAMETER :: d_temp                        = 0.        !     0.
      
! Parameters for diagnoses
      
      REAL,PARAMETER :: alp_bl_k                      = 0.5       !     0.5
      
! Physical constants
      
      REAL,SAVE :: RTT
      REAL,SAVE :: RG
      REAL,SAVE :: RKAPPA
      REAL,SAVE :: RPI
      REAL,SAVE :: RD
      
!$OMP THREADPRIVATE(RTT, RG, RKAPPA, RPI, RD)
      
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! AB : Parameters needed only for a loop in thermcell_alp (diagnoses).
!      Maybe to be removed.
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      INTEGER,PARAMETER :: nbsrf                      = 1
      
      
      CONTAINS
      
      SUBROUTINE init_thermcell_mod(g, rcp, r, pi, T_h2o_ice_liq, RV)
         
         IMPLICIT NONE
         
         REAL g
         REAL rcp
         REAL r
         REAL pi
         REAL T_h2o_ice_liq
         REAL RV
         
         RTT = T_h2o_ice_liq
         RG = g
         RKAPPA = rcp
         RPI = pi
         RD = r
         
         RETURN
      END SUBROUTINE init_thermcell_mod
      
END MODULE thermcell_mod
