!
!
!
      SUBROUTINE thermcell_env(ngrid,nlay,po,pt,pu,pv,pplay,  &
      &           pplev,zo,zh,zl,ztv,zthl,zu,zv,zpspsk,pqsat,lev_out)

!==============================================================================
! thermcell_env: calcule les caracteristiques de l environnement
!                necessaires au calcul des proprietes dans le thermique
!==============================================================================

      USE print_control_mod, ONLY: prt_level
      USE thermcell_mod, ONLY: RKAPPA
      USE watercommon_h, ONLY: RLvCp, RETV, Psat_water
      USE planete_mod, ONLY: preff
      
      IMPLICIT NONE   
      
!==============================================================================
! Declaration
!==============================================================================
      
!      inputs:
!      -------
      
      INTEGER ngrid
      INTEGER nlay
      INTEGER lev_out                           ! niveau pour les print
      
      REAL po(ngrid,nlay)                       ! large scale water
      REAL pt(ngrid,nlay)                       ! large scale temperature
      REAL pu(ngrid,nlay)                       ! large scale zonal wind
      REAL pv(ngrid,nlay)                       ! large scale meridional wind
      REAL pplay(ngrid,nlay)                    ! layers pressure
      REAL pplev(ngrid,nlay+1)                  ! levels pressure
      
!      outputs:
!      --------
      
      REAL zo(ngrid,nlay)                       ! qt  environment
      REAL zl(ngrid,nlay)                       ! ql  environment
      REAL zh(ngrid,nlay)                       ! T   environment
      REAL ztv(ngrid,nlay)                      ! TV  environment
      REAL zthl(ngrid,nlay)                     ! TPV environment
      REAL zu(ngrid,nlay)                       ! u   environment
      REAL zv(ngrid,nlay)                       ! v   environment
      
      REAL zpspsk(ngrid,nlay)                   ! Exner function
      REAL pqsat(ngrid,nlay)                    ! saturation vapor pressure
      
!      local:
!      ------
      
      INTEGER ig, ll
      
      REAL dummy
      
!==============================================================================
! Initialization
!==============================================================================
      
!------------------------------------------------------------------------------
! Calcul des caracteristiques de l'environnement
!------------------------------------------------------------------------------
      DO ll=1,nlay
         DO ig=1,ngrid
            zo(ig,ll) = po(ig,ll)
            zl(ig,ll) = 0.
            zh(ig,ll) = pt(ig,ll)
         ENDDO
      ENDDO
      
!==============================================================================
! Computation of qsat and condensation
!==============================================================================

      DO ll=1,nlay
         DO ig=1,ngrid
            CALL Psat_water(pt(ig,ll), pplev(ig,ll), dummy, pqsat(ig,ll))
         ENDDO
      ENDDO
      
      DO ll=1,nlay
         DO ig=1,ngrid
            zl(ig,ll) = max(0.,po(ig,ll) - pqsat(ig,ll))                      ! zl   set to ql   env
            zh(ig,ll) = pt(ig,ll) + RLvCp * zl(ig,ll)                         ! zh   set to TR   env
            zo(ig,ll) = po(ig,ll) - zl(ig,ll)                                 ! zo   set to qv   env
         ENDDO
      ENDDO
      
      DO ll=1,nlay
         DO ig=1,ngrid
             zpspsk(ig,ll) = (pplay(ig,ll)/preff)**RKAPPA
             zu(ig,ll) = pu(ig,ll)
             zv(ig,ll) = pv(ig,ll)
             
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! AB : WARNING, zh is no longer the potentiel temperature.
!      It is now the temperature. How awful!
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ztv(ig,ll) = zh(ig,ll)/zpspsk(ig,ll)                              ! ztv  set to TRP  env
            ztv(ig,ll) = ztv(ig,ll)*(1.+RETV*(zo(ig,ll))-zl(ig,ll))           ! ztv  set to TRPV env
            zthl(ig,ll) = pt(ig,ll)/zpspsk(ig,ll)                             ! zthl set to TP   env
            
         ENDDO
      ENDDO
      
      
RETURN
END
