#!/usr/bin/env python

### A. Spiga -- LMD -- 30/06/2011 -- slight modif early 07/2011

def domain (namefile,proj="ortho",back="vishires",target=None,var='HGT'): 
    from netCDF4 import Dataset
    from myplot import getcoord2d,define_proj,makeplotpng,simplinterv,getprefix,dumpbdy
    from matplotlib.pyplot import contourf,rcParams
    from numpy.core.defchararray import find
    ###
    nc  = Dataset(namefile)
    ###
    [lon2d,lat2d] = getcoord2d(nc)
    lon2d = dumpbdy(lon2d)
    lat2d = dumpbdy(lat2d)
    [wlon,wlat] = simplinterv(lon2d,lat2d)
    ###
    m = define_proj(proj,wlon,wlat,back=back)
    x, y = m(lon2d, lat2d)
    ###
    what_I_plot = dumpbdy( nc.variables[var][0,:,:] )
    contourf(x, y, what_I_plot, 40)
    ###
    zeplot = getprefix(nc) + "domain"
    if not target:   zeplot = namefile[0:find(namefile,'wrfout')] + zeplot
    else:            zeplot = target + "/" + zeplot          
    ###
    makeplotpng(zeplot,pad_inches_value=0.35)
    #rcParams['savefig.facecolor'] = 'black'
    #makeplotpng(zeplot+"b",pad_inches_value=0.35)

if __name__ == "__main__":
    import sys
    ### to be replaced by argparse
    from optparse import OptionParser
    parser = OptionParser()
    parser.add_option('-f', action='store', dest='namefile',    type="string",  default=None,       help='name of WRF file [NEEDED]')
    parser.add_option('-p', action='store', dest='proj',        type="string",  default="ortho",    help='projection')
    parser.add_option('-b', action='store', dest='back',        type="string",  default="vishires", help='background')
    parser.add_option('-t', action='store', dest='target',      type="string",  default=None,       help='destination folder')
    parser.add_option('-v', action='store', dest='var',         type="string",  default='HGT',      help='variable contoured')
    (opt,args) = parser.parse_args()
    if opt.namefile is None:
        print "I want to eat one file at least ! Use domain.py -f name_of_my_file. Or type domain.py -h"
        exit()
    print "Options:", opt
    domain (opt.namefile,proj=opt.proj,back=opt.back,target=opt.target,var=opt.var)
