MODULE qsort_mod

  ! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  ! Quick-sort algorithm
  ! ~~~~~~~~~~~~~~~~~~~~~
  ! -> Sorts an array (real only for now) y by increasing values
  ! -> If wanted, applies the same sorting to a companion array x ( useful if you have binned xy data ) 
  ! 
  ! TODO : Extend interface to integers
  ! 
  ! Author : J. Vatant d'Ollone - 2018
  ! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  IMPLICIT NONE

  INTERFACE qsort
     MODULE PROCEDURE qsort_y_r
     MODULE PROCEDURE qsort_xy_r
  END INTERFACE qsort

CONTAINS

  RECURSIVE SUBROUTINE qsort_y_r(y,n)

    IMPLICIT NONE

    ! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    ! I/O
    integer,               intent(in)    :: n !! Size of arrays
    real,    dimension(n), intent(inout) :: y !! Values to sort by

    ! Local variables
    integer :: left, right
    real    :: random
    real    :: pivot
    real    :: tempy
    integer :: marker
    ! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    if (n > 1) then

       call random_number(random)
       pivot = y(int(random*real(n-1))+1) ! random pivot (not best performance, but avoids worst-case)
       left = 0
       right = n + 1

       do while (left < right)
          right = right - 1
          do while (y(right) > pivot)
             right = right - 1
          enddo
          left = left + 1
          do while (y(left) < pivot)
             left = left + 1
          enddo
          if (left < right) then
             tempy = y(left)
             y(left) = y(right)
             y(right) = tempy
          endif
       enddo

       if (left == right) then
          marker = left + 1
       else
          marker = left
       endif

       call qsort(y(:marker-1), marker-1)
       call qsort(y(marker:),   n-marker+1)

    endif

  END SUBROUTINE qsort_y_r


  RECURSIVE SUBROUTINE qsort_xy_r(y,x,n)

    IMPLICIT NONE

    ! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    ! I/O
    integer,               intent(in)    :: n !! Size of arrays
    real,    dimension(n), intent(inout) :: y !! Values to sort by
    real,    dimension(n), intent(inout) :: x !! Companion array that will be sorted same way as y

    ! Local variables
    integer :: left, right
    real    :: random
    real    :: pivot
    real    :: tempy
    real    :: tempx
    integer :: marker
    ! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 

    if (n > 1) then

       call random_number(random)
       pivot = y(int(random*real(n-1))+1) ! random pivot (not best performance, but avoids worst-case)
       left = 0
       right = n + 1

       do while (left < right)
          right = right - 1
          do while (y(right) > pivot)
             right = right - 1
          enddo
          left = left + 1
          do while (y(left) < pivot)
             left = left + 1
          enddo
          if (left < right) then
             tempy = y(left)
             tempx = x(left)
             y(left) = y(right)
             x(left) = x(right)
             y(right) = tempy
             x(right) = tempx
          endif
       enddo

       if (left == right) then
          marker = left + 1
       else
          marker = left
       endif

       call qsort(y(:marker-1), x(:marker-1), marker-1)
       call qsort(y(marker:),   x(marker:),   n-marker+1)

    endif

  END SUBROUTINE qsort_xy_r


END MODULE qsort_mod

