MODULE comchem_newstart_h

! Stores data and routines for chemistry management specific to newstart

! Author : Jan Vatant d'Ollone (2018)

IMPLICIT NONE  
  
  ! Variable and allocatables for regriding chemistry pressure in newstart
  ! ----------------------------------------------------------------------
    
  INTEGER :: nlaykimold ! Number of upper atm. layers for chemistry in the start_archive file
  REAL, ALLOCATABLE, DIMENSION(:) :: preskimold ! Pressure grid of upper chemistry in the start_archive file
    
  ! Allocatable arrays for newstart fields
  ! --------------------------------------
  
  ! Nouvelle grille physique, ancienne grille verticale
  REAL,ALLOCATABLE :: ykim_up_oldv(:,:,:)  

  ! Nouvelle grille scalaire, ancienne grille verticale  
  REAL,ALLOCATABLE :: ykim_upS(:,:,:,:)  

  ! Ancienne grille scalaire, ancienne grille verticale  
  REAL,ALLOCATABLE :: ykim_upoldS(:,:,:,:)
  
  
  CONTAINS
  
  
  SUBROUTINE read_startarch_kim(nid,start,count)
  
    ! Purpose : * Read by ther names, upper chemsitry fields present
    !             in start_archive.nc as physical variables
    !           * H_up field is read before, as the 1st one  
    !             we perform sanity check on it
    !           * We assume a given order of the 44 tracers (cf comchem_h)
  
    IMPLICIT NONE
    
    include "netcdf.inc"
    
    INTEGER, INTENT(IN)               :: nid ! "start_archive.nc" NetCDF file ID
    INTEGER, DIMENSION(4), INTENT(IN) :: start, count
    
    INTEGER :: varid, nvarid, ierr
    
    !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    
    ierr=NF_INQ_VARID(nid,"H2_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <H2_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(2,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(2,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <H2_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"CH_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <CH_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(3,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(3,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <CH_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"CH2s_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <CH2s_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(4,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(4,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <CH2s_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"CH2_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <CH2_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(5,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(5,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <CH2_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"CH3_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <CH3_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(6,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(6,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <CH3_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"CH4_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <CH4_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(7,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(7,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <CH4_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C2_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C2_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(8,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(8,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C2_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C2H_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C2H_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(9,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(9,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C2H_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C2H2_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C2H2_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(10,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(10,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C2H2_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C2H3_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C2H3_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(11,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(11,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C2H3_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C2H4_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C2H4_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(12,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(12,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C2H4_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C2H5_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C2H5_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(13,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(13,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C2H5_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C2H6_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C2H6_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(14,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(14,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C2H6_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C3H3_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C3H3_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(15,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(15,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C3H3_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C3H5_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C3H5_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(16,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(16,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C3H5_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C3H6_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C3H6_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(17,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(17,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C3H6_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C3H7_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C3H7_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(18,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(18,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C3H7_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C4H_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C4H_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(19,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(19,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C4H_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C4H3_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C4H3_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(20,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(20,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C4H3_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C4H4_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C4H4_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(21,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(21,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C4H4_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C4H2s_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C4H2s_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(22,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(22,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C4H2s_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"CH2CCH2_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <CH2CCH2_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(23,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(23,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <CH2CCH2_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"CH3CCH_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <CH3CCH_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(24,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(24,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <CH3CCH_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C3H8_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C3H8_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(25,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(25,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C3H8_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C4H2_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C4H2_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(26,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(26,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C4H2_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C4H6_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C4H6_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(27,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(27,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C4H6_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C4H10_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C4H10_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(28,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(28,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C4H10_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"AC6H6_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <AC6H6_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(29,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(29,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <AC6H6_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C3H2_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C3H2_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(30,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(30,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C3H2_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C4H5_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C4H5_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(31,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(31,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C4H5_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"AC6H5_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <AC6H5_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(32,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(32,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <AC6H5_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"N2_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <N2_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(33,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(33,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <N2_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"N4S_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <N4S_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(34,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(34,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <N4S_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"CN_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <CN_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(35,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(35,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <CN_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"HCN_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <HCN_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(36,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(36,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <HCN_up>"
       CALL abort
    ENDIF
    
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"H2CN_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <H2CN_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(37,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(37,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <H2CN_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"CHCN_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <CHCN_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(38,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(38,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <CHCN_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"CH2CN_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <CH2CN_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(39,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(39,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <CH2CN_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"CH3CN_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <CH3CN_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(40,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(40,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <CH3CN_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C3N_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C3N_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(41,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(41,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C3N_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"HC3N_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <HC3N_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(42,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(42,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <HC3N_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"NCCN_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <NCCN_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(43,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(43,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <NCCN_up>"
       CALL abort
    ENDIF
      
    ! --------------------------------
    
    ierr=NF_INQ_VARID(nid,"C4N2_up",nvarid)
    IF (ierr .NE. NF_NOERR) THEN
      PRINT*, "lect_start_archive: Le champ <C4N2_up> est absent..."
      CALL abort
    ENDIF
#ifdef NC_DOUBLE
    ierr = NF_GET_VARA_DOUBLE(nid,nvarid,start,count,ykim_upoldS(44,:,:,:))
#else
    ierr = NF_GET_VARA_REAL(nid,nvarid,start,count,ykim_upoldS(44,:,:,:))
#endif
    IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "lect_start_archive: Lecture echouee pour <C4N2_up>"
       CALL abort
    ENDIF
      
    WRITE(*,*)

  END SUBROUTINE read_startarch_kim
  
END MODULE comchem_newstart_h
