MODULE comchem_h

! -----------------------------------------------------------------------
! Purpose : Stores data relative to upper chemistry in the GCM
! -------   For newstart there is a specific comchem_newstart_h module.
!
! Author : Jan Vatant d'Ollone (2017)
! ------
!
! NB : A given order is assumed for the 44 chemistry tracers :
! --   H, H2, CH, CH2s, CH2, CH3, CH4, C2, C2H, C2H2, C2H3, C2H4, C2H5, 
!      C2H6, C3H3, C3H5, C3H6, C3H7, C4H, C4H3, C4H4, C4H2s, CH2CCH2,
!      CH3CCH, C3H8, C4H2, C4H6, C4H10, AC6H6, C3H2, C4H5, AC6H5, N2,
!      N4S, CN, HCN, H2CN, CHCN, CH2CN, CH3CN, C3N, HC3N, NCCN, C4N2
        
! --------------------------------------------------------------------------

IMPLICIT NONE  
  
   INTEGER :: nlaykim_up   ! Number of upper atm. layers for chemistry from GCM top to 4.5E-5 Pa (1300km)
   INTEGER :: nlaykim_tot  ! Number of total layers for chemistry from surface to 4.5E-5 Pa (1300km)
!$OMP_THREADPRIVATE(nlaykim_up,nlay_kim_tot)

  ! NB : For the startfile we use nlaykim_up grid (upper atm) and for outputs we use nlaykim_tot grid (all layers)

   REAL,SAVE,ALLOCATABLE,DIMENSION(:) :: preskim  ! Pressure (Pa) of upper chemistry (mid)-layers
!$OMP_THREADPRIVATE(preskim)

   REAL,SAVE,ALLOCATABLE,DIMENSION(:,:) :: zlay_kim  ! Altitude (km) of all chemistry (mid)-layers
!$OMP_THREADPRIVATE(zlay_kim)

   REAL,SAVE,ALLOCATABLE,DIMENSION(:,:,:) :: ykim_up ! Upper chemistry fields (kg/kg)
!$OMP_THREADPRIVATE(ykim_up)

END MODULE comchem_h
