MODULE comchem_h

! Stores data relative to upper chemistry in the GCM
! For newstart there is a specific comchem_newstart_h module.

! Author : Jan Vatant d'Ollone (2017)

IMPLICIT NONE  
  
   INTEGER :: nlaykim_up   ! Number of upper atm. layers for chemistry from GCM top to 4.5E-5 Pa (1300km)
   INTEGER :: nlaykim_tot  ! Number of total layers for chemistry from surface to 4.5E-5 Pa (1300km)
!$OMP_THREADPRIVATE(nlaykim_up,nlay_kim_tot)

  ! NB : For the startfile we use nlaykim_up grid (upper atm) and for outputs we use nlaykim_tot grid (all layers)

   REAL,SAVE,ALLOCATABLE,DIMENSION(:) :: preskim  ! Pressure (Pa) of upper chemistry (mid)-layers
!$OMP_THREADPRIVATE(preskim)

   REAL,SAVE,ALLOCATABLE,DIMENSION(:,:) :: zlay_kim  ! Altitude (km) of all chemistry (mid)-layers
!$OMP_THREADPRIVATE(zlay_kim)

   REAL,SAVE,ALLOCATABLE,DIMENSION(:,:,:) :: ykim_up ! Upper chemistry fields (kg/kg)
!$OMP_THREADPRIVATE(ykim_up)

END MODULE comchem_h
