MODULE comchem_startarch_h

! Stores data and routines for chemistry management specific to start2archive

! Author : Jan Vatant d'Ollone (2018)

IMPLICIT NONE  

  ! Allocatable arrays for start2archive
  ! ------------------------------------
  
  ! 1. Grille physique
  REAL,ALLOCATABLE :: H(:,:)  
  REAL,ALLOCATABLE :: H2(:,:)  
  REAL,ALLOCATABLE :: CH(:,:)  
  REAL,ALLOCATABLE :: CH2s(:,:)  
  REAL,ALLOCATABLE :: CH2(:,:)  
  REAL,ALLOCATABLE :: CH3(:,:)  
  REAL,ALLOCATABLE :: CH4(:,:)  
  REAL,ALLOCATABLE :: C2(:,:)  
  REAL,ALLOCATABLE :: C2H(:,:)  
  REAL,ALLOCATABLE :: C2H2(:,:)  
  REAL,ALLOCATABLE :: C2H3(:,:)  
  REAL,ALLOCATABLE :: C2H4(:,:)  
  REAL,ALLOCATABLE :: C2H5(:,:)  
  REAL,ALLOCATABLE :: C2H6(:,:)  
  REAL,ALLOCATABLE :: C3H3(:,:)  
  REAL,ALLOCATABLE :: C3H5(:,:)  
  REAL,ALLOCATABLE :: C3H6(:,:)  
  REAL,ALLOCATABLE :: C3H7(:,:)  
  REAL,ALLOCATABLE :: C4H(:,:)  
  REAL,ALLOCATABLE :: C4H3(:,:)  
  REAL,ALLOCATABLE :: C4H4(:,:)  
  REAL,ALLOCATABLE :: C4H2s(:,:)  
  REAL,ALLOCATABLE :: CH2CCH2(:,:)  
  REAL,ALLOCATABLE :: CH3CCH(:,:)  
  REAL,ALLOCATABLE :: C3H8(:,:)  
  REAL,ALLOCATABLE :: C4H2(:,:)  
  REAL,ALLOCATABLE :: C4H6(:,:)  
  REAL,ALLOCATABLE :: C4H10(:,:)  
  REAL,ALLOCATABLE :: AC6H6(:,:)  
  REAL,ALLOCATABLE :: C3H2(:,:)  
  REAL,ALLOCATABLE :: C4H5(:,:)  
  REAL,ALLOCATABLE :: AC6H5(:,:)  
  REAL,ALLOCATABLE :: N2(:,:)  
  REAL,ALLOCATABLE :: N4S(:,:)  
  REAL,ALLOCATABLE :: CN(:,:)  
  REAL,ALLOCATABLE :: HCN(:,:)  
  REAL,ALLOCATABLE :: H2CN(:,:)  
  REAL,ALLOCATABLE :: CHCN(:,:)  
  REAL,ALLOCATABLE :: CH2CN(:,:)  
  REAL,ALLOCATABLE :: CH3CN(:,:)  
  REAL,ALLOCATABLE :: C3N(:,:)  
  REAL,ALLOCATABLE :: HC3N(:,:)  
  REAL,ALLOCATABLE :: NCCN(:,:)  
  REAL,ALLOCATABLE :: C4N2(:,:)  
  
  ! 2. Grille scalaire  
  REAL,ALLOCATABLE :: H_S(:,:)  
  REAL,ALLOCATABLE :: H2_S(:,:)  
  REAL,ALLOCATABLE :: CH_S(:,:)  
  REAL,ALLOCATABLE :: CH2s_S(:,:)  
  REAL,ALLOCATABLE :: CH2_S(:,:)  
  REAL,ALLOCATABLE :: CH3_S(:,:)  
  REAL,ALLOCATABLE :: CH4_S(:,:)  
  REAL,ALLOCATABLE :: C2_S(:,:)  
  REAL,ALLOCATABLE :: C2H_S(:,:)  
  REAL,ALLOCATABLE :: C2H2_S(:,:)  
  REAL,ALLOCATABLE :: C2H3_S(:,:)  
  REAL,ALLOCATABLE :: C2H4_S(:,:)  
  REAL,ALLOCATABLE :: C2H5_S(:,:)  
  REAL,ALLOCATABLE :: C2H6_S(:,:)  
  REAL,ALLOCATABLE :: C3H3_S(:,:)  
  REAL,ALLOCATABLE :: C3H5_S(:,:)  
  REAL,ALLOCATABLE :: C3H6_S(:,:)  
  REAL,ALLOCATABLE :: C3H7_S(:,:)  
  REAL,ALLOCATABLE :: C4H_S(:,:)  
  REAL,ALLOCATABLE :: C4H3_S(:,:)  
  REAL,ALLOCATABLE :: C4H4_S(:,:)  
  REAL,ALLOCATABLE :: C4H2s_S(:,:)  
  REAL,ALLOCATABLE :: CH2CCH2_S(:,:)  
  REAL,ALLOCATABLE :: CH3CCH_S(:,:)  
  REAL,ALLOCATABLE :: C3H8_S(:,:)  
  REAL,ALLOCATABLE :: C4H2_S(:,:)  
  REAL,ALLOCATABLE :: C4H6_S(:,:)  
  REAL,ALLOCATABLE :: C4H10_S(:,:)  
  REAL,ALLOCATABLE :: AC6H6_S(:,:)  
  REAL,ALLOCATABLE :: C3H2_S(:,:)  
  REAL,ALLOCATABLE :: C4H5_S(:,:)  
  REAL,ALLOCATABLE :: AC6H5_S(:,:)  
  REAL,ALLOCATABLE :: N2_S(:,:)  
  REAL,ALLOCATABLE :: N4S_S(:,:)  
  REAL,ALLOCATABLE :: CN_S(:,:)  
  REAL,ALLOCATABLE :: HCN_S(:,:)  
  REAL,ALLOCATABLE :: H2CN_S(:,:)  
  REAL,ALLOCATABLE :: CHCN_S(:,:)  
  REAL,ALLOCATABLE :: CH2CN_S(:,:)  
  REAL,ALLOCATABLE :: CH3CN_S(:,:)  
  REAL,ALLOCATABLE :: C3N_S(:,:)  
  REAL,ALLOCATABLE :: HC3N_S(:,:)  
  REAL,ALLOCATABLE :: NCCN_S(:,:)  
  REAL,ALLOCATABLE :: C4N2_S(:,:) 
  
  
  CONTAINS


  SUBROUTINE alloc_kim_start2archive(ngridmx,ip1jmp1)
  
    USE comchem_h, ONLY: nlaykim_up
  
    IMPLICIT NONE

    INTEGER,INTENT(IN) :: ngridmx
    INTEGER,INTENT(IN) :: ip1jmp1
    
    allocate(H(ngridmx,nlaykim_up))
    allocate(H_S(ip1jmp1,nlaykim_up))
    allocate(H2(ngridmx,nlaykim_up))
    allocate(H2_S(ip1jmp1,nlaykim_up))
    allocate(CH(ngridmx,nlaykim_up))
    allocate(CH_S(ip1jmp1,nlaykim_up))
    allocate(CH2s(ngridmx,nlaykim_up))
    allocate(CH2s_S(ip1jmp1,nlaykim_up))
    allocate(CH2(ngridmx,nlaykim_up))
    allocate(CH2_S(ip1jmp1,nlaykim_up))
    allocate(CH3(ngridmx,nlaykim_up))
    allocate(CH3_S(ip1jmp1,nlaykim_up))
    allocate(CH4(ngridmx,nlaykim_up))
    allocate(CH4_S(ip1jmp1,nlaykim_up))
    allocate(C2(ngridmx,nlaykim_up))
    allocate(C2_S(ip1jmp1,nlaykim_up))
    allocate(C2H(ngridmx,nlaykim_up))
    allocate(C2H_S(ip1jmp1,nlaykim_up))
    allocate(C2H2(ngridmx,nlaykim_up))
    allocate(C2H2_S(ip1jmp1,nlaykim_up))
    allocate(C2H3(ngridmx,nlaykim_up))
    allocate(C2H3_S(ip1jmp1,nlaykim_up))
    allocate(C2H4(ngridmx,nlaykim_up))
    allocate(C2H4_S(ip1jmp1,nlaykim_up))
    allocate(C2H5(ngridmx,nlaykim_up))
    allocate(C2H5_S(ip1jmp1,nlaykim_up))
    allocate(C2H6(ngridmx,nlaykim_up))
    allocate(C2H6_S(ip1jmp1,nlaykim_up))
    allocate(C3H3(ngridmx,nlaykim_up))
    allocate(C3H3_S(ip1jmp1,nlaykim_up))
    allocate(C3H5(ngridmx,nlaykim_up))
    allocate(C3H5_S(ip1jmp1,nlaykim_up))
    allocate(C3H6(ngridmx,nlaykim_up))
    allocate(C3H6_S(ip1jmp1,nlaykim_up))
    allocate(C3H7(ngridmx,nlaykim_up))
    allocate(C3H7_S(ip1jmp1,nlaykim_up))
    allocate(C4H(ngridmx,nlaykim_up))
    allocate(C4H_S(ip1jmp1,nlaykim_up))
    allocate(C4H3(ngridmx,nlaykim_up))
    allocate(C4H3_S(ip1jmp1,nlaykim_up))
    allocate(C4H4(ngridmx,nlaykim_up))
    allocate(C4H4_S(ip1jmp1,nlaykim_up))
    allocate(C4H2s(ngridmx,nlaykim_up))
    allocate(C4H2s_S(ip1jmp1,nlaykim_up))
    allocate(CH2CCH2(ngridmx,nlaykim_up))
    allocate(CH2CCH2_S(ip1jmp1,nlaykim_up))
    allocate(CH3CCH(ngridmx,nlaykim_up))
    allocate(CH3CCH_S(ip1jmp1,nlaykim_up))
    allocate(C3H8(ngridmx,nlaykim_up))
    allocate(C3H8_S(ip1jmp1,nlaykim_up))
    allocate(C4H2(ngridmx,nlaykim_up))
    allocate(C4H2_S(ip1jmp1,nlaykim_up))
    allocate(C4H6(ngridmx,nlaykim_up))
    allocate(C4H6_S(ip1jmp1,nlaykim_up))
    allocate(C4H10(ngridmx,nlaykim_up))
    allocate(C4H10_S(ip1jmp1,nlaykim_up))
    allocate(AC6H6(ngridmx,nlaykim_up))
    allocate(AC6H6_S(ip1jmp1,nlaykim_up))
    allocate(C3H2(ngridmx,nlaykim_up))
    allocate(C3H2_S(ip1jmp1,nlaykim_up))
    allocate(C4H5(ngridmx,nlaykim_up))
    allocate(C4H5_S(ip1jmp1,nlaykim_up))
    allocate(AC6H5(ngridmx,nlaykim_up))
    allocate(AC6H5_S(ip1jmp1,nlaykim_up))
    allocate(N2(ngridmx,nlaykim_up))
    allocate(N2_S(ip1jmp1,nlaykim_up))
    allocate(N4S(ngridmx,nlaykim_up))
    allocate(N4S_S(ip1jmp1,nlaykim_up))
    allocate(CN(ngridmx,nlaykim_up))
    allocate(CN_S(ip1jmp1,nlaykim_up))
    allocate(HCN(ngridmx,nlaykim_up))
    allocate(HCN_S(ip1jmp1,nlaykim_up))
    allocate(H2CN(ngridmx,nlaykim_up))
    allocate(H2CN_S(ip1jmp1,nlaykim_up))
    allocate(CHCN(ngridmx,nlaykim_up))
    allocate(CHCN_S(ip1jmp1,nlaykim_up))
    allocate(CH2CN(ngridmx,nlaykim_up))
    allocate(CH2CN_S(ip1jmp1,nlaykim_up))
    allocate(CH3CN(ngridmx,nlaykim_up))
    allocate(CH3CN_S(ip1jmp1,nlaykim_up))
    allocate(C3N(ngridmx,nlaykim_up))
    allocate(C3N_S(ip1jmp1,nlaykim_up))
    allocate(HC3N(ngridmx,nlaykim_up))
    allocate(HC3N_S(ip1jmp1,nlaykim_up))
    allocate(NCCN(ngridmx,nlaykim_up))
    allocate(NCCN_S(ip1jmp1,nlaykim_up))
    allocate(C4N2(ngridmx,nlaykim_up))
    allocate(C4N2_S(ip1jmp1,nlaykim_up))
  
  END SUBROUTINE alloc_kim_start2archive

END MODULE comchem_startarch_h
