#!/usr/bin/env python

### A. Spiga -- LMD -- 30/05/2011
### Thanks to A. Colaitis for the parser trick


####################################
####################################
### The main program to plot vectors
def winds (namefile,\
           nvert,\
           proj=None,\
           back=None,\
           target=None,
           stride=3,\
           numplot=4,\
           var=None): 

    #################################
    ### Load librairies and functions
    from netCDF4 import Dataset
    from myplot import getcoord2d,define_proj,makeplotpng,simplinterv,vectorfield,ptitle,latinterv,getproj,wrfinterv,dumpbdy
    from matplotlib.pyplot import contourf, subplot, figure, rcParams, savefig
    import numpy as np

    #############################
    ### Lower a bit the font size
    rcParams['font.size'] = int( rcParams['font.size'] * 2. / 3. )

    ######################
    ### Load NETCDF object
    nc  = Dataset(namefile)

    ###################################
    ### Recognize predefined file types
    if 'controle' in nc.variables:   typefile = 'gcm'
    elif 'Um' in nc.variables:       typefile = 'mesoapi'
    elif 'U' in nc.variables:        typefile = 'meso'
    else:                            
        print "typefile not supported."
        exit()

    ##############################################################
    ### Try to guess the projection from wrfout if not set by user 
    if typefile in ['mesoapi','meso']:
        if proj == None:       proj = getproj(nc)
                                    ### (il faudrait passer CEN_LON dans la projection ?)
    elif typefile in ['gcm']:
        if proj == None:       proj = "cyl"   
                                    ## pb avec les autres (de trace derriere la sphere ?)

    ###################################################################
    ### For mesoscale results plot the underlying topography by default 
    if typefile in ['mesoapi','meso']: 
        if var == None: var = 'HGT'

    ####################################################
    ### Get geographical coordinates and plot boundaries
    if typefile in ['mesoapi','meso']:
        [lon2d,lat2d] = getcoord2d(nc)
        lon2d = dumpbdy(lon2d)
        lat2d = dumpbdy(lat2d)
    elif typefile in ['gcm']:
        [lon2d,lat2d] = getcoord2d(nc,nlat="latitude",nlon="longitude",is1d=True)
    if proj == "npstere":    [wlon,wlat] = latinterv("North_Pole")
    elif proj == "lcc":      [wlon,wlat] = wrfinterv(lon2d,lat2d)
    else:                    [wlon,wlat] = simplinterv(lon2d,lat2d)

    ##################
    ### Get local time
    if typefile in ['mesoapi','meso']:  ltst = int(getattr(nc, 'GMT') + 0.5*(wlon[0]+wlon[1])/15.)
    elif typefile in ['gcm']:           ltst = 0

    ##############################################################################
    ### Get winds and know if those are meteorological winds (ie. zon, mer) or not
    if typefile is 'mesoapi': 
        [u,v] = getwinds(nc)
        metwind = True  ## meteorological (zon/mer)
    elif typefile is 'gcm':
        [u,v] = getwinds(nc,charu='u',charv='v')
        metwind = True  ## meteorological (zon/mer)
    elif typefile is 'meso':
        [u,v] = getwinds(nc,charu='U',charv='V')
        metwind = False ## geometrical (wrt grid)

    ####################################################
    ### Load the chosen variables, whether it is 2D or 3D
    if var:
        if var not in nc.variables: 
            print "not found in file:",var
            exit()
        else:   
            dimension = np.array(nc.variables[var]).ndim
            if dimension == 2:     field = nc.variables[var][:,:]
            elif dimension == 3:   field = nc.variables[var][:,:,:]
            elif dimension == 4:   field = nc.variables[var][:,nvert,:,:]  

    ##################################
    ### Open a figure and set subplots
    fig = figure()
    if   numplot == 4: 
        sub = 221
        fig.subplots_adjust(wspace = 0.1, hspace = 0.3)
    elif numplot == 2: 
        sub = 121
        fig.subplots_adjust(wspace = 0.3)
    elif numplot == 3: 
        sub = 131
        fig.subplots_adjust(wspace = 0.3)
    elif numplot == 6: 
        sub = 231
        fig.subplots_adjust(wspace = 0.4, hspace = 0.0)
    elif numplot == 8: 
        sub = 331 #241
        fig.subplots_adjust(wspace = 0.1, hspace = 0.3)
    else:
        print "supported: 1,2,3,4,6,8"
        exit()

    #####################
    ### Prepare time loop
    nt = len(u[:,0,0,0])
    if nt <= numplot or numplot == 1:  
        print "I am plotting only one map ",nt,numplot
        tabrange = [0]
    else:                          
        tabrange = range(0,nt-1,int(nt/numplot))

    #################################
    ### Time loop for plotting device
    for i in tabrange:

       print i

       ### General plot settings
       if tabrange != [0]: subplot(sub)
       zetitle = "WINDS" + "_"

       ### Map projection
       m = define_proj(proj,wlon,wlat,back=back)
       x, y = m(lon2d, lat2d)

       #### Contour plot
       if var:
           zetitle = zetitle + var + "_"
           if typefile in ['mesoapi','meso']:    what_I_plot = dumpbdy(field[i,:,:])
           elif typefile in ['gcm']:             
               if dimension == 2:                what_I_plot = field[:,:]
               elif dimension == 3:              what_I_plot = field[i,:,:]
           contourf(x, y, what_I_plot, 30)

       ### Vector plot
       if   typefile in ['mesoapi','meso']:    
           [vecx,vecy] = [dumpbdy(u[i,nvert,:,:]), dumpbdy(v[i,nvert,:,:])]
           key = True
       elif typefile in ['gcm']:               
           [vecx,vecy] = [        u[i,nvert,:,:] ,         v[i,nvert,:,:] ]
           key = False
       if metwind:  [vecx,vecy] = m.rotate_vector(vecx, vecy, lon2d, lat2d)
       else:        print "Beware ! Not using meteorological winds. You trust numerical grid as being (x,y)."
       vectorfield(vecx, vecy,\
                      x, y, stride=stride, csmooth=2,\
                      scale=15., factor=200., color='k', key=key)
       
       ### Next subplot
       zetitle = zetitle + "LT"+str((ltst+i)%24)
       ptitle(zetitle)
       sub += 1

    ##########################################################################
    ### Save the figure in a file in the data folder or an user-defined folder
    if not target:   zeplot = namefile+zetitle
    else:            zeplot = target+"/"+zetitle
    makeplotpng(zeplot,pad_inches_value=0.35)   



####################################################
####################################################
### A simple program to get wind vectors' components
def getwinds (nc,charu='Um',charv='Vm'):
    import numpy as np
    u = nc.variables[charu]
    v = nc.variables[charv]
    if charu == 'U': u = u[:, :, :, 0:len(u[0,0,0,:])-1]
    if charv == 'V': v = v[:, :, 0:len(v[0,0,:,0])-1, :]
                     ### ou alors prendre les coordonnees speciales
    return u,v



###########################################################################################
###########################################################################################
### What is below relate to running the file as a command line executable (very convenient)
if __name__ == "__main__":
    import sys
    from optparse import OptionParser    ### to be replaced by argparse
    parser = OptionParser()
    parser.add_option('-f', action='store', dest='namefile',    type="string",  default=None,  help='name of WRF file [NEEDED]')
    parser.add_option('-l', action='store', dest='nvert',       type="int",     default=0,     help='subscript for vertical level')
    parser.add_option('-p', action='store', dest='proj',        type="string",  default=None,  help='projection')
    parser.add_option('-b', action='store', dest='back',        type="string",  default=None,  help='background')
    parser.add_option('-t', action='store', dest='target',      type="string",  default=None,  help='destination folder')
    parser.add_option('-s', action='store', dest='stride',      type="int",     default=3,     help='stride vectors')
    parser.add_option('-v', action='store', dest='var',         type="string",  default=None,  help='variable contoured')
    parser.add_option('-n', action='store', dest='numplot',     type="int",     default=4,     help='number of plots')
    (opt,args) = parser.parse_args()
    if opt.namefile is None: 
        print "I want to eat one file at least ! Use winds.py -f name_of_my_file. Or type winds.py -h"
        exit()
    print "Options:", opt
    winds (opt.namefile,opt.nvert,proj=opt.proj,back=opt.back,target=opt.target,stride=opt.stride,var=opt.var,numplot=opt.numplot)

#    if typefile in ['gcm']:
#        if var == 'HGT':    var = 'phisinit'  ## default choice for GCM


