SUBROUTINE OPTCV(PQ,PLEV,TMID,PMID,  &
     DTAUV,TAUV,TAUCUMV,WBARV,COSBV,TAURAY,TAUGSURF)

  use radinc_h
  use radcommon_h, only: gasv, tlimit, Cmk, tgasref, pfgasref,wnov,scalep,indv,glat_ig,gweight
  use gases_h
  use comcstfi_mod, only: g, r
  use callkeys_mod, only: continuum,graybody,callgasvis

  implicit none

  !==================================================================
  !     
  !     Purpose
  !     -------
  !     Calculates shortwave optical constants at each level.
  !     
  !     Authors
  !     -------
  !     Adapted from the NASA Ames code by R. Wordsworth (2009)
  !     Clean and adaptation to Titan by J. Vatant d'Ollone (2016-17)
  !     
  !==================================================================
  !     
  !     THIS SUBROUTINE SETS THE OPTICAL CONSTANTS IN THE VISUAL  
  !     IT CALCULATES FOR EACH LAYER, FOR EACH SPECTRAL INTERVAL IN THE VISUAL
  !     LAYER: WBAR, DTAU, COSBAR
  !     LEVEL: TAU
  !     
  !     TAUV(L,NW,NG) is the cumulative optical depth at the top of radiation code
  !     layer L. NW is spectral wavelength interval, ng the Gauss point index.
  !     
  !     TLEV(L) - Temperature at the layer boundary
  !     PLEV(L) - Pressure at the layer boundary (i.e. level)
  !     GASV(NT,NPS,NW,NG) - Visible k-coefficients 
  !     
  !-------------------------------------------------------------------


  !==========================================================
  ! Input/Output
  !==========================================================
  REAL*8, INTENT(IN)  :: PQ ! Tracers (kg/kg_of_air).
  REAL*8, INTENT(IN)  :: PLEV(L_LEVELS)
  REAL*8, INTENT(IN)  :: TMID(L_LEVELS), PMID(L_LEVELS)
  
  REAL*8, INTENT(OUT) :: DTAUV(L_NLAYRAD,L_NSPECTV,L_NGAUSS)
  REAL*8, INTENT(OUT) :: TAUV(L_NLEVRAD,L_NSPECTV,L_NGAUSS)
  REAL*8, INTENT(OUT) :: TAUCUMV(L_LEVELS,L_NSPECTV,L_NGAUSS)
  REAL*8, INTENT(OUT) :: COSBV(L_NLAYRAD,L_NSPECTV,L_NGAUSS)
  REAL*8, INTENT(OUT) :: WBARV(L_NLAYRAD,L_NSPECTV,L_NGAUSS)
  REAL*8, INTENT(OUT) :: TAURAY(L_NSPECTV)
  REAL*8, INTENT(OUT) :: TAUGSURF(L_NSPECTV,L_NGAUSS-1)
  ! ==========================================================
  
  real*8 DTAUKV(L_LEVELS,L_NSPECTV,L_NGAUSS)

  ! Titan customisation
  ! J. Vatant d'Ollone (2016)
  real*8 DHAZE_T(L_LEVELS,L_NSPECTI)
  real*8 DHAZES_T(L_LEVELS,L_NSPECTI)
  real*8 SSA_T(L_LEVELS,L_NSPECTI)
  real*8 ASF_T(L_LEVELS,L_NSPECTI)
  real*8 INT_DTAU(L_NLAYRAD,L_NSPECTI)
  real*8 K_HAZE(L_NLAYRAD,L_NSPECTI)
  
  CHARACTER*2  str2
  ! ==========================

  integer L, NW, NG, K, LK, IAER
  integer MT(L_LEVELS), MP(L_LEVELS), NP(L_LEVELS)
  real*8  ANS, TAUGAS
  real*8  TRAY(L_LEVELS,L_NSPECTV)
  real*8  DPR(L_LEVELS), U(L_LEVELS)
  real*8  LCOEF(4), LKCOEF(L_LEVELS,4)

  real*8 DCONT
  real*8 DRAYAER
  double precision wn_cont, p_cont, p_air, T_cont, dtemp, dtempc
  double precision p_cross

  real*8  KCOEF(4)
  
  ! temporary variable to reduce memory access time to gasv
  real*8 tmpk(2,2)

  ! temporary variables for multiple aerosol calculation
  real*8 atemp(L_NLAYRAD,L_NSPECTV)
  real*8 btemp(L_NLAYRAD,L_NSPECTV)
  real*8 ctemp(L_NLAYRAD,L_NSPECTV)

  ! variables for k in units m^-1
  real*8 dz(L_LEVELS)

  integer igas, jgas, ilay

  integer interm

  !! AS: to save time in computing continuum (see bilinearbig)
  IF (.not.ALLOCATED(indv)) THEN
      ALLOCATE(indv(L_NSPECTV,ngasmx,ngasmx))
      indv = -9999 ! this initial value means "to be calculated"
  ENDIF
  
  ! Some initialisation beacause there's a pb with disr_haze at the limits (nw=1)
  ! I should check this - For now we set vars to zero : better than nans - JVO 2017
  
  dhaze_t(:,:) = 0.
  ssa_t(:,:) = 0.
  asf_t(:,:) = 0.


  !=======================================================================
  !     Determine the total gas opacity throughout the column, for each
  !     spectral interval, NW, and each Gauss point, NG.
  !     Calculate the continuum opacities, i.e., those that do not depend on
  !     NG, the Gauss index.

  taugsurf(:,:) = 0.0
  dpr(:)        = 0.0
  lkcoef(:,:)   = 0.0

  do K=2,L_LEVELS
     DPR(k) = PLEV(K)-PLEV(K-1)

     ! if we have continuum opacities, we need dz

      dz(k) = dpr(k)*R*TMID(K)/(glat_ig*PMID(K))
      U(k)  = Cmk*DPR(k)     ! only Cmk line in optcv.F     

     call tpindex(PMID(K),TMID(K),pfgasref,tgasref,LCOEF,MT(K),MP(K))

     do LK=1,4
        LKCOEF(K,LK) = LCOEF(LK)
     end do
  end do                    ! levels

  ! Rayleigh scattering
  do NW=1,L_NSPECTV
     do K=2,L_LEVELS
        TRAY(K,NW)   = TAURAY(NW) * DPR(K)
     end do                    ! levels
  end do
  
  !     we ignore K=1...
  do K=2,L_LEVELS
  
     ilay = k / 2 ! int. arithmetic => gives the gcm layer index

     do NW=1,L_NSPECTV

        !================= Titan customisation ========================================
        call disr_haze(dz(k),plev(k),wnov(nw),dhaze_T(k,nw),SSA_T(k,nw),ASF_T(k,nw))
        ! =============================================================================
         
        DRAYAER = TRAY(K,NW)
        !     DRAYAER is Tau RAYleigh scattering, plus AERosol opacity
        DRAYAER = DRAYAER + DHAZE_T(K,NW) ! Titan's aerosol

        DCONT = 0.0 ! continuum absorption

        if(continuum.and.(.not.graybody).and.callgasvis)then
           ! include continua if necessary
           wn_cont = dble(wnov(nw))
           T_cont  = dble(TMID(k))
           do igas=1,ngasmx

              p_cont  = dble(PMID(k)*scalep*gfrac(igas,ilay))

              dtemp=0.0
              if(igas.eq.igas_N2)then

                 interm = indv(nw,igas,igas)
!                 call interpolateN2N2(wn_cont,T_cont,p_cont,dtemp,.false.,interm)
                 indv(nw,igas,igas) = interm
                 ! only goes to 500 cm^-1, so unless we're around a cold brown dwarf, this is irrelevant in the visible

              elseif(igas.eq.igas_H2)then

                 ! first do self-induced absorption
                 interm = indv(nw,igas,igas)
                 call interpolateH2H2(wn_cont,T_cont,p_cont,dtemp,.false.,interm)
                 indv(nw,igas,igas) = interm

                 ! then cross-interactions with other gases
                 do jgas=1,ngasmx
                    p_cross = dble(PMID(k)*scalep*gfrac(jgas,ilay))
                    dtempc  = 0.0
                    if(jgas.eq.igas_N2)then 
                       interm = indv(nw,igas,jgas)
                       call interpolateN2H2(wn_cont,T_cont,p_cross,p_cont,dtempc,.false.,interm)
                       indv(nw,igas,jgas) = interm
                       ! should be irrelevant in the visible
                    endif
                    dtemp = dtemp + dtempc
                 enddo

               elseif(igas.eq.igas_CH4)then

                 ! first do self-induced absorption
                 interm = indv(nw,igas,igas)
                 call interpolateCH4CH4(wn_cont,T_cont,p_cont,dtemp,.false.,interm)
                 indv(nw,igas,igas) = interm

                 ! then cross-interactions with other gases
                 do jgas=1,ngasmx
                    p_cross = dble(PMID(k)*scalep*gfrac(jgas,ilay))
                    dtempc  = 0.0
                    if(jgas.eq.igas_N2)then 
                       interm = indv(nw,igas,jgas)
                       call interpolateN2CH4(wn_cont,T_cont,p_cross,p_cont,dtempc,.false.,interm)
                       indv(nw,igas,jgas) = interm
                    endif
                    dtemp = dtemp + dtempc
                 enddo

              endif

              DCONT = DCONT + dtemp

           enddo

           DCONT = DCONT*dz(k)

        endif

        do ng=1,L_NGAUSS-1

           ! Now compute TAUGAS

           ! JVO 2017 : added tmpk because the repeated calls to gasi/v increased dramatically
           ! the execution time of optci/v -> ~ factor 2 on the whole radiative
           ! transfer on the tested simulations !

           tmpk = GASV(MT(K):MT(K)+1,MP(K):MP(K)+1,1,NW,NG)
              
           KCOEF(1) = tmpk(1,1) ! KCOEF(1) = GASV(MT(K),MP(K),1,NW,NG)
           KCOEF(2) = tmpk(1,2) ! KCOEF(2) = GASV(MT(K),MP(K)+1,1,NW,NG)
           KCOEF(3) = tmpk(2,2) ! KCOEF(3) = GASV(MT(K)+1,MP(K)+1,1,NW,NG)
           KCOEF(4) = tmpk(2,1) ! KCOEF(4) = GASV(MT(K)+1,MP(K),1,NW,NG)

           ! Interpolate the gaseous k-coefficients to the requested T,P values

           ANS = LKCOEF(K,1)*KCOEF(1) + LKCOEF(K,2)*KCOEF(2) +            &
                LKCOEF(K,3)*KCOEF(3) + LKCOEF(K,4)*KCOEF(4)


           TAUGAS  = U(k)*ANS

           TAUGSURF(NW,NG) = TAUGSURF(NW,NG) + TAUGAS + DCONT
           DTAUKV(K,nw,ng) = TAUGAS & 
                             + DRAYAER & ! DRAYAER includes all scattering contributions
                             + DCONT ! For parameterized continuum aborption

        end do

        ! Now fill in the "clear" part of the spectrum (NG = L_NGAUSS),
        ! which holds continuum opacity only

        NG              = L_NGAUSS
        DTAUKV(K,nw,ng) = DRAYAER + DCONT ! Scattering + parameterized continuum absorption, including Titan's haze

     end do
  end do


  !=======================================================================
  !     Now the full treatment for the layers, where besides the opacity
  !     we need to calculate the scattering albedo and asymmetry factors

  ! Haze scattering
  DO NW=1,L_NSPECTV
    DO K=2,L_LEVELS
      DHAZES_T(K,NW) = DHAZE_T(K,NW) * SSA_T(K,NW) ! effect of scattering albedo on haze
    ENDDO
  ENDDO


  DO NW=1,L_NSPECTV
     DO L=1,L_NLAYRAD-1
        K              = 2*L+1
	atemp(L,NW) = ASF_T(K,NW)*DHAZES_T(K,NW) + ASF_T(K+1,NW)*DHAZES_T(K+1,NW)
        btemp(L,NW) = DHAZES_T(K,NW) + DHAZES_T(K+1,NW)
	ctemp(L,NW) = btemp(L,NW) + 0.9999*(TRAY(K,NW) + TRAY(K+1,NW)) ! JVO 2017 : does this 0.999 is really meaningful ?
	btemp(L,NW) = btemp(L,NW) + TRAY(K,NW) + TRAY(K+1,NW)
	COSBV(L,NW,1:L_NGAUSS) = atemp(L,NW)/btemp(L,NW)
     END DO ! L vertical loop
     
     ! Last level
     L           = L_NLAYRAD
     K           = 2*L+1
     atemp(L,NW) = ASF_T(K,NW)*DHAZES_T(K,NW)
     btemp(L,NW) = DHAZES_T(K,NW)
     ctemp(L,NW) = btemp(L,NW) + 0.9999*TRAY(K,NW) ! JVO 2017 : does this 0.999 is really meaningful ?
     btemp(L,NW) = btemp(L,NW) + TRAY(K,NW)
     COSBV(L,NW,1:L_NGAUSS) = atemp(L,NW)/btemp(L,NW)
     
     
  END DO                    ! NW spectral loop

  DO NG=1,L_NGAUSS
    DO NW=1,L_NSPECTV
     DO L=1,L_NLAYRAD-1

        K              = 2*L+1
        DTAUV(L,nw,ng) = DTAUKV(K,NW,NG) + DTAUKV(K+1,NW,NG)
        WBARV(L,nw,ng) = ctemp(L,NW) / DTAUV(L,nw,ng)

      END DO ! L vertical loop

        ! Last level

        L              = L_NLAYRAD
        K              = 2*L+1
	DTAUV(L,nw,ng) = DTAUKV(K,NW,NG)

        WBARV(L,NW,NG) = ctemp(L,NW) / DTAUV(L,NW,NG)

     END DO                 ! NW spectral loop
  END DO                    ! NG Gauss loop

  ! Total extinction optical depths

  DO NG=1,L_NGAUSS       ! full gauss loop
     DO NW=1,L_NSPECTV       
        TAUV(1,NW,NG)=0.0D0
        DO L=1,L_NLAYRAD
           TAUV(L+1,NW,NG)=TAUV(L,NW,NG)+DTAUV(L,NW,NG)
        END DO

        TAUCUMV(1,NW,NG)=0.0D0
        DO K=2,L_LEVELS
           TAUCUMV(K,NW,NG)=TAUCUMV(K-1,NW,NG)+DTAUKV(K,NW,NG)
        END DO
     END DO            
  END DO                 ! end full gauss loop


!  Titan's outputs (JVO, 2016)===============================================
!      do l=1,L_NLAYRAD
!         do nw=1,L_NSPECTV
!          INT_DTAU(L,NW) = 0.0d+0
!            DO NG=1,L_NGAUSS
!               INT_DTAU(L,NW)= INT_DTAU(L,NW) + dtauv(L,nw,ng)*gweight(NG) 
!            enddo
!         enddo
!      enddo

!	do nw=1,L_NSPECTV
!          write(str2,'(i2.2)') nw
!	  call writediagfi(1,'kgv'//str2,'Gaz extinction coefficient VI band '//str2,'m-1',1,int_dtau(L_NLAYRAD:1:-1,nw)/dz_lay(L_NLAYRAD:1:-1))
!          call writediagfi(1,'khv'//str2,'Haze extinction coefficient VI band '//str2,'m-1',1,k_haze(L_NLAYRAD:1:-1,nw)/dz_lay(L_NLAYRAD:1:-1))	
!	enddo  

! ==============================================================================  


  return


end subroutine optcv
