#!/usr/bin/env python

### A. Spiga and A. Colaitis -- LMD -- 30/05/2011

def winds (namefile,\
           nvert,\
           proj="cyl",\
           back=None,\
           target=None,
           stride=5,\
           var='HGT'): 
    from netCDF4 import Dataset
    from myplot import getcoord2d,define_proj,makeplotpng,simplinterv,vectorfield,ptitle
    from matplotlib.pyplot import contourf, subplot, figure
    import numpy as np
    nc  = Dataset(namefile)
    [lon2d,lat2d] = getcoord2d(nc)
    [wlon,wlat] = simplinterv(lon2d,lat2d)
    [u,v] = getwinds(nc)
    nt = len(u[:,0,0,0])
    if var not in nc.variables: 
        print "not found in file:",var
        exit()
    else:   
        dimension = np.array(nc.variables[var]).ndim
        if dimension == 3:     what_I_plot = nc.variables[var][:,:,:]
        elif dimension == 4:   what_I_plot = nc.variables[var][:,nvert,:,:]  
    fig = figure()
    fig.subplots_adjust(wspace = 0.0, hspace = 0.3)
    sub = 221
    for i in range(0,nt-1,int(nt/4.)):
       subplot(sub)
       ptitle("Winds time"+str(i)+" level"+str(nvert))
       m = define_proj(proj,wlon,wlat,back=back)
       x, y = m(lon2d, lat2d)
       contourf(x, y, what_I_plot[i,:,:], 30)
       vectorfield(u[i,nvert,:,:], v[i,nvert,:,:],\
                      x, y, stride=stride, csmooth=2,\
                      scale=20., factor=300., color='k')
       sub += 1
    if not target:   zeplot = namefile+".winds"+var+str(nvert)
    else:            zeplot = target+"/winds"+var+str(nvert)
    makeplotpng(zeplot,pad_inches_value=0.35)   

def getwinds (nc,charu='U',charv='V'):
    import numpy as np
    u = nc.variables[charu]
    v = nc.variables[charv]
    if charu == 'U': u = u[:, :, :, 0:len(u[0,0,0,:])-1]
    if charv == 'V': v = v[:, :, 0:len(v[0,0,:,0])-1, :]
    #print np.array(u).shape, np.array(v).shape
    return u,v

if __name__ == "__main__":
    import sys
    ### to be replaced by argparse
    from optparse import OptionParser
    parser = OptionParser()
    parser.add_option('-f', action='store', dest='namefile',    type="string",  default=None,  help='name of WRF file [NEEDED]')
    parser.add_option('-l', action='store', dest='nvert',       type="int",     default=0,     help='subscript for vertical level')
    parser.add_option('-p', action='store', dest='proj',        type="string",  default='cyl', help='projection')
    parser.add_option('-b', action='store', dest='back',        type="string",  default=None,  help='background')
    parser.add_option('-t', action='store', dest='target',      type="string",  default=None,  help='destination folder')
    parser.add_option('-s', action='store', dest='stride',      type="int",     default=5,     help='stride vectors')
    parser.add_option('-v', action='store', dest='var',         type="string",  default='HGT', help='variable contoured')
    (opt,args) = parser.parse_args()
    if opt.namefile is None: 
        print "I want to eat one file at least ! Use winds.py -f name_of_my_file. Or type winds.py -h"
        exit()
    print "Options:", opt
    winds (opt.namefile,opt.nvert,proj=opt.proj,back=opt.back,target=opt.target,stride=opt.stride,var=opt.var)
