#!/usr/bin/env python

### A. Spiga LMD 29/05/2011

def usage():
    print 'USAGE:  plot.py file (target)'
    print 'file  : name of input netcdf file.'
    print '(target) : a directory with write rights.'
    print 'Example:  domain.py /d5/aslmd/LMD_MM_MARS_SIMUS/OM/OM6_TI85/wrfout_d01_2024-06-43_06:00:00 ~/'

def domain (namefile,proj="ortho",back="molabw",target=None): #vishires
    from netCDF4 import Dataset
    from myplot import getcoord2d,define_proj,makeplotpng,simplinterv
    from matplotlib.pyplot import contourf
    nc  = Dataset(namefile)
    [lon2d,lat2d] = getcoord2d(nc)
    [wlon,wlat] = simplinterv(lon2d,lat2d)
    m = define_proj(proj,wlon,wlat,back=back)
    x, y = m(lon2d, lat2d)
    contourf(x, y, nc.variables['HGT'][0,:,:] / 1000., 50)
    if not target:   zeplot = namefile+".domain"
    else:            zeplot = target+"domain"
    makeplotpng(zeplot,pad_inches_value=0.35)

if __name__ == "__main__":
    import sys
    if (len(sys.argv)) == 2:     domain( str(sys.argv[1]) )
    elif (len(sys.argv)) == 3:   domain( str(sys.argv[1]) , target = str(sys.argv[2]) )
