def latinterv (area):
	if   area == "Europe": 
		wlat = [20.,80.]
		wlon = [-50.,50.]
	elif area == "Central_America":
		wlat = [-10.,40.]
		wlon = [230.,300.]
	elif area == "Africa":
		wlat = [-20.,50.]
		wlon = [-50.,50.]
	elif area == "Whole":
		wlat = [-90.,90.]
		wlon = [-180.,180.]
	elif area == "Southern_Hemisphere":
		wlat = [-90.,60.]
		wlon = [-180.,180.]
        elif area == "Northern_Hemisphere":
                wlat = [-60.,90.]
                wlon = [-180.,180.]
        elif area == "Tharsis":
		wlat = [-30.,60.]
		wlon = [-170.,-10.]
	elif area == "Whole_No_High":
		wlat = [-60.,60.]
		wlon = [-180.,180.]
	elif area == "Chryse":
                wlat = [-60.,60.]
                wlon = [-60.,60.]
        elif area == "North_Pole":
                wlat = [60.,90.]
                wlon = [-180.,180.]
        elif area == "Close_North_Pole":
                wlat = [75.,90.]
                wlon = [-180.,180.]
	return wlon,wlat

def ptitle (name):
    from matplotlib.pyplot import title
    title(name)
    print name

def simplinterv (lon2d,lat2d):
    import numpy as np
    return [[np.min(lon2d),np.max(lon2d)],[np.min(lat2d),np.max(lat2d)]]

def makeplotpngres (filename,res,pad_inches_value=0.25,folder='',disp=True):
    import  matplotlib.pyplot as plt
    res = int(res)
    if folder != '':      name = folder+'/'+filename+str(res)+".png"
    else:           	  name = filename+str(res)+".png"
    plt.savefig(name,dpi=res,bbox_inches='tight',pad_inches=pad_inches_value)
    if disp:              display(name)		
    return

def makeplotpng (filename,pad_inches_value=0.25,minres=100.,folder=''):
    makeplotpngres(filename,minres,     pad_inches_value=pad_inches_value,folder=folder)
    makeplotpngres(filename,minres+200.,pad_inches_value=pad_inches_value,folder=folder,disp=False)
    return

def getcoord2d (nc,nlat='XLAT',nlon='XLONG'):
	import numpy as np
	lat = nc.variables[nlat][0,:,:]
	lon = nc.variables[nlon][0,:,:]
	if np.array(lat).ndim != 2:	[lon2d,lat2d] = np.meshgrid(lon,lat)
	else:				[lon2d,lat2d] = [lon,lat]
	return lon2d,lat2d

def smooth (field, coeff):
	## actually blur_image could work with different coeff on x and y
	if coeff > 1:	result = blur_image(field,int(coeff))
	else:		result = field
	return result

def gauss_kern(size, sizey=None):
	import numpy as np
	## FROM COOKBOOK http://www.scipy.org/Cookbook/SignalSmooth	
    	# Returns a normalized 2D gauss kernel array for convolutions
    	size = int(size)
    	if not sizey:
	        sizey = size
	else:
	        sizey = int(sizey)
	x, y = np.mgrid[-size:size+1, -sizey:sizey+1]
	g = np.exp(-(x**2/float(size)+y**2/float(sizey)))
	return g / g.sum()

def blur_image(im, n, ny=None) :
	from scipy.signal import convolve
	## FROM COOKBOOK http://www.scipy.org/Cookbook/SignalSmooth
	# blurs the image by convolving with a gaussian kernel of typical size n. 
	# The optional keyword argument ny allows for a different size in the y direction.
    	g = gauss_kern(n, sizey=ny)
    	improc = convolve(im, g, mode='same')
    	return improc

def vectorfield (u, v, x, y, stride=3, scale=15., factor=250., color='black', csmooth=1):
	## scale regle la reference du vecteur
	## factor regle toutes les longueurs (dont la reference). l'AUGMENTER pour raccourcir les vecteurs.
	import  matplotlib.pyplot               as plt
	import  numpy                           as np
	posx = np.max(x)*0.90 
	posy = np.mean(y)
	u = smooth(u,csmooth)
	v = smooth(v,csmooth)
	q = plt.quiver(	x[::stride,::stride],\
			y[::stride,::stride],\
			u[::stride,::stride],\
			v[::stride,::stride],\
			angles='xy',color=color,\
			scale=factor,width=0.003 )
	if color=='white':	kcolor='black'
	elif color=='yellow':	kcolor=color
	else:			kcolor=color
	p = plt.quiverkey(q,posx,posy,scale,\
			str(int(scale)),coordinates='data',color=kcolor)
	return p

def display (name):
	from 	os 				import system
	system("display "+name+" > /dev/null 2> /dev/null &")
	return name

def findstep (wlon):
    steplon = int((wlon[1]-wlon[0])/3.)
    step = 60.
    if steplon < 60.: step = 30.
    if steplon < 30.: step = 15.
    if steplon < 15.: step = 10.
    if steplon < 10.: step = 5.
    if steplon < 5.:  step = 1.
    return step

def define_proj (char,wlon,wlat,back="."):
    from    mpl_toolkits.basemap            import Basemap
    import  numpy                           as np
    import  matplotlib                      as mpl
    meanlon = 0.5*(wlon[0]+wlon[1])
    meanlat = 0.5*(wlat[0]+wlat[1])
    h = 2000.
    if   char == "cyl":     m = Basemap(projection='cyl',llcrnrlat=wlat[0],urcrnrlat=wlat[1],llcrnrlon=wlon[0],urcrnrlon=wlon[1])
    elif char == "moll":    m = Basemap(projection='moll',lon_0=meanlon)
    elif char == "ortho":   m = Basemap(projection='ortho',lon_0=meanlon,lat_0=meanlat)
    elif char == "lcc":     m = Basemap(projection='lcc',lat_1=meanlat,lat_0=meanlat,lon_0=meanlon,\
                              llcrnrlat=wlat[0],urcrnrlat=wlat[1],llcrnrlon=wlon[0],urcrnrlon=wlon[1])
    elif char == "npstere": m = Basemap(projection='npstere', boundinglat=wlat[0], lon_0=0.)
    elif char == "spstere": m = Basemap(projection='spstere', boundinglat=wlat[0], lon_0=0.)
    elif char == "nsper":   m = Basemap(projection='nsper',lon_0=meanlon,lat_0=meanlat,satellite_height=h*1000.)
    fontsizemer = int(mpl.rcParams['font.size']*2./3.)
    if char in ["cyl","lcc"]:   step = findstep(wlon)
    else:                       step = 10.
    m.drawmeridians(np.r_[-180.:180.:step*2.], labels=[0,0,0,1], color='grey', fontsize=fontsizemer)
    m.drawparallels(np.r_[-90.:90.:step], labels=[1,0,0,0], color='grey', fontsize=fontsizemer)
    if back == ".":      m.warpimage(marsmap(),scale=0.75)
    elif back == None:   pass 
    else:                m.warpimage(marsmap(back),scale=0.75)
    return m

def marsmap (whichone="vishires"):
	whichlink = 	{ \
		"vis":		"http://maps.jpl.nasa.gov/pix/mar0kuu2.jpg",\
		"vishires":	"http://users.info.unicaen.fr/~karczma/TEACH/InfoGeo/Images/Planets/MarsMap_2500x1250.jpg",\
		"mola":		"http://www.lns.cornell.edu/~seb/celestia/mars-mola-2k.jpg",\
		"molabw":	"http://users.info.unicaen.fr/~karczma/TEACH/InfoGeo/Images/Planets/MarsElevation_2500x1250.jpg",\
			}
	if whichone not in whichlink: 
		print "marsmap: choice not defined... you'll get the default one... "
		whichone = "vishires"  
        return whichlink[whichone]

def earthmap (whichone):
	if   whichone == "contrast":	whichlink="http://users.info.unicaen.fr/~karczma/TEACH/InfoGeo/Images/Planets/EarthMapAtmos_2500x1250.jpg"
	elif whichone == "bw":		whichlink="http://users.info.unicaen.fr/~karczma/TEACH/InfoGeo/Images/Planets/EarthElevation_2500x1250.jpg"
	elif whichone == "nice":	whichlink="http://users.info.unicaen.fr/~karczma/TEACH/InfoGeo/Images/Planets/earthmap1k.jpg"
	return whichlink

