
       module tracer_h

       implicit none

! nqtot : total number of tracers
       INTEGER, SAVE :: nqtot
!$OMP THREADPRIVATE(nqtot)

       character*20, DIMENSION(:), ALLOCATABLE :: noms   ! name of the tracer
       real, DIMENSION(:), ALLOCATABLE :: mmol     ! mole mass of tracer (g/mol-1) 
       real, DIMENSION(:), ALLOCATABLE :: rho_q    ! tracer densities (kg.m-3)

!$OMP THREADPRIVATE(noms,mmol,rho_q)

! tracer indexes: these are initialized in initracer and should be 0 if the
!                 corresponding tracer does not exist

      ! chemistry:
      
      integer :: igcm_h
      integer :: igcm_h2
      integer :: igcm_ch
      integer :: igcm_ch2s
      integer :: igcm_ch2
      integer :: igcm_ch3
      integer :: igcm_ch4
      integer :: igcm_c2
      integer :: igcm_c2h
      integer :: igcm_c2h2
      integer :: igcm_c2h3
      integer :: igcm_c2h4
      integer :: igcm_c2h5
      integer :: igcm_c2h6
      integer :: igcm_c3h3
      integer :: igcm_c3h5
      integer :: igcm_c3h6
      integer :: igcm_c3h7
      integer :: igcm_c4h
      integer :: igcm_c4h3
      integer :: igcm_c4h4
      integer :: igcm_c4h2s
      integer :: igcm_ch2cch2
      integer :: igcm_ch3cch
      integer :: igcm_c3h8
      integer :: igcm_c4h2
      integer :: igcm_c4h6
      integer :: igcm_c4h10
      integer :: igcm_ac6h6
      integer :: igcm_c3h2
      integer :: igcm_c4h5
      integer :: igcm_ac6h5
      integer :: igcm_n2
      integer :: igcm_n4s
      integer :: igcm_cn
      integer :: igcm_hcn
      integer :: igcm_h2cn
      integer :: igcm_chcn
      integer :: igcm_ch2cn
      integer :: igcm_ch3cn
      integer :: igcm_c3n
      integer :: igcm_hc3n
      integer :: igcm_nccn
      integer :: igcm_c4n2 
      
      
!$OMP THREADPRIVATE(igcm_h,igcm_h2,igcm_ch,igcm_ch2s,igcm_ch2,igcm_ch3,igcm_ch4,   &
      !$OMP igcm_c2,igcm_c2h,igcm_c2h2,igcm_c2h3,igcm_c2h4,igcm_c2h5,igcm_c2h6,    &
      !$OMP igcm_c3h3,igcm_c3h5,igcm_c3h6,igcm_c3h7,igcm_c4h,igcm_c4h3,igcm_c4h4,  &
      !$OMP igcm_c4h2s,igcm_ch2cch2,igcm_ch3cch,igcm_c3h8,igcm_c4h2,igcm_c4h6,     &
      !$OMP igcm_c4h10,igcm_ac6h6,igcm_c3h2,igcm_c4h5,igcm_ac6h5,igcm_n2,igcm_n4s, &
      !$OMP igcm_cn,igcm_hcn,igcm_h2cn,igcm_chcn,igcm_ch2cn,igcm_ch3cn,igcm_c3n,   &
      !$OMP igcm_hc3n,igcm_nccn,igcm_c4n2)

       end module tracer_h

