#!/usr/bin/env python

### A. Spiga LMD 29/05/2011

def usage():
    print 'USAGE:  plot.py file '
    print 'file  : name of input netcdf file.'
    print 'Example:  domain.py /tmp7/aslmd/HELLAS/wrfout_d02_2024-10-03_06:00:00'

def domain (namefile): 
    from netCDF4 import Dataset
    from myplot import getcoord2d,define_proj,makeplotpng,simplinterv
    from matplotlib.pyplot import contourf
    nc  = Dataset(namefile)
    [lon2d,lat2d] = getcoord2d(nc)
    [wlon,wlat] = simplinterv(lon2d,lat2d)
    m = define_proj("ortho",wlon,wlat,back="vishires")
    x, y = m(lon2d, lat2d)
    contourf(x, y, nc.variables['HGT'][0,:,:] / 1000.,50)
    makeplotpng(namefile+".domain",pad_inches_value=0.15)

if __name__ == "__main__":
    import sys
    domain(str(sys.argv[1]))

