      SUBROUTINE initracer(ngrid,nq,nametrac)

      use surfdat_h
      USE tracer_h
      IMPLICIT NONE
c=======================================================================
c   subject:
c   --------
c   Initialization related to tracer 
c   (chemical species, ice...)
c
c   Name of the tracer
c
c   Test of dimension :
c   Initialize COMMON tracer in tracer.h, using tracer names provided
c   by the argument nametrac
c
c   author: F.Forget
c   ------
c            Ehouarn Millour (oct. 2008) identify tracers by their names
c            Jan Vatant d'Ollone (fev. 2017) chemical species for Titan
c=======================================================================

      integer :: ngrid,nq

!      real qsurf(ngrid,nq)       ! tracer on surface (e.g.  kg.m-2)
      character(len=20) :: txt ! to store some text
      integer iq,ig,count
!      logical :: oldnames ! =.true. if old tracer naming convention (q01,...)

      character*20 nametrac(nq)   ! name of the tracer from dynamics


c-----------------------------------------------------------------------
c  radius(nq)      ! aerosol particle radius (m)
c  rho_q(nq)       ! tracer densities (kg.m-3)
c  qext(nq)        ! Single Scat. Extinction coeff at 0.67 um
c  alpha_lift(nq)  ! saltation vertical flux/horiz flux ratio (m-1)
c  alpha_devil(nq) ! lifting coeeficient by dust devil
c-----------------------------------------------------------------------

       nqtot=nq
       !! we allocate once for all arrays in common in tracer_h.F90
       !! (supposedly those are not used before call to initracer)
       IF (.NOT.ALLOCATED(noms)) ALLOCATE(noms(nq))
       ALLOCATE(mmol(nq))
       ALLOCATE(radius(nq))
       ALLOCATE(rho_q(nq))
       ALLOCATE(qext(nq))
       ALLOCATE(alpha_lift(nq))
       ALLOCATE(alpha_devil(nq))
       ALLOCATE(qextrhor(nq))
       !! initialization
       alpha_lift(:)=0.
       alpha_devil(:)=0.
       
       ! Added by JVO 2017 : these arrays are handled later
       ! -> initialization is the least we can do, please !!!
       radius(:)=0.
       qext(:)=0.

! Initialization: get tracer names from the dynamics and check if we are
!                 using 'old' tracer convention ('q01',q02',...)
!                 or new convention (full tracer names)
      ! check if tracers have 'old' names

! copy tracer names from dynamics
        do iq=1,nq
          noms(iq)=nametrac(iq)
        enddo

! Identify tracers by their names: (and set corresponding values of mmol)
      ! 0. initialize tracer indexes to zero:
      ! NB: igcm_* indexes are commons in 'tracer.h'
      
      igcm_h       =0
      igcm_h2      =0
      igcm_ch      =0
      igcm_ch2s    =0
      igcm_ch2     =0
      igcm_ch3     =0
      igcm_ch4     =0
      igcm_c2      =0
      igcm_c2h     =0
      igcm_c2h2    =0
      igcm_c2h3    =0
      igcm_c2h4    =0
      igcm_c2h5    =0
      igcm_c2h6    =0
      igcm_c3h3    =0
      igcm_c3h5    =0
      igcm_c3h6    =0
      igcm_c3h7    =0
      igcm_c4h     =0
      igcm_c4h3    =0
      igcm_c4h4    =0
      igcm_c4h2s   =0
      igcm_ch2cch2 =0
      igcm_ch3cch  =0
      igcm_c3h8    =0
      igcm_c4h2    =0
      igcm_c4h6    =0
      igcm_c4h10   =0
      igcm_ac6h6   =0
      igcm_c3h2    =0
      igcm_c4h5    =0
      igcm_ac6h5   =0
      igcm_n2      =0
      igcm_n4s     =0
      igcm_cn      =0
      igcm_hcn     =0
      igcm_h2cn    =0
      igcm_chcn    =0
      igcm_ch2cn   =0
      igcm_ch3cn   =0
      igcm_c3n     =0
      igcm_hc3n    =0
      igcm_nccn    =0
      igcm_c4n2    =0      
      
      write(*,*) 'initracer: noms() ', noms


      ! 1. find chemistry tracers
      count = 0.
      
      do iq=1,nq
      
        if (noms(iq).eq."h") then
          igcm_h=iq
          mmol(igcm_h)=1.01
          count=count+1
        endif
        if (noms(iq).eq."h2") then
          igcm_h2=iq
          mmol(igcm_h2)=2.0158
          count=count+1
        endif
        if (noms(iq).eq."ch") then
          igcm_ch=iq
          mmol(igcm_ch)=13.02
          count=count+1
        endif
        if (noms(iq).eq."ch2s") then
          igcm_ch2s=iq
          mmol(igcm_ch2s)=14.03
          count=count+1
        endif
        if (noms(iq).eq."ch2") then
          igcm_ch2=iq
          mmol(igcm_ch2)=14.03
          count=count+1
        endif
        if (noms(iq).eq."ch3") then
          igcm_ch3=iq
          mmol(igcm_ch3)=15.03
          count=count+1
        endif
        if (noms(iq).eq."ch4") then
          igcm_ch4=iq
          mmol(igcm_ch4)=16.04
          count=count+1
        endif
        if (noms(iq).eq."c2") then
          igcm_c2=iq
          mmol(igcm_c2)=24.02
          count=count+1
        endif
        if (noms(iq).eq."c2h") then
          igcm_c2h=iq
          mmol(igcm_c2h)=25.03
          count=count+1
        endif
        if (noms(iq).eq."c2h2") then
          igcm_c2h2=iq
          mmol(igcm_c2h2)=26.04
          count=count+1
        endif
        if (noms(iq).eq."c2h3") then
          igcm_c2h3=iq
          mmol(igcm_c2h3)=27.05
          count=count+1
        endif
        if (noms(iq).eq."c2h4") then
          igcm_c2h4=iq
          mmol(igcm_c2h4)=28.05
          count=count+1
        endif
        if (noms(iq).eq."c2h5") then
          igcm_c2h5=iq
          mmol(igcm_c2h5)=29.06
          count=count+1
        endif
        if (noms(iq).eq."c2h6") then
          igcm_c2h6=iq
          mmol(igcm_c2h6)=30.07
          count=count+1
        endif
        if (noms(iq).eq."c3h3") then
          igcm_c3h3=iq
          mmol(igcm_c3h3)=39.06
          count=count+1
        endif
        if (noms(iq).eq."c3h5") then
          igcm_c3h5=iq
          mmol(igcm_c3h5)=41.07
          count=count+1
        endif
        if (noms(iq).eq."c3h6") then
          igcm_c3h6=iq
          mmol(igcm_c3h6)=42.08
          count=count+1
        endif
        if (noms(iq).eq."c3h7") then
          igcm_c3h7=iq
          mmol(igcm_c3h7)=43.09
          count=count+1
        endif
        if (noms(iq).eq."c4h") then
          igcm_c4h=iq
          mmol(igcm_c4h)=49.05
          count=count+1
        endif
        if (noms(iq).eq."c4h3") then
          igcm_c4h3=iq
          mmol(igcm_c4h3)=51.07
          count=count+1
        endif
        if (noms(iq).eq."c4h4") then
          igcm_c4h4=iq
          mmol(igcm_c4h4)=52.08
          count=count+1
        endif
        if (noms(iq).eq."c4h2s") then
          igcm_c4h2s=iq
          mmol(igcm_c4h2s)=50.06
          count=count+1
        endif
        if (noms(iq).eq."ch2cch2") then
          igcm_ch2cch2=iq
          mmol(igcm_ch2cch2)=40.07
          count=count+1
        endif
        if (noms(iq).eq."ch3cch") then
          igcm_ch3cch=iq
          mmol(igcm_ch3cch)=40.07
          count=count+1
        endif
        if (noms(iq).eq."c3h8") then
          igcm_c3h8=iq
          mmol(igcm_c3h8)=44.11
          count=count+1
        endif
        if (noms(iq).eq."c4h2") then
          igcm_c4h2=iq
          mmol(igcm_c4h2)=50.06
          count=count+1
        endif
        if (noms(iq).eq."c4h6") then
          igcm_c4h6=iq
          mmol(igcm_c4h6)=54.09
          count=count+1
        endif
        if (noms(iq).eq."c4h10") then
          igcm_c4h10=iq
          mmol(igcm_c4h10)=58.13
          count=count+1
        endif
        if (noms(iq).eq."ac6h6") then
          igcm_ac6h6=iq
          mmol(igcm_ac6h6)=78.1136
          count=count+1
        endif
        if (noms(iq).eq."c3h2") then
          igcm_c3h2=iq
          mmol(igcm_c3h2)=38.05
          count=count+1
        endif
        if (noms(iq).eq."c4h5") then
          igcm_c4h5=iq
          mmol(igcm_c4h5)=53.07
          count=count+1
        endif
        if (noms(iq).eq."ac6h5") then
          igcm_ac6h5=iq
          mmol(igcm_ac6h5)=77.1136
          count=count+1
        endif
        if (noms(iq).eq."n2") then
          igcm_n2=iq
          mmol(igcm_n2)=28.0134
          count=count+1
        endif
        if (noms(iq).eq."n4s") then
          igcm_n4s=iq
          mmol(igcm_n4s)=14.01
          count=count+1
        endif
        if (noms(iq).eq."cn") then
          igcm_cn=iq
          mmol(igcm_cn)=26.02
          count=count+1
        endif
        if (noms(iq).eq."hcn") then
          igcm_hcn=iq
          mmol(igcm_hcn)=27.04
          count=count+1
        endif
        if (noms(iq).eq."h2cn") then
          igcm_h2cn=iq
          mmol(igcm_h2cn)=28.05
          count=count+1
        endif
        if (noms(iq).eq."chcn") then
          igcm_chcn=iq
          mmol(igcm_chcn)=39.05
          count=count+1
        endif
        if (noms(iq).eq."ch2cn") then
          igcm_ch2cn=iq
          mmol(igcm_cn)=40.04
          count=count+1
        endif
        if (noms(iq).eq."ch3cn") then
          igcm_ch3cn=iq
          mmol(igcm_ch3cn)=41.05
          count=count+1
        endif
        if (noms(iq).eq."c3n") then
          igcm_c3n=iq
          mmol(igcm_c3n)=50.04
          count=count+1
        endif
        if (noms(iq).eq."hc3n") then
          igcm_hc3n=iq
          mmol(igcm_hc3n)=51.05
          count=count+1
        endif
        if (noms(iq).eq."nccn") then
          igcm_nccn=iq
          mmol(igcm_nccn)=52.04
          count=count+1
        endif
        if (noms(iq).eq."c4n2") then
          igcm_c4n2=iq
          mmol(igcm_c4n2)=76.1
          count=count+1
        endif
        

      enddo ! of do iq=1,nq
 
      ! check that we identified all tracers:
      if (count.ne.nq) then
        write(*,*) "initracer: found only ",count," tracers"
        write(*,*) "               expected ",nq
        do iq=1,count
          write(*,*)'      ',iq,' ',trim(noms(iq))
        enddo
!        stop
      else
        write(*,*) "initracer: found all expected tracers, namely:"
        do iq=1,nq
          write(*,*)'      ',iq,' ',trim(noms(iq))
        enddo
      endif


c------------------------------------------------------------
c     Initialisation tracers ....
c------------------------------------------------------------
      call zerophys(nq,rho_q)


c     Output for records:
c     ~~~~~~~~~~~~~~~~~~
      write(*,*)
      Write(*,*) '******** initracer : dust transport parameters :'
      write(*,*) 'alpha_lift = ', alpha_lift
      write(*,*) 'alpha_devil = ', alpha_devil
      write(*,*) 'radius  = ', radius
      
      write(*,*) 'Qext  = ', qext 
      write(*,*)

      end
