subroutine optci(PLEV,TLEV,DTAUI,TAUCUMI,      &
     QXIAER,QSIAER,GIAER,COSBI,WBARI,TAUAERO,  &
     TMID,PMID,TAUGSURF,GWEIGHT)

  use radinc_h
  use radcommon_h, only: gasi,tlimit,Cmk,tgasref,pfgasref,wnoi,scalep,indi,glat_ig
  use gases_h
  use comcstfi_mod, only: g, r
  use callkeys_mod, only: continuum,graybody
  implicit none

  !==================================================================
  !     
  !     Purpose
  !     -------
  !     Calculates longwave optical constants at each level. For each
  !     layer and spectral interval in the IR it calculates WBAR, DTAU
  !     and COSBAR. For each level it calculates TAU.
  !     
  !     TAUI(L,LW) is the cumulative optical depth at level L (or alternatively
  !     at the *bottom* of layer L), LW is the spectral wavelength interval.
  !     
  !     TLEV(L) - Temperature at the layer boundary (i.e., level)
  !     PLEV(L) - Pressure at the layer boundary (i.e., level)
  !
  !     Authors
  !     -------
  !     Adapted from the NASA Ames code by R. Wordsworth (2009)
  !     
  !==================================================================


  real*8 DTAUI(L_NLAYRAD,L_NSPECTI,L_NGAUSS)
  real*8 DTAUKI(L_LEVELS,L_NSPECTI,L_NGAUSS)
  real*8 TAUI(L_NLEVRAD,L_NSPECTI,L_NGAUSS)
  real*8 TAUCUMI(L_LEVELS,L_NSPECTI,L_NGAUSS)
  real*8 PLEV(L_LEVELS)
  real*8 TLEV(L_LEVELS)
  real*8 TMID(L_LEVELS), PMID(L_LEVELS)
  real*8 COSBI(L_NLAYRAD,L_NSPECTI,L_NGAUSS)
  real*8 WBARI(L_NLAYRAD,L_NSPECTI,L_NGAUSS)

  ! for aerosols
  real*8  QXIAER(L_LEVELS,L_NSPECTI,NAERKIND)
  real*8  QSIAER(L_LEVELS,L_NSPECTI,NAERKIND)
  real*8  GIAER(L_LEVELS,L_NSPECTI,NAERKIND)
  real*8  TAUAERO(L_LEVELS,NAERKIND)
  real*8  TAUAEROLK(L_LEVELS,L_NSPECTI,NAERKIND)
  real*8  TAEROS(L_LEVELS,L_NSPECTI,NAERKIND)

  ! Titan customisation
  ! J. Vatant d'Ollone (2016)
  real*8 GWEIGHT(L_NGAUSS)
  real*8 DHAZE_T(L_LEVELS,L_NSPECTI)
  real*8 DHAZES_T(L_LEVELS,L_NSPECTI)
  real*8 SSA_T(L_LEVELS,L_NSPECTI)
  real*8 ASF_T(L_LEVELS,L_NSPECTI)
  real*8 INT_DTAU(L_NLAYRAD,L_NSPECTI)
  real*8 K_HAZE(L_NLAYRAD,L_NSPECTI)

  CHARACTER*2  str2
  ! ==========================

  integer L, NW, NG, K, LK, IAER
  integer MT(L_LEVELS), MP(L_LEVELS), NP(L_LEVELS)
  real*8  ANS, TAUGAS
  real*8  DPR(L_LEVELS), U(L_LEVELS)
  real*8  LCOEF(4), LKCOEF(L_LEVELS,4)

  real*8 taugsurf(L_NSPECTI,L_NGAUSS-1)
  real*8 DCONT,DAERO
  double precision wn_cont, p_cont, p_air, T_cont, dtemp, dtempc
  double precision p_cross

  real*8  KCOEF(4)
   
  ! temporary variable to reduce memory access time to gasi
  real*8 tmpk(2,2)
  
  ! temporary variables for multiple aerosol calculation
  real*8 atemp
  real*8 btemp(L_NLAYRAD,L_NSPECTI)

  ! variables for k in units m^-1
  real*8 dz(L_LEVELS)
  !real*8 rho !! see test below

  integer igas, jgas, ilay

  integer interm

  !! AS: to save time in computing continuum (see bilinearbig)
  IF (.not.ALLOCATED(indi)) THEN
      ALLOCATE(indi(L_NSPECTI,ngasmx,ngasmx))
      indi = -9999  ! this initial value means "to be calculated"
  ENDIF

  !=======================================================================
  !     Determine the total gas opacity throughout the column, for each
  !     spectral interval, NW, and each Gauss point, NG.

  taugsurf(:,:) = 0.0
  dpr(:)        = 0.0
  lkcoef(:,:)   = 0.0

  do K=2,L_LEVELS
     DPR(k) = PLEV(K)-PLEV(K-1)

     ! if we have continuum opacities, we need dz
      dz(k) = dpr(k)*R*TMID(K)/(glat_ig*PMID(K))
      U(k)  = Cmk*DPR(k)     ! only Cmk line in optci.F
      
     call tpindex(PMID(K),TMID(K),pfgasref,tgasref,LCOEF,MT(K),MP(K))

     do LK=1,4
        LKCOEF(K,LK) = LCOEF(LK)
     end do
  end do                    ! levels

  ! Spectral dependance of aerosol absorption
  do iaer=1,naerkind
     DO NW=1,L_NSPECTI
        do K=2,L_LEVELS
           TAEROS(K,NW,IAER) = TAUAERO(K,IAER) * QXIAER(K,NW,IAER)
        end do                    ! levels
     END DO
  end do

  do NW=1,L_NSPECTI

     do K=2,L_LEVELS
     
        ilay = k / 2 ! int. arithmetic => gives the gcm layer index
        
        DAERO=SUM(TAEROS(K,NW,1:naerkind)) ! aerosol absorption

        !================= Titan customisation ========================================
        call disr_haze(dz(k),plev(k),wnoi(nw),dhaze_T(k,nw),SSA_T(k,nw),ASF_T(k,nw))
        ! =============================================================================

        DCONT = 0.0d0 ! continuum absorption

        if(continuum.and.(.not.graybody))then
           ! include continua if necessary
           wn_cont = dble(wnoi(nw))
           T_cont  = dble(TMID(k))
           do igas=1,ngasmx

              p_cont  = dble(PMID(k)*scalep*gfrac(igas,ilay))

              dtemp=0.0d0
              if(igas.eq.igas_N2)then

                 interm = indi(nw,igas,igas)
                 call interpolateN2N2(wn_cont,T_cont,p_cont,dtemp,.false.,interm)
                 indi(nw,igas,igas) = interm

              elseif(igas.eq.igas_H2)then

                 ! first do self-induced absorption
                 interm = indi(nw,igas,igas)
                 call interpolateH2H2(wn_cont,T_cont,p_cont,dtemp,.false.,interm)
                 indi(nw,igas,igas) = interm

                 ! then cross-interactions with other gases
                 do jgas=1,ngasmx
                    p_cross = dble(PMID(k)*scalep*gfrac(jgas,ilay))
                    dtempc  = 0.0d0
                    if(jgas.eq.igas_N2)then 
                       interm = indi(nw,igas,jgas)
                       call interpolateN2H2(wn_cont,T_cont,p_cross,p_cont,dtempc,.false.,interm)
                       indi(nw,igas,jgas) = interm
                    endif
                    dtemp = dtemp + dtempc
                 enddo

               elseif(igas.eq.igas_CH4)then

                 ! first do self-induced absorption
                 interm = indi(nw,igas,igas)
                 call interpolateCH4CH4(wn_cont,T_cont,p_cont,dtemp,.false.,interm)
                 indi(nw,igas,igas) = interm

                 ! then cross-interactions with other gases
                 do jgas=1,ngasmx
                    p_cross = dble(PMID(k)*scalep*gfrac(jgas,ilay))
                    dtempc  = 0.0d0
                    if(jgas.eq.igas_N2)then 
                       interm = indi(nw,igas,jgas)
                       call interpolateN2CH4(wn_cont,T_cont,p_cross,p_cont,dtempc,.false.,interm)
                       indi(nw,igas,jgas) = interm
                    endif
                    dtemp = dtemp + dtempc
                 enddo

              endif

              DCONT = DCONT + dtemp

           enddo

           ! Oobleck test
           !rho = PMID(k)*scalep / (TMID(k)*286.99)
           !if(WNOI(nw).gt.300.0 .and. WNOI(nw).lt.500.0)then
           !   DCONT = rho * 0.125 * 4.6e-4
           !elseif(WNOI(nw).gt.500.0 .and. WNOI(nw).lt.700.0)then
           !   DCONT = 1000*dpr(k) * 1.0 * 4.6e-4 / g
           !   DCONT = rho * 1.0 * 4.6e-4
           !elseif(WNOI(nw).gt.700.0 .and. WNOI(nw).lt.900.0)then
           !   DCONT = rho * 0.125 * 4.6e-4
           !endif

           DCONT = DCONT*dz(k)

        endif

        do ng=1,L_NGAUSS-1

           ! Now compute TAUGAS

           ! JVO 2017 : added tmpk because the repeated calls to gasi/v increased dramatically
           ! the execution time of optci/v -> ~ factor 2 on the whole radiative
           ! transfer on the tested simulations !

           tmpk = GASI(MT(K):MT(K)+1,MP(K):MP(K)+1,1,NW,NG)

           KCOEF(1) = tmpk(1,1) ! KCOEF(1) = GASI(MT(K),MP(K),1,NW,NG)
           KCOEF(2) = tmpk(1,2) ! KCOEF(2) = GASI(MT(K),MP(K)+1,1,NW,NG)
           KCOEF(3) = tmpk(2,2) ! KCOEF(3) = GASI(MT(K)+1,MP(K)+1,1,NW,NG)
           KCOEF(4) = tmpk(2,1) ! KCOEF(4) = GASI(MT(K)+1,MP(K),1,NW,NG)


           ! Interpolate the gaseous k-coefficients to the requested T,P values

           ANS = LKCOEF(K,1)*KCOEF(1) + LKCOEF(K,2)*KCOEF(2) +            &
                LKCOEF(K,3)*KCOEF(3) + LKCOEF(K,4)*KCOEF(4)

           TAUGAS  = U(k)*ANS

           TAUGSURF(NW,NG) = TAUGSURF(NW,NG) + TAUGAS + DCONT
           DTAUKI(K,nw,ng) = TAUGAS    & 
                             + DCONT   & ! For parameterized continuum absorption
			     + DAERO   & ! For aerosol absorption
			     + DHAZE_T(K,NW)  ! For Titan haze

        end do

        ! Now fill in the "clear" part of the spectrum (NG = L_NGAUSS),
        ! which holds continuum opacity only

        NG              = L_NGAUSS
        DTAUKI(K,nw,ng) = 0.d0      & 
                          + DCONT   & ! For parameterized continuum absorption
	                  + DAERO   & ! For aerosol absorption
	                  + DHAZE_T(K,NW)     ! For Titan Haze

     end do
  end do

  !=======================================================================
  !     Now the full treatment for the layers, where besides the opacity
  !     we need to calculate the scattering albedo and asymmetry factors
  ! ======================================================================

  do iaer=1,naerkind
    DO NW=1,L_NSPECTI
     DO K=2,L_LEVELS
           TAUAEROLK(K,NW,IAER) = TAUAERO(K,IAER)*QSIAER(K,NW,IAER) ! effect of scattering albedo
     ENDDO
    ENDDO
  end do
  
  ! Haze scattering
  DO NW=1,L_NSPECTI
    DO K=2,L_LEVELS
      DHAZES_T(K,NW) = DHAZE_T(K,NW) * SSA_T(K,NW)
    ENDDO
  ENDDO

  DO NW=1,L_NSPECTI
     DO L=1,L_NLAYRAD-1
        K              = 2*L+1
        btemp(L,NW) = SUM(TAUAEROLK(K,NW,1:naerkind)) + SUM(TAUAEROLK(K+1,NW,1:naerkind)) &
                      + DHAZES_T(K,NW) + DHAZES_T(K+1,NW)
     END DO ! L vertical loop
     
     ! Last level
     L           = L_NLAYRAD
     K           = 2*L+1
     btemp(L,NW) = SUM(TAUAEROLK(K,NW,1:naerkind)) + DHAZES_T(K,NW)
     
  END DO                    ! NW spectral loop
  

  DO NW=1,L_NSPECTI
     NG = L_NGAUSS
     DO L=1,L_NLAYRAD-1

        K              = 2*L+1
        DTAUI(L,nw,ng) = DTAUKI(K,NW,NG) + DTAUKI(K+1,NW,NG)! + 1.e-50

        atemp = 0.
        if(DTAUI(L,NW,NG) .GT. 1.0D-9) then
           do iaer=1,naerkind
              atemp = atemp +                                     &
                   GIAER(K,NW,IAER)   * TAUAEROLK(K,NW,IAER) +    &
                   GIAER(K+1,NW,IAER) * TAUAEROLK(K+1,NW,IAER)
           end do
           atemp = atemp +                   &
                ASF_T(K,NW)*DHAZES_T(K,NW) + &
                ASF_T(K+1,NW)*DHAZES_T(K+1,NW)

           WBARI(L,nw,ng) = btemp(L,nw)  / DTAUI(L,NW,NG)
        else
           WBARI(L,nw,ng) = 0.0D0
           DTAUI(L,NW,NG) = 1.0D-9
        endif

        if(btemp(L,nw) .GT. 0.0d0) then
           cosbi(L,NW,NG) = atemp/btemp(L,nw)
        else
           cosbi(L,NW,NG) = 0.0D0
        end if

     END DO ! L vertical loop
     
     ! Last level
     
     L              = L_NLAYRAD
     K              = 2*L+1
     DTAUI(L,nw,ng) = DTAUKI(K,NW,NG) ! + 1.e-50

     atemp = 0.
     if(DTAUI(L,NW,NG) .GT. 1.0D-9) then
        do iaer=1,naerkind
           atemp = atemp + GIAER(K,NW,IAER)   * TAUAEROLK(K,NW,IAER)
        end do
        atemp = atemp + ASF_T(K,NW)*DHAZES_T(K,NW)
        WBARI(L,nw,ng) = btemp(L,nw)  / DTAUI(L,NW,NG)
     else
        WBARI(L,nw,ng) = 0.0D0
        DTAUI(L,NW,NG) = 1.0D-9
     endif

     if(btemp(L,nw) .GT. 0.0d0) then
        cosbi(L,NW,NG) = atemp/btemp(L,nw)
     else
        cosbi(L,NW,NG) = 0.0D0
     end if


     ! Now the other Gauss points, if needed.

     DO NG=1,L_NGAUSS-1
        IF(TAUGSURF(NW,NG) .gt. TLIMIT) THEN

           DO L=1,L_NLAYRAD-1
              K              = 2*L+1
              DTAUI(L,nw,ng) = DTAUKI(K,NW,NG)+DTAUKI(K+1,NW,NG)! + 1.e-50

              if(DTAUI(L,NW,NG) .GT. 1.0D-9) then

                 WBARI(L,nw,ng) = btemp(L,nw)  / DTAUI(L,NW,NG)

              else
                 WBARI(L,nw,ng) = 0.0D0
                 DTAUI(L,NW,NG) = 1.0D-9
              endif

              cosbi(L,NW,NG) = cosbi(L,NW,L_NGAUSS)
           END DO ! L vertical loop
           
           ! Last level 
           L              = L_NLAYRAD
           K              = 2*L+1
           DTAUI(L,nw,ng) = DTAUKI(K,NW,NG)! + 1.e-50

           if(DTAUI(L,NW,NG) .GT. 1.0D-9) then

              WBARI(L,nw,ng) = btemp(L,nw)  / DTAUI(L,NW,NG)

           else
              WBARI(L,nw,ng) = 0.0D0
              DTAUI(L,NW,NG) = 1.0D-9
           endif

           cosbi(L,NW,NG) = cosbi(L,NW,L_NGAUSS)
           
        END IF

     END DO                 ! NG Gauss loop
  END DO                    ! NW spectral loop

  ! Total extinction optical depths

  DO NG=1,L_NGAUSS       ! full gauss loop
     DO NW=1,L_NSPECTI       
        TAUCUMI(1,NW,NG)=0.0D0
        DO K=2,L_LEVELS
           TAUCUMI(K,NW,NG)=TAUCUMI(K-1,NW,NG)+DTAUKI(K,NW,NG)
        END DO
     END DO                 ! end full gauss loop
  END DO

  ! be aware when comparing with textbook results 
  ! (e.g. Pierrehumbert p. 218) that 
  ! taucumi does not take the <cos theta>=0.5 factor into
  ! account. It is the optical depth for a vertically 
  ! ascending ray with angle theta = 0.


!  Titan's outputs (J.V.O, 2016)===============================================
!      do l=1,L_NLAYRAD
!         do nw=1,L_NSPECTI
!          INT_DTAU(L,NW) = 0.0d+0
!            DO NG=1,L_NGAUSS
!               INT_DTAU(L,NW)= INT_DTAU(L,NW) + dtaui(L,nw,ng)*gweight(NG)
!            enddo
!         enddo
!      enddo

!	do nw=1,L_NSPECTI
!          write(str2,'(i2.2)') nw
!	  call writediagfi(1,'kgi'//str2,'Gaz extinction coefficient IR band '//str2,'m-1',1,int_dtau(L_NLAYRAD:1:-1,nw)/dz_lay(L_NLAYRAD:1:-1))
!          call writediagfi(1,'khi'//str2,'Haze extinction coefficient IR band '//str2,'m-1',1,k_haze(L_NLAYRAD:1:-1,nw)/dz_lay(L_NLAYRAD:1:-1))	
!	enddo  
  
! ==============================================================================  

  return


end subroutine optci



