module cpdet_mod

implicit none

! ADAPTATION OF GCM TO CP(T)
!======================================================================
! From S. Lebonnois in LMD Venus GCM
!
! Cp must be computed using cpdet(t) to be valid
!
! The Exner function is still pk = (play/pref)**RKAPPA
! (RCPD=cpp, RKAPPA=kappa)
!
! One goes from T to teta (potential temperature) using t2tpot(t,teta,pk)
! One goes from teta to T using tpot2t(teta,t,pk)
!
!======================================================================

contains

      FUNCTION cpdet(t)

!      USE control_mod, ONLY: planet_type 
!      USE comconst_mod, ONLY: cpp,t0_venus,nu_venus
      USE module_configure 
      USE module_model_constants
      IMPLICIT none

! for cpp, nu_venus and t0_venus:

      real,intent(in) :: t
      real cpdet

      if (planet.eq."venus") then
          cpdet = cp*(t/TT00)**nu
      else
          cpdet = cp
      endif

      return
      end function cpdet
      
!======================================================================
!======================================================================

      SUBROUTINE t2tpot(npoints, yt, yteta, ypk)
!======================================================================
! Arguments:
!
! yt   --------input-R- Temperature
! yteta-------output-R- Temperature potentielle
! ypk  --------input-R- Fonction d'Exner: (pplay/pref)**RKAPPA
!
!======================================================================

!      USE control_mod, ONLY: planet_type 
!      USE comconst_mod, ONLY: cpp,t0_venus,nu_venus
      USE module_configure
      USE module_model_constants


      IMPLICIT NONE

      integer,intent(in) :: npoints
      REAL,intent(in) :: yt(npoints), ypk(npoints)
      REAL,intent(out) :: yteta(npoints)
      if (planet.eq."venus") then
          yteta = yt**nu                                          &
     &            - nu * TT00**nu * log(ypk)
          yteta = yteta**(1./nu)
      else
          yteta = yt * 1./ypk
      endif

      return
      end subroutine t2tpot

!======================================================================
!======================================================================

      SUBROUTINE tpot2t(npoints,yteta, yt, ypk)
!======================================================================
! Arguments:
!
! yteta--------input-R- Temperature potentielle
! yt   -------output-R- Temperature
! ypk  --------input-R- Fonction d'Exner: (pplay/pref)**RKAPPA
!
!======================================================================

!      USE control_mod, ONLY: planet_type 
!      USE comconst_mod, ONLY: cpp,nu_venus,t0_venus
      USE module_configure
      USE module_model_constants


      IMPLICIT NONE

      integer,intent(in) :: npoints
      REAL,intent(in) :: yteta(npoints), ypk(npoints)
      REAL,intent(out) :: yt(npoints)
      print*,planet
      if (planet.eq."venus") then
         yt = yteta**nu                                           &
     &       + nu * TT00**nu * log(ypk)
         yt = yt**(1./nu)
         print*,yt
      else
          yt = yteta * ypk
      endif
      print*,yt 
      return
      end subroutine tpot2t
end module cpdet_mod
