!
! $Id: $
!
MODULE callphysiq_mod

IMPLICIT NONE

 !! ----------------------------------------------------------
 !! ---- CALL TO NO PHYSICS
 !! ----------------------------------------------------------

CONTAINS

SUBROUTINE call_physiq(planet_type, klon,llm,nqtot,                       &
                       debut_split,lafin_split,                           &
                       jD_cur,jH_cur_split,zdt_split,                     &
                       zplev_omp,zplay_omp,                               &
                       zpk_omp,zphi_omp,zphis_omp,                        &
                       presnivs_omp,                                      &
                       zufi_omp,zvfi_omp,zrfi_omp,ztfi_omp,zqfi_omp,      &
                       flxwfi_omp,                                        &
                       zdufi_omp,zdvfi_omp,zdtfi_omp,zdqfi_omp,zdpsrf_omp)

  IMPLICIT NONE

  character(len=10),INTENT(IN) :: planet_type ! planet type ('earth','mars',...)

  INTEGER,INTENT(IN) :: klon ! (local) number of atmospheric columns
  INTEGER,INTENT(IN) :: llm  ! number of atmospheric layers
  INTEGER,INTENT(IN) :: nqtot ! number of tracers
  LOGICAL,INTENT(IN) :: debut_split ! .true. if very first call to physics
  LOGICAL,INTENT(IN) :: lafin_split ! .true. if last call to physics
  REAL,INTENT(IN) :: JD_cur ! Julian day
  REAL,INTENT(IN) :: JH_cur_split ! Julian hour (fraction of day)
  REAL,INTENT(IN) :: zdt_split ! time step over which the physics are evaluated
  REAL,INTENT(IN) :: zplev_omp(klon,llm+1) ! interlayer pressure (Pa)
  REAL,INTENT(IN) :: zplay_omp(klon,llm) ! mid-layer pressure (Pa)
  REAL,INTENT(INOUT) :: zpk_omp(klon,llm)
  REAL,INTENT(IN) :: zphi_omp(klon,llm) ! geopotential at midlayer
  REAL,INTENT(INOUT) :: zphis_omp(klon) ! surface geopotential
  REAL,INTENT(INOUT) :: presnivs_omp(llm) ! approximate pressure of atm. layers
  REAL,INTENT(IN) :: zufi_omp(klon,llm) ! zonal wind (m/s)
  REAL,INTENT(IN) :: zvfi_omp(klon,llm) ! meridional wind (m/s)
  REAL,INTENT(INOUT) :: zrfi_omp(klon,llm) ! relative wind vorticity, in s-1
  REAL,INTENT(IN) :: ztfi_omp(klon,llm) ! temperature (K)
  REAL,INTENT(IN) :: zqfi_omp(klon,llm,nqtot) ! tracers (*/kg of air)
  REAL,INTENT(IN) :: flxwfi_omp(klon,llm) ! Vertical mass flux on lower mesh interfaces (kg/s) 
  ! tendencies (in */s) from the physics:
  REAL,INTENT(OUT) :: zdufi_omp(klon,llm) ! tendency on zonal winds
  REAL,INTENT(OUT) :: zdvfi_omp(klon,llm) ! tendency on meridional winds
  REAL,INTENT(OUT) :: zdtfi_omp(klon,llm) ! tendency on temperature
  REAL,INTENT(OUT) :: zdqfi_omp(klon,llm,nqtot) ! tendency on tracers
  REAL,INTENT(OUT) :: zdpsrf_omp(klon) ! tendency on surface pressure

END SUBROUTINE call_physiq

END MODULE callphysiq_mod
