!
! $Id: $
!
MODULE callphysiq_mod

IMPLICIT NONE

 !! ----------------------------------------------------------
 !! ---- CALL TO MARS PHYSICS
 !! ----------------------------------------------------------

CONTAINS

SUBROUTINE call_physiq(planet_type, klon,llm,nqtot,                       &
                       debut_split,lafin_split,                           &
                       jD_cur,jH_cur_split,zdt_split,                     &
                       zplev_omp,zplay_omp,                               &
                       zpk_omp,zphi_omp,zphis_omp,                        &
                       presnivs_omp,                                      &
                       zufi_omp,zvfi_omp,zrfi_omp,ztfi_omp,zqfi_omp,      &
                       flxwfi_omp,                                        &
                       zdufi_omp,zdvfi_omp,zdtfi_omp,zdqfi_omp,zdpsrf_omp)

  USE physiq_mod, ONLY: physiq
  USE module_model_constants, only : p0,rcp
  IMPLICIT NONE

  character(len=10),INTENT(IN) :: planet_type ! planet type ('earth','mars',...)

  INTEGER,INTENT(IN) :: klon ! (local) number of atmospheric columns
  INTEGER,INTENT(IN) :: llm  ! number of atmospheric layers
  INTEGER,INTENT(IN) :: nqtot ! number of tracers
  LOGICAL,INTENT(IN) :: debut_split ! .true. if very first call to physics
  LOGICAL,INTENT(IN) :: lafin_split ! .true. if last call to physics
  REAL*4,INTENT(IN) :: JD_cur ! Julian day
  REAL*4,INTENT(IN) :: JH_cur_split ! Julian hour (fraction of day)
  REAL*4,INTENT(IN) :: zdt_split ! time step over which the physics are evaluated
  REAL*4,INTENT(IN) :: zplev_omp(klon,llm+1) ! interlayer pressure (Pa)
  REAL*4,INTENT(IN) :: zplay_omp(klon,llm) ! mid-layer pressure (Pa)
  REAL*4,INTENT(INOUT) :: zpk_omp(klon,llm)
  REAL*4,INTENT(IN) :: zphi_omp(klon,llm) ! geopotential at midlayer
  REAL*4,INTENT(INOUT) :: zphis_omp(klon) ! surface geopotential
  REAL*4,INTENT(INOUT) :: presnivs_omp(llm) ! approximate pressure of atm. layers
  REAL*4,INTENT(IN) :: zufi_omp(klon,llm) ! zonal wind (m/s)
  REAL*4,INTENT(IN) :: zvfi_omp(klon,llm) ! meridional wind (m/s)
  REAL*4,INTENT(INOUT) :: zrfi_omp(klon,llm) ! relative wind vorticity, in s-1
  REAL*4,INTENT(IN) :: ztfi_omp(klon,llm) ! temperature (K)
  REAL*4,INTENT(IN) :: zqfi_omp(klon,llm,nqtot) ! tracers (*/kg of air)
  REAL*4,INTENT(IN) :: flxwfi_omp(klon,llm) ! Vertical mass flux on lower mesh interfaces (kg/s) 
  ! tendencies (in */s) from the physics:
  REAL*4,INTENT(OUT) :: zdufi_omp(klon,llm) ! tendency on zonal winds
  REAL*4,INTENT(OUT) :: zdvfi_omp(klon,llm) ! tendency on meridional winds
  REAL*4,INTENT(OUT) :: zdtfi_omp(klon,llm) ! tendency on temperature
  REAL*4,INTENT(OUT) :: zdqfi_omp(klon,llm,nqtot) ! tendency on tracers
  REAL*4,INTENT(OUT) :: zdpsrf_omp(klon) ! tendency on surface pressure

!  ! Local variables
!  CHARACTER(len=11) :: modname="call_physiq"
!  LOGICAL,SAVE :: firstcall=.true.
!!$OMP THREADPRIVATE(firstcall)
!
!! Sanity check on physics package type
!  IF (firstcall) THEN
!    IF (planet_type.ne."mars") THEN
!      CALL abort_gcm(modname,"wrong planet_type for this physics package",1)
!    ENDIF
!    firstcall=.false.
!  ENDIF

! Sanity check on physics package type
 IF (debut_split) THEN
   IF (planet_type.ne."venus") THEN
     PRINT*,"wrong planet_type for this physics package"
     STOP
   ENDIF
 ENDIF

! Set dummy variables for Mars to zero (additional and prob useless security)
  zpk_omp=(zplay_omp/p0)**rcp
  zphis_omp(:)=zphi_omp(1,1)
  presnivs_omp(:)=0.
  zrfi_omp(:,:)=0.
! Call physics package with required inputs/outputs
  CALL physiq(klon,           &
              llm,            &
              nqtot,          &
              debut_split,    &
              lafin_split,    &
              jD_cur,         &
              jH_cur_split,   &
              zdt_split,      &
              zplev_omp,      &
              zplay_omp,      &
              zpk_omp,        &
              zphi_omp,       &
              zphis_omp,      &
              presnivs_omp,   &
              zufi_omp,       &
              zvfi_omp,       &
              ztfi_omp,       &
              zqfi_omp,       &
              flxwfi_omp,     &
              zdufi_omp,      &
              zdvfi_omp,      &
              zdtfi_omp,      &
              zdqfi_omp,      &
              zdpsrf_omp)

END SUBROUTINE call_physiq

END MODULE callphysiq_mod
