MODULE thermcell
!      USE ioipsl_getincom
      IMPLICIT NONE

      INTEGER :: iflag_thermals
      REAL :: r_aspect_thermals,l_mix_thermals,tau_thermals
      INTEGER :: w2di_thermals
      INTEGER :: nsplit_thermals
      INTEGER :: isplit
      INTEGER :: iflag_coupl,iflag_clos,iflag_wake
      INTEGER :: iflag_thermals_ed,iflag_thermals_optflux
      REAL :: RG,RD
      REAL :: rlvtt,rcpd,rtt,r2es
      REAL :: retv,r5les,r5ies,rkappa
      REAL :: R4LES,R4IES,R3IES,R3LES
      INTEGER :: klon,klev
      INTEGER :: prt_level,lunout
      real,allocatable :: rlatd(:)
      real,allocatable :: rlond(:)

! Thermodynamic constants. The [OK] means that the constant has been made
! compatible with the Martian model
! ----------------------------------

! RG : mars mean gravity field                          [OK]
! RD : dry air constant = 1000 R/Mair                   [OK]
! rlvtt : value of Lv(Tt) (vapo. latent heat at Tt)     [dep. on air ?]
! rcpd : Cp of dry air = 7/2 RD for a perfect gas       [OK,CHECK VALUE with gcm one]
!rcpd = r/(r/CP), avec r/CP = 1/4.4 pour LES, 0.256793 pour gcm (1./3.89419), et r=1000.R/Mair=RD
! rtt : triple point temperature Tt                     [OK]
! r2es :                                                [Probably OK]
! retv = restt*RD/RV :                                  [-]
! restt : saturation pressure at Tt es(Tt) = 611.14 Pa  [dep. on air ?]
! RV : vapor constant = 1000 R/Mh2o                     [OK]
! r3les :                                               [Probably OK]
! r3ies :                                               [Probably OK]
! r4les :                                               [Probably OK]
! r4ies :                                               [Probably OK]
! r5ies = r3ies*(rtt-r4les)                             [Probably OK]
! rkappa = RD/RCPD = r/cp = 0.256793  			[OK]
! FOEEW : vapeur d'eau saturante			[OK]
! FOEDE : derive par rapport a la temperature		[OK]
      PARAMETER (RG=3.72,RD=191.182)
      PARAMETER (rlvtt=2.5008E+06,rcpd=RD*3.89419)
      PARAMETER (rtt=273.16,r2es=253.156)
      PARAMETER (retv=1.41409,r5les=4097.93)
      PARAMETER (r5ies=5807.81,rkappa=1./3.89419)
      PARAMETER (R4IES=7.66,R4LES=35.86)
      PARAMETER (R3IES=21.875,R3LES=17.269)

! r_aspect_thermals : rapport d'aspect : parameter defined in FH's HDR
!   length over height ratio of the thermals in the alimentation layer (check)
!   it's value is advised to be set to 2 in HDR           [OK]
! l_mix_thermals : mixing length => lambda : parameter for plume penetration in
! the atm (the plum size will decrease with sqrt(lambda) : USELESS
! w2di_thermals : ?
! tau_thermals : relaxation length of the thermals : the model implements the thermals 
!   tendancies with a typical relaxation time. Typical value is said to be 1800 s in the
!   code however, it is found at 720 s in the .def files  [OK]
! nsplit_thermals : subdivisions of the timestep in the calculations of the plume.
!   Increase the calculation precision greatly, but also computation time
!   typical value is found at 1 in .def (no split)        [OK]
! prt_level : print level for the gcm printed outputs     [OK]
! lunout : output channel for prt level                   [OK]
! iflag_thermals : choice of the thermals version. 15 and 16 are the newest ones
!   and 16 activates "bidouille stratocu" which is required for now
! 							  [OK]
! iflag_thermals_ed : choice of the plume version
!   8 is the normal version, 9 is the working version of AJ, 10 is CR
!   also used for cases .ge.1 in thermcell_height         [OK]
! iflag_coupl : USELESS ? 				  [useless ?]
! iflag_clos : USELESS ?				  [useless ?]
! iflag_wake : USELESS ?				  [useless ?]
      PARAMETER (r_aspect_thermals = 3.)
      PARAMETER (l_mix_thermals = 30.)
      PARAMETER (w2di_thermals = 1)
!      PARAMETER (tau_thermals = 720.)
!      PARAMETER (nsplit_thermals = 1)
      PARAMETER (prt_level=0,lunout=6)
      PARAMETER (iflag_thermals=20,iflag_thermals_ed=10)
      PARAMETER (iflag_thermals_optflux=1,iflag_coupl=1)
      PARAMETER (iflag_clos=2)

      CONTAINS
        FUNCTION foede(PTARG,PDELARG,P5ARG,PQSARG,PCOARG)
          IMPLICIT NONE
          REAL :: foede
          REAL, INTENT(IN) :: PTARG,PDELARG,P5ARG,PQSARG,PCOARG
          foede = PQSARG*PCOARG*P5ARG &
       & / (PTARG-(R4LES*(1.-PDELARG)+R4IES*PDELARG))**2
        END FUNCTION foede

        FUNCTION foeew(PTARG,PDELARG)
          IMPLICIT NONE
          REAL :: foeew
          REAL, INTENT(IN) :: PTARG,PDELARG
          foeew = EXP (                                   &
       &          (R3LES*(1.-PDELARG)+R3IES*PDELARG) * (PTARG-RTT)        &
       & / (PTARG-(R4LES*(1.-PDELARG)+R4IES*PDELARG)) )

        END FUNCTION foeew

! Variables which have been moved to .def and called independantly :
! nsplit_thermals, tau

END MODULE thermcell


