#! /bin/bash

################################
# A. Spiga 09/06/2015
# Install the LMD mesoscale model
################################
# prerequisite: NETCDF
# -- NETCDF env variable
################################
## DEFAULT
## name of the folder
name="MESORUN"
## SVN version
version="HEAD"
version="1520"
################################

meso="on"
while getopts "gn:h" options; do
  case $options in
   n ) name="${OPTARG}";;
   g ) meso="off";; 
   h ) echo "
# OPTIONS
# -n [name] --> name of the folder to be created
# -g        --> only compile GCM (for tests)
" ; exit ;;
  esac
done

################################
## machine on which you will compile
machine="CICLAD"
## fortran compiler used
fortcom="ifort"
## server for sources
where_is_svn="http://svn.lmd.jussieu.fr/Planeto/trunk/"
## grid definition for GCM
dimgcm="64x48x29"
## location of static data
webrepo="http://data.spiga.fr/mesoscale_model/STATIC_DATA/"
## TBD: datadir: http://www.lmd.jussieu.fr/~lmdz/planets/mars/datadir/
################################

## -----------------------------
## import settings and structure
## -----------------------------
echo "*** get structure"
rm -rf $name > /dev/null 2> /dev/null
svn -q co $where_is_svn"/MESOSCALE/LMD_MM_MARS/SIMU/MESORUN" $name
refrepo=$PWD/$name
## fill here user input to obtain independent script
case ${fortcom} in
  "ifort") echo 1 > $refrepo/wpsin ; echo 5 > $refrepo/mesoin ; echo 1 >> $refrepo/mesoin ;;
esac

## ----------------
## create code repo
## ----------------
echo "*** get SVN repository"
\rm $refrepo/code
svn -q co -N $where_is_svn $refrepo/code

## ------------
## get GCM code
## ------------
echo "*** get GCM code version "$version
cd $refrepo/code
svn -q update -r $version LMDZ.MARS 
svn -q update -r $version LMDZ.COMMON
cd $refrepo/code/LMDZ.COMMON
svn -q co http://forge.ipsl.jussieu.fr/fcm/svn/PATCHED/FCM_V1.2
ln -sf FCM_V1.2/bin/fcm .

## --------------
## compile IOIPSL
## --------------
log=$refrepo/code/logcompile_ioipsl
echo "*** compile IOIPSL: check progress in "$log
rm -rf $log ; touch $log
cd $refrepo/code/LMDZ.COMMON/ioipsl
./install_ioipsl_$fortcom".bash" > $log 2> $log

## -----------
## compile GCM
## -----------
log=$refrepo/code/logcompile_gcm
echo "*** compile GCM: check progress in "$log
rm -rf $log ; touch $log
cd $refrepo/code/LMDZ.COMMON
./makelmdz_fcm -cpp MESOINI -j 8 -s 2 -d $dimgcm -arch $machine$fortcom -parallel mpi -p mars gcm > $log 2> $log
./makelmdz_fcm              -j 8 -s 2 -d $dimgcm -arch $machine$fortcom               -p mars newstart >> $log 2>> $log
cd $refrepo/gcm
\rm gcm.e
ln -sf $refrepo/code/LMDZ.COMMON/bin/gcm_$dimgcm"_phymars_para.e" gcm.e
cd $refrepo/gcm/newstart
\rm newstart.e
ln -sf $refrepo/code/LMDZ.COMMON/bin/newstart_$dimgcm"_phymars_seq.e" newstart.e

## START MESOSCALE PART
if [[ "${meso}" == "on" ]]
then

## ----------------------
## get and make mesoscale
## ----------------------
echo "*** get and compile mesoscale version "$version
cd $refrepo/code
svn update -r $version MESOSCALE > /dev/null
cd $refrepo/code/MESOSCALE/LMD_MM_MARS
ls $refrepo/mesoin
if [[ "$?" == 0 ]] ; then
  ./makemeso -p < $refrepo/mesoin
else
  ./makemeso -p
fi
rm -rf $refrepo/mesoin
rm -rf $refrepo/code_compiled
ln -sf $refrepo/code/MESOSCALE/LMD_MM_MARS/LATEST $refrepo/code_compiled

## -------------------------------
## make ini&bdy tools in mesoscale
## -------------------------------
echo "*** compile initialization tools"
cd $refrepo/code_compiled
ln -sf $refrepo/code/MESOSCALE/LMD_MM_MARS/SRC/SCRIPTS/prepare_ini .
./prepare_ini > /dev/null
##
cd $refrepo/code_compiled/PREP_MARS
./compile"_"$fortcom
##
cd $refrepo/code_compiled/WPS
ls $refrepo/wpsin
if [[ "$?" == 0 ]] ; then
  ./configure < $refrepo/wpsin > /dev/null 2> /dev/null
else
  ./configure
fi
rm -rf $refrepo/wpsin
rm -rf logcompile
./compile > logcompile 2>&1

## ------------------
## import static data
## ------------------
echo "*** get static data"
rm -rf $refrepo/data_static
svn co -q $where_is_svn/MESOSCALE/LMD_MM_MARS/WPS_GEOG $refrepo/data_static
cd $refrepo/data_static
rm -rf logdown
wget $webrepo"/albedo_TES.tar.gz" -a logdown
wget $webrepo"/mola_topo64.tar.gz" -a logdown
wget $webrepo"/thermal_TES.tar.gz" -a logdown
for fff in *.tar.gz; do
  tar xzvf $fff > /dev/null
  rm -rf $fff
done

## ------------------------
## get and compile postproc
## ------------------------
echo "*** get and compile post-processing tool"
cd $refrepo
svn co -q https://github.com/aymeric-spiga/api/trunk postproc
cd $refrepo/postproc
./compile

fi
## END MESOSCALE PART

## ------------------------
## make a minimal startbase
## ------------------------
echo "*** make a minimal startbase"
cd $refrepo/gcm/newstart
./mini_startbase.sh

## -----
## check
## -----
echo "*** CHECKLIST:"
ls -lL $refrepo/gcm/gcm.e
ls -lL $refrepo/geogrid/geogrid.exe
ls -lL $refrepo/metgrid/metgrid.exe
ls -lL $refrepo/prep/readmeteo.exe
ls -lL $refrepo/data_static/albedo_TES
ls -lL $refrepo/real.exe
ls -lL $refrepo/wrf.exe
ls -lL $refrepo/postproc/api

