
       module comgeomfi_h

       implicit none

       ! These arrays are allocated in phys_state_var_init
!       REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: long ! longitudes (rad)
!       REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: lati ! latitudes (rad)
!       REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: area ! mesh area (m2)
!       REAL,SAVE :: totarea
       REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: sinlon 
       REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: coslon
       REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: sinlat
       REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: coslat

       contains

         subroutine ini_comgeomfi_h(ngrid)

         implicit none
         integer,intent(in) :: ngrid ! number of atmospheric columns

!        allocate(lati(ngrid))
!         allocate(long(ngrid))
!         allocate(area(ngrid))
         allocate(sinlat(ngrid))
         allocate(coslat(ngrid))
         allocate(sinlon(ngrid))
         allocate(coslon(ngrid))

         end subroutine ini_comgeomfi_h

         subroutine ini_fillgeom(ngrid,plat,plon,parea)

         implicit none
         INTEGER,INTENT(IN) :: ngrid ! number of atmospheric columns
         REAL,INTENT(IN) :: plat(ngrid),plon(ngrid),parea(ngrid)
         EXTERNAL SSUM
         REAL SSUM
         integer :: ig

         ! fill "comgeomfi_h" data
!         call SCOPY(ngrid,plon,1,long,1)
!         call SCOPY(ngrid,plat,1,lati,1)
!         call SCOPY(ngrid,parea,1,area,1)
!         totarea=SSUM(ngrid,area,1)
         DO ig=1,ngrid
            sinlat(ig)=sin(plat(ig))
            coslat(ig)=cos(plat(ig))
            sinlon(ig)=sin(plon(ig))
            coslon(ig)=cos(plon(ig))
         ENDDO

         end subroutine ini_fillgeom

       end module comgeomfi_h

