#!/bin/bash
# script to download and install the latest version of IOIPSL on occigen
#

#0. Preliminary stuff 
module purge
module load intel/15.0.0.090
module load bullxmpi/1.2.8.3
module load hdf5/1.8.14_parallel_bullxmpi
module load netcdf/bullxmpi/4.3.3-rc2
module load netcdf/bullxmpi/fortran-4.4.1_4.3.3-rc2


whereami=`pwd -P`

# 1. Get IOIPSL (via modipsl)
svn co http://forge.ipsl.jussieu.fr/igcmg/svn/modipsl/trunk modipsl
cd modipsl/util

./model IOIPSL

# 2. Set correct settings:
# add a "occigen" configuration to AA_make.gdef
echo "#-Q- occigen  #- Global definitions for Idataplex (occigen) at UPMC, ifort" >> AA_make.gdef
echo "#-Q- occigen  M_K = make" >> AA_make.gdef
echo "#-Q- occigen  P_C = cpp" >> AA_make.gdef
echo '#-Q- occigen  P_O = -P -C $(P_P)' >> AA_make.gdef
echo "#-Q- occigen  F_C = ifort -mcmodel=medium -shared-intel -c" >> AA_make.gdef
echo "#-Q- occigen  #-D- MD    F_D = -g" >> AA_make.gdef
echo "#-Q- occigen  #-D- MN    F_D =" >> AA_make.gdef
echo "#-Q- occigen  #-P- I4R4  F_P = -integer-size 32" >> AA_make.gdef
echo "#-Q- occigen  #-P- I4R8  F_P = -integer-size 32 -real-size 64" >> AA_make.gdef
echo "#-Q- occigen  #-P- I8R8  F_P = -integer-size 64 -real-size 64" >> AA_make.gdef
echo '#-Q- occigen  F_O = -O $(F_D) $(F_P) -I$(MODDIR) -module $(MODDIR)' >> AA_make.gdef
echo "#-Q- occigen  F_L = ifort" >> AA_make.gdef
echo "#-Q- occigen  M_M = 0" >> AA_make.gdef
echo "#-Q- occigen  L_X = 0" >> AA_make.gdef
echo "#-Q- occigen  L_O =" >> AA_make.gdef
echo "#-Q- occigen  A_C = ar -r" >> AA_make.gdef
echo "#-Q- occigen  A_G = ar -x" >> AA_make.gdef
echo "#-Q- occigen  C_C = icc -c" >> AA_make.gdef
echo "#-Q- occigen  C_O =" >> AA_make.gdef
echo "#-Q- occigen  C_L = icc" >> AA_make.gdef
echo "#-Q- occigen  #-" >> AA_make.gdef
echo "#-Q- occigen  NCDF_INC = ${NETCDFF_INCDIR}" >> AA_make.gdef
echo "#-Q- occigen  NCDF_LIB = -L${NETCDFF_LIBDIR} -lnetcdff" >> AA_make.gdef
echo "#-Q- occigen  #-" >> AA_make.gdef

# set default working precision for IOIPSL:
./ins_make -t occigen -p I4R8

## 3. build ioipsl:
cd ../modeles/IOIPSL/src
make

if [[ -f ${whereami}/modipsl/lib/libioipsl.a ]] 
  then
  echo "OK: ioipsl library is in ${whereami}/modipsl/lib"
else
  echo "Something went wrong..."
fi
