#! /bin/bash

################################
# A. Spiga 09/06/2015
# Install the LMD mesoscale model
################################
## name of the folder
name="MESORUN"
## machine on which you will compile
machine="CICLAD"
## fortran compiler used
fortcom="ifort"
## server for sources
where_is_svn="http://svn.lmd.jussieu.fr/Planeto/trunk/"
## grid definition for GCM
dimgcm="64x48x35"
################################

## -----------------------------
## import settings and structure
## -----------------------------
svn export $where_is_svn"/MESOSCALE/LMD_MM_MARS/SIMU/MESORUN" $name
refrepo=$PWD/$name

## -----------
## import code
## -----------
\rm $refrepo/code
svn co -N $where_is_svn $refrepo/code
cd $refrepo/code
svn update LMDZ.MARS
svn update LMDZ.COMMON
svn update MESOSCALE

## ------------------
## import static data
## ------------------
cd $refrepo/code/MESOSCALE/WPS_GEOG
wget http://data.spiga.fr/mesoscale_model/STATIC_DATA/albedo_TES.tar.gz
tar xzvf albedo_TES.tar.gz
\rm albedo_TES.tar.gz
wget http://data.spiga.fr/mesoscale_model/STATIC_DATA/mola_topo64.tar.gz
tar xzvf mola_topo64.tar.gz
\rm mola_topo64.tar.gz
wget http://data.spiga.fr/mesoscale_model/STATIC_DATA/thermal_TES.tar.gz
tar xzvf thermal_TES.tar.gz
\rm thermal_TES.tar.gz

## --------
## make gcm
## --------
cd $refrepo/code/LMDZ.COMMON
./makelmdz_fcm -cpp MESOINI -j 8 -s 2 -d $dimgcm -arch $machine"_"$fortcom -parallel mpi -p mars gcm
cd $refrepo/gcm
\rm gcm.e
ln -sf $refrepo/code/LMDZ.COMMON/bin/gcm_$dimgcm_phymars_para.e gcm.e

## --------------
## make mesoscale
## --------------
cd $refrepo/code/MESOSCALE/LMD_MM_MARS
./makemeso -p
\rm $refrepo/code_compiled
ln -sf $refrepo/code/MESOSCALE/LMD_MM_MARS/LATEST $refrepo/code_compiled

## -------------------------------
## make ini&bdy tools in mesoscale
## -------------------------------
cd $refrepo/code_compiled
ln -sf $refrepo/code/MESOSCALE/LMD_MM_MARS/SRC/SCRIPTS/prepare_ini .
./prepare_ini
cd $refrepo/code_compiled/PREP_MARS
./compile"_"$fortcom
cd $refrepo/code_compiled/WPS
./configure
./compile
